/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.os.Build;
import android.view.Surface;
import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.Extractor;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.encoder.input.decoder.VideoInfo;
import java.nio.ByteBuffer;

public class VideoDecoder
extends BaseDecoder {
    private final VideoDecoderInterface videoDecoderInterface;
    private int width;
    private int height;
    private int fps;

    public VideoDecoder(VideoDecoderInterface videoDecoderInterface2, DecoderInterface decoderInterface2) {
        super(decoderInterface2);
        this.TAG = "VideoDecoder";
        this.videoDecoderInterface = videoDecoderInterface2;
    }

    @Override
    protected boolean extract(Extractor extractor) {
        try {
            this.mime = extractor.selectTrack(MediaFrame.Type.VIDEO);
            VideoInfo info = extractor.getVideoInfo();
            this.mediaFormat = extractor.getFormat();
            this.width = info.getWidth();
            this.height = info.getHeight();
            this.duration = info.getDuration();
            this.fps = info.getFps();
            return true;
        }
        catch (Exception e) {
            this.mime = "";
            return false;
        }
    }

    public boolean prepareVideo(Surface surface) {
        return this.prepare(surface);
    }

    @Override
    protected boolean decodeOutput(ByteBuffer outputBuffer, long timeStamp) {
        return true;
    }

    @Override
    protected void finished() {
        this.videoDecoderInterface.onVideoDecoderFinished();
    }

    public void changeOutputSurface(Surface surface) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.codec.setOutputSurface(surface);
        } else {
            this.resetCodec(surface);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFps() {
        return this.fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseRender() {
        Object object = this.sync;
        synchronized (object) {
            this.pause.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRender() {
        Object object = this.sync;
        synchronized (object) {
            this.pause.set(false);
        }
    }
}

