/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(api=18)
public class ManagerRender {
    public static int numFilters = 0;
    private final CameraRender cameraRender;
    private final List<BaseFilterRender> filterRenders = new ArrayList<BaseFilterRender>();
    private final ScreenRender screenRender;
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    private Context context;

    public ManagerRender() {
        this.cameraRender = new CameraRender();
        this.screenRender = new ScreenRender();
    }

    public void initGl(Context context, int encoderWidth, int encoderHeight, int previewWidth, int previewHeight) {
        this.context = context;
        this.width = encoderWidth;
        this.height = encoderHeight;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.cameraRender.initGl(this.width, this.height, context, previewWidth, previewHeight);
        this.screenRender.setStreamSize(encoderWidth, encoderHeight);
        this.screenRender.setTexId(this.cameraRender.getTexId());
        this.screenRender.initGl(context);
    }

    public void drawOffScreen() {
        this.cameraRender.draw();
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.draw();
        }
    }

    public void drawScreen(int width, int height, boolean keepAspectRatio, int mode, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.draw(width, height, keepAspectRatio, mode, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public void release() {
        this.cameraRender.release();
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.release();
        }
        this.filterRenders.clear();
        this.screenRender.release();
    }

    public void enableAA(boolean AAEnabled) {
        this.screenRender.setAAEnabled(AAEnabled);
    }

    public boolean isAAEnabled() {
        return this.screenRender.isAAEnabled();
    }

    public void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.cameraRender.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.cameraRender.getSurface();
    }

    private void setFilter(int position, BaseFilterRender baseFilterRender) {
        int id = this.filterRenders.get(position).getPreviousTexId();
        RenderHandler renderHandler = this.filterRenders.get(position).getRenderHandler();
        this.filterRenders.get(position).release();
        this.filterRenders.set(position, baseFilterRender);
        this.filterRenders.get(position).setPreviousTexId(id);
        this.filterRenders.get(position).initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        this.filterRenders.get(position).setRenderHandler(renderHandler);
    }

    private void addFilter(BaseFilterRender baseFilterRender) {
        this.filterRenders.add(baseFilterRender);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private void addFilter(int position, BaseFilterRender baseFilterRender) {
        this.filterRenders.add(position, baseFilterRender);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private void clearFilters() {
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.release();
        }
        this.filterRenders.clear();
        this.reOrderFilters();
    }

    private void removeFilter(int position) {
        this.filterRenders.remove(position).release();
        this.reOrderFilters();
    }

    private void removeFilter(BaseFilterRender baseFilterRender) {
        baseFilterRender.release();
        this.filterRenders.remove(baseFilterRender);
        this.reOrderFilters();
    }

    private void reOrderFilters() {
        for (int i = 0; i < this.filterRenders.size(); ++i) {
            int texId = i == 0 ? this.cameraRender.getTexId() : this.filterRenders.get(i - 1).getTexId();
            this.filterRenders.get(i).setPreviousTexId(texId);
        }
        int texId = this.filterRenders.isEmpty() ? this.cameraRender.getTexId() : this.filterRenders.get(this.filterRenders.size() - 1).getTexId();
        this.screenRender.setTexId(texId);
    }

    public void setFilterAction(FilterAction filterAction, int position, BaseFilterRender baseFilterRender) {
        switch (filterAction) {
            case SET: {
                if (this.filterRenders.size() > 0) {
                    this.setFilter(position, baseFilterRender);
                    break;
                }
                this.addFilter(baseFilterRender);
                break;
            }
            case SET_INDEX: {
                this.setFilter(position, baseFilterRender);
                break;
            }
            case ADD: {
                if (numFilters > 0 && this.filterRenders.size() >= numFilters) {
                    throw new RuntimeException("limit of filters(" + numFilters + ") exceeded");
                }
                this.addFilter(baseFilterRender);
                break;
            }
            case ADD_INDEX: {
                if (numFilters > 0 && this.filterRenders.size() >= numFilters) {
                    throw new RuntimeException("limit of filters(" + numFilters + ") exceeded");
                }
                this.addFilter(position, baseFilterRender);
                break;
            }
            case CLEAR: {
                this.clearFilters();
                break;
            }
            case REMOVE: {
                this.removeFilter(baseFilterRender);
                break;
            }
            case REMOVE_INDEX: {
                this.removeFilter(position);
                break;
            }
        }
    }

    public int filtersCount() {
        return this.filterRenders.size();
    }

    public void setCameraRotation(int rotation) {
        this.cameraRender.setRotation(rotation);
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.cameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    public void setPreviewSize(int previewWidth, int previewHeight) {
        for (int i = 0; i < this.filterRenders.size(); ++i) {
            this.filterRenders.get(i).setPreviewSize(previewWidth, previewHeight);
        }
    }
}

