/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.render.CameraRender;
import com.pedro.encoder.input.gl.render.RenderHandler;
import com.pedro.encoder.input.gl.render.ScreenRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010\u0016\u001a\u00020\u0012J>\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019J6\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019JF\u0010 \u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0019J\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J.\u0010(\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010+\u001a\u00020\u0019J\b\u0010,\u001a\u00020\u0012H\u0002J\u0006\u0010-\u001a\u00020\u0012J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0016\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u0019J\u000e\u00102\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000bJ\u0018\u00103\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0002J \u00104\u001a\u00020\u00122\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u00107\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/pedro/encoder/input/gl/render/MainRender;", "", "()V", "cameraRender", "Lcom/pedro/encoder/input/gl/render/CameraRender;", "context", "Landroid/content/Context;", "filterRenders", "", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "height", "", "previewHeight", "previewWidth", "screenRender", "Lcom/pedro/encoder/input/gl/render/ScreenRender;", "width", "addFilter", "", "baseFilterRender", "position", "clearFilters", "drawOffScreen", "drawScreen", "keepAspectRatio", "", "mode", "rotation", "flipStreamVertical", "flipStreamHorizontal", "drawScreenEncoder", "isPortrait", "drawScreenPreview", "enableAA", "AAEnabled", "filtersCount", "getSurface", "Landroid/view/Surface;", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "initGl", "encoderWidth", "encoderHeight", "isAAEnabled", "reOrderFilters", "release", "removeFilter", "setCameraFlip", "isFlipHorizontal", "isFlipVertical", "setCameraRotation", "setFilter", "setFilterAction", "filterAction", "Lcom/pedro/encoder/input/gl/FilterAction;", "setPreviewSize", "updateFrame", "encoder_release"})
@RequiresApi(api=18)
public final class MainRender {
    @NotNull
    private final CameraRender cameraRender = new CameraRender();
    @NotNull
    private final ScreenRender screenRender = new ScreenRender();
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    @Nullable
    private Context context;
    @NotNull
    private List<BaseFilterRender> filterRenders = new ArrayList();

    public final void initGl(@NotNull Context context, int encoderWidth, int encoderHeight, int previewWidth, int previewHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.width = encoderWidth;
        this.height = encoderHeight;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.cameraRender.initGl(this.width, this.height, context, previewWidth, previewHeight);
        this.screenRender.setStreamSize(encoderWidth, encoderHeight);
        this.screenRender.setTexId(this.cameraRender.getTexId());
        this.screenRender.initGl(context);
    }

    public final void drawOffScreen() {
        this.cameraRender.draw();
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.draw();
        }
    }

    public final void drawScreen(int width, int height, boolean keepAspectRatio, int mode, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.draw(width, height, keepAspectRatio, mode, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public final void drawScreenEncoder(int width, int height, boolean isPortrait, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.drawEncoder(width, height, isPortrait, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public final void drawScreenPreview(int width, int height, boolean isPortrait, boolean keepAspectRatio, int mode, int rotation, boolean flipStreamVertical, boolean flipStreamHorizontal) {
        this.screenRender.drawPreview(width, height, isPortrait, keepAspectRatio, mode, rotation, flipStreamVertical, flipStreamHorizontal);
    }

    public final void release() {
        this.cameraRender.release();
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.release();
        }
        this.filterRenders.clear();
        this.screenRender.release();
    }

    private final void setFilter(int position, BaseFilterRender baseFilterRender) {
        int id = this.filterRenders.get(position).getPreviousTexId();
        RenderHandler renderHandler = this.filterRenders.get(position).getRenderHandler();
        this.filterRenders.get(position).release();
        this.filterRenders.set(position, baseFilterRender);
        this.filterRenders.get(position).setPreviousTexId(id);
        this.filterRenders.get(position).initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        this.filterRenders.get(position).setRenderHandler(renderHandler);
    }

    private final void addFilter(BaseFilterRender baseFilterRender) {
        this.filterRenders.add(baseFilterRender);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private final void addFilter(int position, BaseFilterRender baseFilterRender) {
        this.filterRenders.add(position, baseFilterRender);
        baseFilterRender.initGl(this.width, this.height, this.context, this.previewWidth, this.previewHeight);
        baseFilterRender.initFBOLink();
        this.reOrderFilters();
    }

    private final void clearFilters() {
        for (BaseFilterRender baseFilterRender : this.filterRenders) {
            baseFilterRender.release();
        }
        this.filterRenders.clear();
        this.reOrderFilters();
    }

    private final void removeFilter(int position) {
        this.filterRenders.remove(position).release();
        this.reOrderFilters();
    }

    private final void removeFilter(BaseFilterRender baseFilterRender) {
        baseFilterRender.release();
        this.filterRenders.remove(baseFilterRender);
        this.reOrderFilters();
    }

    private final void reOrderFilters() {
        int n = this.filterRenders.size();
        for (int i = 0; i < n; ++i) {
            int texId = i == 0 ? this.cameraRender.getTexId() : this.filterRenders.get(i - 1).getTexId();
            this.filterRenders.get(i).setPreviousTexId(texId);
        }
        int texId = this.filterRenders.isEmpty() ? this.cameraRender.getTexId() : this.filterRenders.get(this.filterRenders.size() - 1).getTexId();
        this.screenRender.setTexId(texId);
    }

    public final void setFilterAction(@Nullable FilterAction filterAction, int position, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        FilterAction filterAction2 = filterAction;
        switch (filterAction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[filterAction2.ordinal()]) {
            case 1: {
                if (this.filterRenders.size() > 0) {
                    this.setFilter(position, baseFilterRender);
                    break;
                }
                this.addFilter(baseFilterRender);
                break;
            }
            case 2: {
                this.setFilter(position, baseFilterRender);
                break;
            }
            case 3: {
                this.addFilter(baseFilterRender);
                break;
            }
            case 4: {
                this.addFilter(position, baseFilterRender);
                break;
            }
            case 5: {
                this.clearFilters();
                break;
            }
            case 6: {
                this.removeFilter(baseFilterRender);
                break;
            }
            case 7: {
                this.removeFilter(position);
            }
        }
    }

    public final int filtersCount() {
        return this.filterRenders.size();
    }

    public final void setPreviewSize(int previewWidth, int previewHeight) {
        int n = this.filterRenders.size();
        for (int i = 0; i < n; ++i) {
            this.filterRenders.get(i).setPreviewSize(previewWidth, previewHeight);
        }
    }

    public final void enableAA(boolean AAEnabled) {
        this.screenRender.setAAEnabled(AAEnabled);
    }

    public final boolean isAAEnabled() {
        return this.screenRender.isAAEnabled();
    }

    public final void updateFrame() {
        this.cameraRender.updateTexImage();
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        SurfaceTexture surfaceTexture = this.cameraRender.getSurfaceTexture();
        Intrinsics.checkNotNullExpressionValue((Object)surfaceTexture, (String)"cameraRender.surfaceTexture");
        return surfaceTexture;
    }

    @NotNull
    public final Surface getSurface() {
        Surface surface = this.cameraRender.getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"cameraRender.surface");
        return surface;
    }

    public final void setCameraRotation(int rotation) {
        this.cameraRender.setRotation(rotation);
    }

    public final void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.cameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterAction.values().length];
            nArray[FilterAction.SET.ordinal()] = 1;
            nArray[FilterAction.SET_INDEX.ordinal()] = 2;
            nArray[FilterAction.ADD.ordinal()] = 3;
            nArray[FilterAction.ADD_INDEX.ordinal()] = 4;
            nArray[FilterAction.CLEAR.ordinal()] = 5;
            nArray[FilterAction.REMOVE.ordinal()] = 6;
            nArray[FilterAction.REMOVE_INDEX.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

