/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters.object;

import android.graphics.Typeface;
import android.opengl.GLES20;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.filters.object.BaseObjectFilterRender;
import com.pedro.encoder.utils.gl.TextStreamObject;

@RequiresApi(api=18)
public class TextObjectFilterRender
extends BaseObjectFilterRender {
    private String text;
    private float textSize;
    private int textColor;
    private Typeface typeface;

    public TextObjectFilterRender() {
        this.streamObject = new TextStreamObject();
    }

    @Override
    protected void drawFilter() {
        super.drawFilter();
        GLES20.glBindTexture((int)3553, (int)this.streamObjectTextureId[0]);
        GLES20.glUniform1f((int)this.uAlphaHandle, (float)(this.streamObjectTextureId[0] == -1 ? 0.0f : this.alpha));
    }

    public void setText(String text, float textSize, int textColor) {
        this.setText(text, textSize, textColor, null);
    }

    public void setText(String text, float textSize, int textColor, Typeface typeface) {
        this.text = text;
        this.textSize = textSize;
        this.textColor = textColor;
        this.typeface = typeface;
        ((TextStreamObject)this.streamObject).load(text, textSize, textColor, typeface);
        this.shouldLoad = true;
    }

    public void addText(String text) {
        this.setText(this.text + text, this.textSize, this.textColor, this.typeface);
    }

    public void updateColor(int textColor) {
        this.setText(this.text + this.text, this.textSize, textColor, this.typeface);
    }

    public void updateTypeface(Typeface typeface) {
        this.setText(this.text + this.text, this.textSize, this.textColor, typeface);
    }

    public void updateTextSize(float textSize) {
        this.setText(this.text + this.text, textSize, this.textColor, this.typeface);
    }
}

