/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.TextureLoader;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RequiresApi(api=18)
public class SnowFilterRender
extends BaseFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uTimeHandle = -1;
    private int uSnowHandle = -1;
    private long START_TIME = System.currentTimeMillis();
    private TextureLoader textureLoader = new TextureLoader();
    private StreamObjectBase streamObjectBase;
    private int[] snowTextureId = new int[]{-1};

    public SnowFilterRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.snow_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uTimeHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uTime");
        this.uSnowHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSnow");
        Bitmap snowBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.snow_flakes);
        this.streamObjectBase = new ImageStreamObject();
        ((ImageStreamObject)this.streamObjectBase).load(snowBitmap);
        this.snowTextureId = this.textureLoader.load(this.streamObjectBase.getBitmaps());
    }

    @Override
    protected void drawFilter() {
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        float time = (float)(System.currentTimeMillis() - this.START_TIME) / 1000.0f;
        if (time >= 2.0f) {
            this.START_TIME += 2000L;
        }
        GLES20.glUniform1f((int)this.uTimeHandle, (float)time);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)4);
        GLES20.glActiveTexture((int)33988);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
        GLES20.glUniform1i((int)this.uSnowHandle, (int)5);
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)3553, (int)this.snowTextureId[0]);
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
        this.releaseTextureId();
        if (this.streamObjectBase != null) {
            this.streamObjectBase.recycle();
        }
    }

    private void releaseTextureId() {
        if (this.snowTextureId != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.snowTextureId, (int)0);
        }
        this.snowTextureId = new int[]{-1};
    }
}

