/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.GetCameraData;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class Camera1ApiManager
implements Camera.PreviewCallback,
Camera.FaceDetectionListener {
    private String TAG = "Camera1ApiManager";
    private Camera camera = null;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private SurfaceTexture surfaceTexture;
    private GetCameraData getCameraData;
    private boolean running = false;
    private boolean lanternEnable = false;
    private boolean autoFocusEnabled = false;
    private int cameraSelect;
    private boolean isFrontCamera = false;
    private boolean isPortrait = false;
    private int cameraFacing = 0;
    private Context context;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int rotation = 0;
    private int imageFormat = 17;
    private byte[] yuvBuffer;
    private List<Camera.Size> previewSizeBack;
    private List<Camera.Size> previewSizeFront;
    private float distance;
    private CameraCallbacks cameraCallbacks;
    private FaceDetectorCallback faceDetectorCallback;

    public Camera1ApiManager(SurfaceView surfaceView, GetCameraData getCameraData) {
        this.surfaceView = surfaceView;
        this.getCameraData = getCameraData;
        this.context = surfaceView.getContext();
        this.init();
    }

    public Camera1ApiManager(TextureView textureView, GetCameraData getCameraData) {
        this.textureView = textureView;
        this.getCameraData = getCameraData;
        this.context = textureView.getContext();
        this.init();
    }

    public Camera1ApiManager(SurfaceTexture surfaceTexture, Context context) {
        this.surfaceTexture = surfaceTexture;
        this.context = context;
        this.init();
    }

    private void init() {
        this.cameraSelect = this.selectCameraBack();
        this.previewSizeBack = this.getPreviewSize();
        this.cameraSelect = this.selectCameraFront();
        this.previewSizeFront = this.getPreviewSize();
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void start(CameraHelper.Facing cameraFacing, int width, int height, int fps) {
        int facing = cameraFacing == CameraHelper.Facing.BACK ? 0 : 1;
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.cameraFacing = facing;
        this.cameraSelect = facing == 0 ? this.selectCameraBack() : this.selectCameraFront();
        this.start();
    }

    public void start(int width, int height, int fps) {
        CameraHelper.Facing facing = this.cameraFacing == 0 ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT;
        this.start(facing, width, height, fps);
    }

    private void start() {
        if (!this.checkCanOpen()) {
            throw new CameraOpenException("This camera resolution cant be opened");
        }
        this.yuvBuffer = new byte[this.width * this.height * 3 / 2];
        try {
            this.camera = Camera.open((int)this.cameraSelect);
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.cameraSelect, (Camera.CameraInfo)info);
            this.isFrontCamera = info.facing == 1;
            this.isPortrait = this.context.getResources().getConfiguration().orientation == 1;
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPreviewSize(this.width, this.height);
            parameters.setPreviewFormat(this.imageFormat);
            int[] range = this.adaptFpsRange(this.fps, parameters.getSupportedPreviewFpsRange());
            parameters.setPreviewFpsRange(range[0], range[1]);
            List supportedFocusModes = parameters.getSupportedFocusModes();
            if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("continuous-picture")) {
                    parameters.setFocusMode("continuous-picture");
                    this.autoFocusEnabled = true;
                } else if (supportedFocusModes.contains("auto")) {
                    parameters.setFocusMode("auto");
                    this.autoFocusEnabled = true;
                } else {
                    parameters.setFocusMode((String)supportedFocusModes.get(0));
                    this.autoFocusEnabled = false;
                }
            }
            this.camera.setParameters(parameters);
            this.camera.setDisplayOrientation(this.rotation);
            if (this.surfaceView != null) {
                this.camera.setPreviewDisplay(this.surfaceView.getHolder());
                this.camera.addCallbackBuffer(this.yuvBuffer);
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            } else if (this.textureView != null) {
                this.camera.setPreviewTexture(this.textureView.getSurfaceTexture());
                this.camera.addCallbackBuffer(this.yuvBuffer);
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            } else {
                this.camera.setPreviewTexture(this.surfaceTexture);
            }
            this.camera.startPreview();
            this.running = true;
            if (this.cameraCallbacks != null) {
                this.cameraCallbacks.onCameraChanged(this.isFrontCamera);
            }
            Log.i((String)this.TAG, (String)(this.width + "X" + this.height));
        }
        catch (IOException e) {
            if (this.cameraCallbacks != null) {
                this.cameraCallbacks.onCameraError(e.getMessage());
            }
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    public void setPreviewOrientation(int orientation) {
        this.rotation = orientation;
        if (this.camera != null && this.running) {
            this.camera.stopPreview();
            this.camera.setDisplayOrientation(orientation);
            this.camera.startPreview();
        }
    }

    public void setZoom(MotionEvent event) {
        try {
            if (this.camera != null && this.running && this.camera.getParameters() != null && this.camera.getParameters().isZoomSupported()) {
                Camera.Parameters params = this.camera.getParameters();
                int maxZoom = params.getMaxZoom();
                int zoom = params.getZoom();
                float newDist = CameraHelper.getFingerSpacing(event);
                if (newDist > this.distance) {
                    if (zoom < maxZoom) {
                        ++zoom;
                    }
                } else if (newDist < this.distance && zoom > 0) {
                    --zoom;
                }
                this.distance = newDist;
                params.setZoom(zoom);
                this.camera.setParameters(params);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Error", (Throwable)e);
        }
    }

    private int selectCameraBack() {
        return this.selectCamera(0);
    }

    private int selectCameraFront() {
        return this.selectCamera(1);
    }

    private int selectCamera(int facing) {
        int number = Camera.getNumberOfCameras();
        for (int i = 0; i < number; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing != facing) continue;
            return i;
        }
        return 0;
    }

    public void stop() {
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.setPreviewCallbackWithBuffer(null);
            this.camera.release();
            this.camera = null;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.getCameraData.inputYUVData(new Frame(data, this.rotation, this.isFrontCamera && this.isPortrait, this.imageFormat));
        camera.addCallbackBuffer(this.yuvBuffer);
    }

    public List<Integer> getCameraPreviewImageFormatSupported() {
        List formats;
        if (this.camera != null) {
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            for (Integer i : formats) {
                Log.i((String)this.TAG, (String)("camera format supported: " + i));
            }
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            formats = this.camera.getParameters().getSupportedPreviewFormats();
            this.camera.release();
            this.camera = null;
        }
        return formats;
    }

    private List<Camera.Size> getPreviewSize() {
        List previewSizes;
        Camera.Size maxSize;
        if (this.camera != null) {
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
        } else {
            this.camera = Camera.open((int)this.cameraSelect);
            maxSize = this.getMaxEncoderSizeSupported();
            previewSizes = this.camera.getParameters().getSupportedPreviewSizes();
            this.camera.release();
            this.camera = null;
        }
        Iterator iterator = previewSizes.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            if (size.width <= maxSize.width && size.height <= maxSize.height) continue;
            Log.i((String)this.TAG, (String)(size.width + "X" + size.height + ", not supported for encoder"));
            iterator.remove();
        }
        return previewSizes;
    }

    public List<Camera.Size> getPreviewSizeBack() {
        return this.previewSizeBack;
    }

    public List<Camera.Size> getPreviewSizeFront() {
        return this.previewSizeFront;
    }

    private Camera.Size getMaxEncoderSizeSupported() {
        if (CamcorderProfile.hasProfile((int)8)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 3840, 2160);
        }
        if (CamcorderProfile.hasProfile((int)6)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1920, 1080);
        }
        if (CamcorderProfile.hasProfile((int)5)) {
            Camera camera = this.camera;
            camera.getClass();
            return new Camera.Size(camera, 1280, 720);
        }
        Camera camera = this.camera;
        camera.getClass();
        return new Camera.Size(camera, 640, 480);
    }

    public boolean isFrontCamera() {
        return this.isFrontCamera;
    }

    public void switchCamera() throws CameraOpenException {
        if (this.camera != null) {
            int oldCamera = this.cameraSelect;
            int number = Camera.getNumberOfCameras();
            for (int i = 0; i < number; ++i) {
                if (this.cameraSelect == i) continue;
                this.cameraSelect = i;
                if (!this.checkCanOpen()) {
                    this.cameraSelect = oldCamera;
                    throw new CameraOpenException("This camera resolution cant be opened");
                }
                this.stop();
                this.cameraFacing = this.cameraFacing == 0 ? 1 : 0;
                this.start();
                return;
            }
        }
    }

    private boolean checkCanOpen() {
        List<Camera.Size> previews = this.cameraSelect == this.selectCameraBack() ? this.previewSizeBack : this.previewSizeFront;
        for (Camera.Size size : previews) {
            if (size.width != this.width || size.height != this.height) continue;
            return true;
        }
        return false;
    }

    public boolean isLanternEnabled() {
        return this.lanternEnable;
    }

    public void enableLantern() throws Exception {
        Camera.Parameters parameters;
        List supportedFlashModes;
        if (this.camera != null && (supportedFlashModes = (parameters = this.camera.getParameters()).getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty()) {
            if (supportedFlashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                this.lanternEnable = true;
            } else {
                Log.e((String)this.TAG, (String)"Lantern unsupported");
                throw new Exception("Lantern unsupported");
            }
        }
    }

    public void disableLantern() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            this.lanternEnable = false;
        }
    }

    public void enableAutoFocus() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            List supportedFocusModes = parameters.getSupportedFocusModes();
            if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("continuous-picture")) {
                    parameters.setFocusMode("continuous-picture");
                    this.autoFocusEnabled = true;
                } else if (supportedFocusModes.contains("auto")) {
                    parameters.setFocusMode("auto");
                    this.autoFocusEnabled = true;
                } else {
                    this.autoFocusEnabled = false;
                    parameters.setFocusMode((String)supportedFocusModes.get(0));
                }
            }
            this.camera.setParameters(parameters);
        }
    }

    public void disableAutoFocus() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            List supportedFocusModes = parameters.getSupportedFocusModes();
            if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
                if (supportedFocusModes.contains("infinity")) {
                    parameters.setFocusMode("infinity");
                } else {
                    parameters.setFocusMode((String)supportedFocusModes.get(0));
                }
            }
            this.autoFocusEnabled = false;
            this.camera.setParameters(parameters);
        }
    }

    public boolean isAutoFocusEnabled() {
        return this.autoFocusEnabled;
    }

    public void enableRecordingHint() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setRecordingHint(true);
            this.camera.setParameters(parameters);
        }
    }

    public void disableRecordingHint() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setRecordingHint(false);
            this.camera.setParameters(parameters);
        }
    }

    public void enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        if (this.camera != null) {
            this.faceDetectorCallback = faceDetectorCallback;
            this.camera.setFaceDetectionListener((Camera.FaceDetectionListener)this);
            this.camera.startFaceDetection();
        }
    }

    public void disableFaceDetection() {
        if (this.camera != null) {
            this.faceDetectorCallback = null;
            this.camera.stopFaceDetection();
            this.camera.setFaceDetectionListener(null);
        }
    }

    public void setCameraCallbacks(CameraCallbacks cameraCallbacks) {
        this.cameraCallbacks = cameraCallbacks;
    }

    public boolean isFaceDetectionEnabled() {
        return this.faceDetectorCallback != null;
    }

    public void onFaceDetection(Camera.Face[] faces, Camera camera) {
        if (this.faceDetectorCallback != null) {
            this.faceDetectorCallback.onGetFaces(faces);
        }
    }

    public static interface FaceDetectorCallback {
        public void onGetFaces(Camera.Face[] var1);
    }
}

