/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.EncoderCallback;
import com.pedro.encoder.Frame;
import com.pedro.encoder.utils.CodecUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public abstract class BaseEncoder
implements EncoderCallback {
    private static final String TAG = "BaseEncoder";
    private MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    private HandlerThread handlerThread;
    protected BlockingQueue<Frame> queue = new ArrayBlockingQueue<Frame>(80);
    protected MediaCodec codec;
    protected long presentTimeUs;
    protected volatile boolean running = false;
    protected boolean isBufferMode = true;
    protected CodecUtil.Force force = CodecUtil.Force.FIRST_COMPATIBLE_FOUND;
    private MediaCodec.Callback callback;
    private long oldTimeStamp = 0L;

    public void restart() {
        this.start(false);
        this.initCodec();
    }

    public void start() {
        this.start(true);
        this.initCodec();
    }

    private void initCodec() {
        this.handlerThread = new HandlerThread(TAG);
        this.handlerThread.start();
        Handler handler = new Handler(this.handlerThread.getLooper());
        if (Build.VERSION.SDK_INT >= 23) {
            this.createAsyncCallback();
            this.codec.setCallback(this.callback, handler);
            this.codec.start();
        } else {
            this.codec.start();
            handler.post(new Runnable(){

                @Override
                public void run() {
                    while (BaseEncoder.this.running) {
                        try {
                            BaseEncoder.this.getDataFromEncoder();
                        }
                        catch (IllegalStateException e) {
                            Log.i((String)BaseEncoder.TAG, (String)"Encoding error", (Throwable)e);
                        }
                    }
                }
            });
        }
        this.running = true;
    }

    public abstract void start(boolean var1);

    protected abstract void stopImp();

    protected void fixTimeStamp(MediaCodec.BufferInfo info) {
        if (this.oldTimeStamp > info.presentationTimeUs) {
            info.presentationTimeUs = this.oldTimeStamp;
        } else {
            this.oldTimeStamp = info.presentationTimeUs;
        }
    }

    public void stop() {
        this.running = false;
        this.stopImp();
        if (this.handlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.handlerThread.quitSafely();
            } else {
                this.handlerThread.quit();
            }
        }
        this.queue.clear();
        this.queue = new ArrayBlockingQueue<Frame>(80);
        try {
            this.codec.stop();
            this.codec.release();
            this.codec = null;
        }
        catch (IllegalStateException | NullPointerException e) {
            this.codec = null;
        }
        this.oldTimeStamp = 0L;
    }

    protected abstract MediaCodecInfo chooseEncoder(String var1);

    protected void getDataFromEncoder() throws IllegalStateException {
        int inBufferIndex;
        if (this.isBufferMode && (inBufferIndex = this.codec.dequeueInputBuffer(0L)) >= 0) {
            this.inputAvailable(this.codec, inBufferIndex);
        }
        while (this.running) {
            int outBufferIndex = this.codec.dequeueOutputBuffer(this.bufferInfo, 0L);
            if (outBufferIndex == -2) {
                MediaFormat mediaFormat = this.codec.getOutputFormat();
                this.formatChanged(this.codec, mediaFormat);
                continue;
            }
            if (outBufferIndex < 0) break;
            this.outputAvailable(this.codec, outBufferIndex, this.bufferInfo);
        }
    }

    protected abstract Frame getInputFrame() throws InterruptedException;

    private void processInput(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec mediaCodec, int inBufferIndex) throws IllegalStateException {
        try {
            Frame frame = this.getInputFrame();
            byteBuffer.clear();
            byteBuffer.put(frame.getBuffer(), frame.getOffset(), frame.getSize());
            long pts = System.nanoTime() / 1000L - this.presentTimeUs;
            mediaCodec.queueInputBuffer(inBufferIndex, 0, frame.getSize(), pts, 0);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (NullPointerException e) {
            Log.i((String)TAG, (String)"Encoding error", (Throwable)e);
        }
    }

    protected abstract void checkBuffer(@NonNull ByteBuffer var1, @NonNull MediaCodec.BufferInfo var2);

    protected abstract void sendBuffer(@NonNull ByteBuffer var1, @NonNull MediaCodec.BufferInfo var2);

    private void processOutput(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec mediaCodec, int outBufferIndex, @NonNull MediaCodec.BufferInfo bufferInfo) throws IllegalStateException {
        this.checkBuffer(byteBuffer, bufferInfo);
        this.sendBuffer(byteBuffer, bufferInfo);
        mediaCodec.releaseOutputBuffer(outBufferIndex, false);
    }

    public void setForce(CodecUtil.Force force) {
        this.force = force;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void inputAvailable(@NonNull MediaCodec mediaCodec, int inBufferIndex) throws IllegalStateException {
        ByteBuffer byteBuffer = Build.VERSION.SDK_INT >= 21 ? mediaCodec.getInputBuffer(inBufferIndex) : mediaCodec.getInputBuffers()[inBufferIndex];
        this.processInput(byteBuffer, mediaCodec, inBufferIndex);
    }

    @Override
    public void outputAvailable(@NonNull MediaCodec mediaCodec, int outBufferIndex, @NonNull MediaCodec.BufferInfo bufferInfo) throws IllegalStateException {
        ByteBuffer byteBuffer = Build.VERSION.SDK_INT >= 21 ? mediaCodec.getOutputBuffer(outBufferIndex) : mediaCodec.getOutputBuffers()[outBufferIndex];
        this.processOutput(byteBuffer, mediaCodec, outBufferIndex, bufferInfo);
    }

    @RequiresApi(api=23)
    private void createAsyncCallback() {
        this.callback = new MediaCodec.Callback(){

            public void onInputBufferAvailable(@NonNull MediaCodec mediaCodec, int inBufferIndex) {
                try {
                    BaseEncoder.this.inputAvailable(mediaCodec, inBufferIndex);
                }
                catch (IllegalStateException e) {
                    Log.i((String)BaseEncoder.TAG, (String)"Encoding error", (Throwable)e);
                }
            }

            public void onOutputBufferAvailable(@NonNull MediaCodec mediaCodec, int outBufferIndex, @NonNull MediaCodec.BufferInfo bufferInfo) {
                try {
                    BaseEncoder.this.outputAvailable(mediaCodec, outBufferIndex, bufferInfo);
                }
                catch (IllegalStateException e) {
                    Log.i((String)BaseEncoder.TAG, (String)"Encoding error", (Throwable)e);
                }
            }

            public void onError(@NonNull MediaCodec mediaCodec, @NonNull MediaCodec.CodecException e) {
                Log.e((String)BaseEncoder.TAG, (String)"Error", (Throwable)e);
            }

            public void onOutputFormatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
                BaseEncoder.this.formatChanged(mediaCodec, mediaFormat);
            }
        };
    }
}

