/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import com.pedro.encoder.BaseEncoder;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AudioEncoder
extends BaseEncoder
implements GetMicrophoneData {
    private static final String TAG = "AudioEncoder";
    private GetAacData getAacData;
    private int bitRate = 65536;
    private int sampleRate = 32000;
    private int maxInputSize = 0;
    private boolean isStereo = true;

    public AudioEncoder(GetAacData getAacData) {
        this.getAacData = getAacData;
    }

    public boolean prepareAudioEncoder(int bitRate, int sampleRate, boolean isStereo, int maxInputSize) {
        this.bitRate = bitRate;
        this.sampleRate = sampleRate;
        this.maxInputSize = maxInputSize;
        this.isStereo = isStereo;
        this.isBufferMode = true;
        try {
            MediaCodecInfo encoder = this.chooseEncoder("audio/mp4a-latm");
            if (encoder == null) {
                Log.e((String)TAG, (String)"Valid encoder not found");
                return false;
            }
            this.codec = MediaCodec.createByCodecName((String)encoder.getName());
            int channelCount = isStereo ? 2 : 1;
            MediaFormat audioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
            audioFormat.setInteger("bitrate", bitRate);
            audioFormat.setInteger("max-input-size", maxInputSize);
            audioFormat.setInteger("aac-profile", 2);
            this.codec.configure(audioFormat, null, null, 1);
            this.running = false;
            Log.i((String)TAG, (String)"prepared");
            return true;
        }
        catch (IOException | IllegalStateException e) {
            Log.e((String)TAG, (String)"Create AudioEncoder failed.", (Throwable)e);
            return false;
        }
    }

    public boolean prepareAudioEncoder() {
        return this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo, this.maxInputSize);
    }

    @Override
    public void start(boolean resetTs) {
        if (resetTs) {
            this.presentTimeUs = System.nanoTime() / 1000L;
        }
        Log.i((String)TAG, (String)"started");
    }

    @Override
    protected void stopImp() {
        Log.i((String)TAG, (String)"stopped");
    }

    public void reset() {
        this.stop();
        this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo, this.maxInputSize);
        this.start(false);
    }

    @Override
    protected Frame getInputFrame() throws InterruptedException {
        return (Frame)this.queue.take();
    }

    @Override
    protected void checkBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
    }

    @Override
    protected void sendBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.getAacData.getAacData(byteBuffer, bufferInfo);
    }

    @Override
    public void inputPCMData(Frame frame) {
        if (this.running && !this.queue.offer(frame)) {
            Log.i((String)TAG, (String)"frame discarded");
        }
    }

    @Override
    protected MediaCodecInfo chooseEncoder(String mime) {
        List<Object> encoders = new ArrayList();
        if (this.force == CodecUtil.Force.HARDWARE) {
            encoders = CodecUtil.getAllHardwareEncoders("audio/mp4a-latm");
        } else if (this.force == CodecUtil.Force.SOFTWARE) {
            encoders = CodecUtil.getAllSoftwareEncoders("audio/mp4a-latm");
        }
        if (this.force == CodecUtil.Force.FIRST_COMPATIBLE_FOUND) {
            List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
            for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
                String name = mediaCodecInfo.getName().toLowerCase();
                if (name.contains("omx.google")) continue;
                return mediaCodecInfo;
            }
            if (mediaCodecInfoList.size() > 0) {
                return mediaCodecInfoList.get(0);
            }
            return null;
        }
        if (encoders.isEmpty()) {
            return null;
        }
        return (MediaCodecInfo)encoders.get(0);
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    @Override
    public void formatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
        this.getAacData.onAudioFormat(mediaFormat);
    }
}

