/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters.object;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.Sprite;
import com.pedro.encoder.input.gl.render.filters.object.BaseObjectFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class SurfaceFilterRender
extends BaseObjectFilterRender {
    private final float[] squareVertexDataFilter = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private int program = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int uSamplerHandle = -1;
    private int uSamplerSurfaceHandle = -1;
    private int aTextureObjectHandle = -1;
    private int uAlphaHandle = -1;
    private int[] surfaceId = new int[]{-1};
    private Sprite sprite;
    private FloatBuffer squareVertexSurface;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private float alpha = 1.0f;
    private SurfaceReadyCallback surfaceReadyCallback;

    public SurfaceFilterRender() {
        this(null);
    }

    public SurfaceFilterRender(SurfaceReadyCallback surfaceReadyCallback) {
        this.surfaceReadyCallback = surfaceReadyCallback;
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexDataFilter.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexDataFilter).position(0);
        this.sprite = new Sprite();
        float[] vertices = this.sprite.getTransformedVertices();
        this.squareVertexSurface = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertexSurface.put(vertices).position(0);
        this.sprite.getTransformedVertices();
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    @Override
    protected void initGlFilter(Context context) {
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.object_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.surface_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.aTextureObjectHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureObjectCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uSamplerSurfaceHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSamplerSurface");
        this.uAlphaHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uAlpha");
        GlUtil.createExternalTextures(1, this.surfaceId, 0);
        this.surfaceTexture = new SurfaceTexture(this.surfaceId[0]);
        this.surfaceTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
        this.surface = new Surface(this.surfaceTexture);
        if (this.surfaceReadyCallback != null) {
            this.surfaceReadyCallback.surfaceReady();
        }
    }

    @Override
    protected void drawFilter() {
        this.surfaceTexture.updateTexImage();
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        this.squareVertexSurface.position(0);
        GLES20.glVertexAttribPointer((int)this.aTextureObjectHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.squareVertexSurface);
        GLES20.glEnableVertexAttribArray((int)this.aTextureObjectHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)4);
        GLES20.glActiveTexture((int)33988);
        GLES20.glBindTexture((int)3553, (int)this.previousTexId);
        GLES20.glUniform1i((int)this.uSamplerSurfaceHandle, (int)5);
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)36197, (int)this.surfaceId[0]);
        GLES20.glUniform1f((int)this.uAlphaHandle, (float)(this.surfaceId[0] == -1 ? 0.0f : this.alpha));
    }

    @Override
    public void release() {
        if (this.surfaceId != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.surfaceId, (int)0);
        }
        this.surfaceId = new int[]{-1};
        this.surfaceTexture.release();
        this.surface.release();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Surface getSurface() {
        return this.surface;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void setScale(float scaleX, float scaleY) {
        this.sprite.scale(scaleX, scaleY);
        this.squareVertexSurface.put(this.sprite.getTransformedVertices()).position(0);
    }

    @Override
    public void setPosition(float x, float y) {
        this.sprite.translate(x, y);
        this.squareVertexSurface.put(this.sprite.getTransformedVertices()).position(0);
    }

    @Override
    public void setPosition(TranslateTo positionTo) {
        this.sprite.translate(positionTo);
        this.squareVertexSurface.put(this.sprite.getTransformedVertices()).position(0);
    }

    @Override
    public PointF getScale() {
        return this.sprite.getScale();
    }

    @Override
    public PointF getPosition() {
        return this.sprite.getTranslation();
    }

    public static interface SurfaceReadyCallback {
        public void surfaceReady();
    }
}

