/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import com.pedro.encoder.utils.PCMUtil;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AudioDecoder {
    private final String TAG = "AudioDecoder";
    private AudioDecoderInterface audioDecoderInterface;
    private LoopFileInterface loopFileInterface;
    private MediaExtractor audioExtractor;
    private MediaCodec audioDecoder;
    private MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();
    private boolean decoding;
    private Thread thread;
    private GetMicrophoneData getMicrophoneData;
    private MediaFormat audioFormat;
    private String mime = "";
    private int sampleRate;
    private boolean isStereo;
    private int channels = 2;
    private int size = 4096;
    private byte[] pcmBuffer = new byte[this.size];
    private byte[] pcmBufferMuted = new byte[11];
    private static boolean loopMode = false;
    private boolean muted = false;
    private long duration;
    private volatile long seekTime = 0L;
    private volatile long startMs = 0L;

    public AudioDecoder(GetMicrophoneData getMicrophoneData, AudioDecoderInterface audioDecoderInterface, LoopFileInterface loopFileInterface) {
        this.getMicrophoneData = getMicrophoneData;
        this.audioDecoderInterface = audioDecoderInterface;
        this.loopFileInterface = loopFileInterface;
    }

    public boolean initExtractor(String filePath) throws IOException {
        this.decoding = false;
        this.audioExtractor = new MediaExtractor();
        this.audioExtractor.setDataSource(filePath);
        for (int i = 0; i < this.audioExtractor.getTrackCount() && !this.mime.startsWith("audio/"); ++i) {
            this.audioFormat = this.audioExtractor.getTrackFormat(i);
            this.mime = this.audioFormat.getString("mime");
            if (this.mime.startsWith("audio/")) {
                this.audioExtractor.selectTrack(i);
                continue;
            }
            this.audioFormat = null;
        }
        if (this.audioFormat != null) {
            this.channels = this.audioFormat.getInteger("channel-count");
            this.isStereo = this.channels >= 2;
            this.sampleRate = this.audioFormat.getInteger("sample-rate");
            this.duration = this.audioFormat.getLong("durationUs");
            if (this.channels > 2) {
                this.pcmBuffer = new byte[2048 * this.channels];
            }
            return true;
        }
        this.mime = "";
        this.audioFormat = null;
        return false;
    }

    public boolean prepareAudio() {
        try {
            this.audioDecoder = MediaCodec.createDecoderByType((String)this.mime);
            this.audioDecoder.configure(this.audioFormat, null, null, 0);
            return true;
        }
        catch (IOException e) {
            Log.e((String)"AudioDecoder", (String)"Prepare decoder error:", (Throwable)e);
            return false;
        }
    }

    public void start() {
        this.decoding = true;
        this.audioDecoder.start();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AudioDecoder.this.decodeAudio();
            }
        });
        this.thread.start();
    }

    public void stop() {
        this.decoding = false;
        this.seekTime = 0L;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        if (this.audioDecoder != null) {
            this.audioDecoder.stop();
            this.audioDecoder.release();
            this.audioDecoder = null;
        }
        if (this.audioExtractor != null) {
            this.audioExtractor.release();
            this.audioExtractor = null;
        }
    }

    private void decodeAudio() {
        ByteBuffer[] inputBuffers = this.audioDecoder.getInputBuffers();
        ByteBuffer[] outputBuffers = this.audioDecoder.getOutputBuffers();
        this.startMs = System.currentTimeMillis();
        while (this.decoding) {
            int inIndex = this.audioDecoder.dequeueInputBuffer(10000L);
            if (inIndex < 0) continue;
            ByteBuffer buffer = inputBuffers[inIndex];
            int sampleSize = this.audioExtractor.readSampleData(buffer, 0);
            if (sampleSize < 0) {
                this.audioDecoder.queueInputBuffer(inIndex, 0, 0, 0L, 4);
            } else {
                this.audioDecoder.queueInputBuffer(inIndex, 0, sampleSize, this.audioExtractor.getSampleTime(), 0);
                this.audioExtractor.advance();
            }
            int outIndex = this.audioDecoder.dequeueOutputBuffer(this.audioInfo, 10000L);
            switch (outIndex) {
                case -3: {
                    outputBuffers = this.audioDecoder.getOutputBuffers();
                    break;
                }
                case -2: 
                case -1: {
                    break;
                }
                default: {
                    while (this.audioExtractor.getSampleTime() / 1000L > System.currentTimeMillis() - this.startMs + this.seekTime) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            this.thread.interrupt();
                            return;
                        }
                    }
                    ByteBuffer outBuffer = outputBuffers[outIndex];
                    if (this.muted) {
                        outBuffer.get(this.pcmBufferMuted, 0, this.pcmBufferMuted.length);
                        this.getMicrophoneData.inputPCMData(this.pcmBufferMuted, 0, this.pcmBufferMuted.length);
                    } else {
                        outBuffer.get(this.pcmBuffer, 0, this.pcmBuffer.length);
                        if (this.channels > 2) {
                            byte[] bufferStereo = PCMUtil.pcmToStereo(this.pcmBuffer, this.channels);
                            this.getMicrophoneData.inputPCMData(bufferStereo, 0, bufferStereo.length);
                        } else {
                            this.getMicrophoneData.inputPCMData(this.pcmBuffer, 0, this.pcmBuffer.length);
                        }
                    }
                    this.audioDecoder.releaseOutputBuffer(outIndex, false);
                }
            }
            if ((this.audioInfo.flags & 4) == 0) continue;
            this.seekTime = 0L;
            Log.i((String)"AudioDecoder", (String)"end of file out");
            if (loopMode) {
                this.loopFileInterface.onReset(false);
                continue;
            }
            this.audioDecoderInterface.onAudioDecoderFinished();
        }
    }

    public double getTime() {
        if (this.decoding) {
            return (double)this.audioExtractor.getSampleTime() / 1000000.0;
        }
        return 0.0;
    }

    public void moveTo(double time) {
        this.audioExtractor.seekTo((long)(time * 1000000.0), 2);
        this.seekTime = this.audioExtractor.getSampleTime() / 1000L;
        this.startMs = System.currentTimeMillis();
    }

    public void setLoopMode(boolean loopMode) {
        AudioDecoder.loopMode = loopMode;
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.isStereo;
    }

    public double getDuration() {
        return (double)this.duration / 1000000.0;
    }
}

