/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AudioEncoder
implements GetMicrophoneData {
    private String TAG = "AudioEncoder";
    private MediaCodec audioEncoder;
    private GetAacData getAacData;
    private MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();
    private long presentTimeUs;
    private boolean running;
    private CodecUtil.Force force = CodecUtil.Force.FIRST_COMPATIBLE_FOUND;
    private int bitRate = 65536;
    private int sampleRate = 32000;
    private boolean isStereo = true;
    private boolean canFlush = false;

    public AudioEncoder(GetAacData getAacData) {
        this.getAacData = getAacData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean prepareAudioEncoder(int bitRate, int sampleRate, boolean isStereo, int maxInputSize) {
        this.sampleRate = sampleRate;
        try {
            List<Object> encoders = new ArrayList();
            if (this.force == CodecUtil.Force.HARDWARE) {
                encoders = CodecUtil.getAllHardwareEncoders("audio/mp4a-latm");
            } else if (this.force == CodecUtil.Force.SOFTWARE) {
                encoders = CodecUtil.getAllSoftwareEncoders("audio/mp4a-latm");
            }
            if (this.force == CodecUtil.Force.FIRST_COMPATIBLE_FOUND) {
                MediaCodecInfo encoder = this.chooseAudioEncoder("audio/mp4a-latm");
                if (encoder == null) {
                    Log.e((String)this.TAG, (String)"Valid encoder not found");
                    return false;
                }
                this.audioEncoder = MediaCodec.createByCodecName((String)encoder.getName());
            } else {
                if (encoders.isEmpty()) {
                    Log.e((String)this.TAG, (String)"Valid encoder not found");
                    return false;
                }
                this.audioEncoder = MediaCodec.createByCodecName((String)((MediaCodecInfo)encoders.get(0)).getName());
            }
            int channelCount = isStereo ? 2 : 1;
            MediaFormat audioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
            audioFormat.setInteger("bitrate", bitRate);
            audioFormat.setInteger("max-input-size", maxInputSize);
            audioFormat.setInteger("aac-profile", 2);
            this.audioEncoder.configure(audioFormat, null, null, 1);
            this.running = false;
            return true;
        }
        catch (IOException | IllegalStateException e) {
            Log.e((String)this.TAG, (String)"Create AudioEncoder failed.", (Throwable)e);
            return false;
        }
    }

    public void setForce(CodecUtil.Force force) {
        this.force = force;
    }

    public boolean prepareAudioEncoder() {
        return this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo, 0);
    }

    public void start() {
        this.presentTimeUs = System.nanoTime() / 1000L;
        this.audioEncoder.start();
        this.running = true;
        Log.i((String)this.TAG, (String)"AudioEncoder started");
    }

    public void stop() {
        this.running = false;
        if (this.audioEncoder != null) {
            if (this.canFlush) {
                this.audioEncoder.flush();
            }
            this.audioEncoder.stop();
            this.audioEncoder.release();
            this.audioEncoder = null;
        }
        this.canFlush = false;
        Log.i((String)this.TAG, (String)"AudioEncoder stopped");
    }

    @Override
    public void inputPCMData(byte[] buffer, int offset, int size) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getDataFromEncoderAPI21(buffer, offset, size);
        } else {
            this.getDataFromEncoder(buffer, offset, size);
        }
    }

    @RequiresApi(api=21)
    private void getDataFromEncoderAPI21(byte[] data, int offset, int size) {
        int inBufferIndex = this.audioEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = this.audioEncoder.getInputBuffer(inBufferIndex);
            bb.put(data, offset, size);
            long pts = System.nanoTime() / 1000L - this.presentTimeUs;
            this.audioEncoder.queueInputBuffer(inBufferIndex, 0, size, pts, 0);
        }
        while (this.running) {
            int outBufferIndex = this.audioEncoder.dequeueOutputBuffer(this.audioInfo, 0L);
            if (outBufferIndex == -2) {
                this.getAacData.onAudioFormat(this.audioEncoder.getOutputFormat());
                this.canFlush = true;
                continue;
            }
            if (outBufferIndex < 0) break;
            ByteBuffer bb = this.audioEncoder.getOutputBuffer(outBufferIndex);
            this.getAacData.getAacData(bb, this.audioInfo);
            this.audioEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private void getDataFromEncoder(byte[] data, int offset, int size) {
        ByteBuffer[] inputBuffers = this.audioEncoder.getInputBuffers();
        ByteBuffer[] outputBuffers = this.audioEncoder.getOutputBuffers();
        int inBufferIndex = this.audioEncoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = inputBuffers[inBufferIndex];
            bb.clear();
            bb.put(data, 0, size);
            long pts = System.nanoTime() / 1000L - this.presentTimeUs;
            this.audioEncoder.queueInputBuffer(inBufferIndex, 0, size, pts, 0);
        }
        while (this.running) {
            int outBufferIndex = this.audioEncoder.dequeueOutputBuffer(this.audioInfo, 0L);
            if (outBufferIndex == -2) {
                this.getAacData.onAudioFormat(this.audioEncoder.getOutputFormat());
                this.canFlush = true;
                continue;
            }
            if (outBufferIndex < 0) break;
            ByteBuffer bb = outputBuffers[outBufferIndex];
            this.getAacData.getAacData(bb, this.audioInfo);
            this.audioEncoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private MediaCodecInfo chooseAudioEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = CodecUtil.getAllEncoders(mime);
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoList) {
            String name = mediaCodecInfo.getName().toLowerCase();
            if (name.contains("omx.google")) continue;
            return mediaCodecInfo;
        }
        if (mediaCodecInfoList.size() > 0) {
            return mediaCodecInfoList.get(0);
        }
        return null;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public boolean isRunning() {
        return this.running;
    }
}

