/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.audio;

import android.media.AudioRecord;
import android.util.Log;
import com.pedro.encoder.audio.DataTaken;
import com.pedro.encoder.input.audio.AudioPostProcessEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;

public class MicrophoneManager {
    private final String TAG = "MicrophoneManager";
    private static final int BUFFER_SIZE = 4096;
    private AudioRecord audioRecord;
    private GetMicrophoneData getMicrophoneData;
    private byte[] pcmBuffer = new byte[4096];
    private byte[] pcmBufferMuted = new byte[4096];
    private boolean running = false;
    private boolean created = false;
    private int sampleRate = 32000;
    private int audioFormat = 2;
    private int channel = 12;
    private boolean muted = false;
    private AudioPostProcessEffect audioPostProcessEffect;
    private Thread thread;

    public MicrophoneManager(GetMicrophoneData getMicrophoneData) {
        this.getMicrophoneData = getMicrophoneData;
    }

    public void createMicrophone() {
        this.createMicrophone(this.sampleRate, true, false, false);
        Log.i((String)"MicrophoneManager", (String)("Microphone created, " + this.sampleRate + "hz, Stereo"));
    }

    public void createMicrophone(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.sampleRate = sampleRate;
        if (!isStereo) {
            this.channel = 16;
        }
        this.audioRecord = new AudioRecord(0, sampleRate, this.channel, this.audioFormat, this.getPcmBufferSize() * 4);
        this.audioPostProcessEffect = new AudioPostProcessEffect(this.audioRecord.getAudioSessionId());
        if (echoCanceler) {
            this.audioPostProcessEffect.enableEchoCanceler();
        }
        if (noiseSuppressor) {
            this.audioPostProcessEffect.enableNoiseSuppressor();
        }
        String chl = isStereo ? "Stereo" : "Mono";
        Log.i((String)"MicrophoneManager", (String)("Microphone created, " + sampleRate + "hz, " + chl));
        this.created = true;
    }

    public void start() {
        this.init();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (MicrophoneManager.this.running && !Thread.interrupted()) {
                    DataTaken dataTaken = MicrophoneManager.this.read();
                    if (dataTaken != null) {
                        MicrophoneManager.this.getMicrophoneData.inputPCMData(dataTaken.getPcmBuffer(), dataTaken.getSize());
                        continue;
                    }
                    MicrophoneManager.this.running = false;
                }
            }
        });
        this.thread.start();
    }

    private void init() {
        if (this.audioRecord != null) {
            this.audioRecord.startRecording();
            this.running = true;
            Log.i((String)"MicrophoneManager", (String)"Microphone started");
        } else {
            Log.e((String)"MicrophoneManager", (String)"Error starting, microphone was stopped or not created, use createMicrophone() before start()");
        }
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    private DataTaken read() {
        int size = this.audioRecord.read(this.pcmBuffer, 0, this.pcmBuffer.length);
        if (size <= 0) {
            return null;
        }
        return new DataTaken(this.muted ? this.pcmBufferMuted : this.pcmBuffer, size);
    }

    public void stop() {
        this.running = false;
        this.created = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
        }
        this.thread = null;
        if (this.audioRecord != null) {
            this.audioRecord.setRecordPositionUpdateListener(null);
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        if (this.audioPostProcessEffect != null) {
            this.audioPostProcessEffect.releaseEchoCanceler();
            this.audioPostProcessEffect.releaseNoiseSuppressor();
        }
        Log.i((String)"MicrophoneManager", (String)"Microphone stopped");
    }

    private int getPcmBufferSize() {
        int pcmBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channel, (int)2) + 8191;
        return pcmBufSize - pcmBufSize % 8192;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isCreated() {
        return this.created;
    }
}

