/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.video;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.camera2.params.Face;
import android.support.annotation.RequiresApi;
import android.view.View;

public class FaceDetectorUtil {
    @RequiresApi(api=21)
    public FaceParsed camera2Parse(Face face, View view, PointF scale, int rotation, boolean isFrontCamera) {
        RectF rect = new RectF(face.getBounds());
        Matrix matrix = new Matrix();
        matrix.setScale(isFrontCamera ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)rotation);
        matrix.postScale(1.0f, 1.0f);
        matrix.postTranslate((float)view.getWidth(), (float)view.getHeight());
        matrix.mapRect(rect);
        return this.getFace(rect, scale, view);
    }

    public FaceParsed camera1Parse(Camera.Face face, View view, PointF scale, int rotation, boolean isFrontCamera) {
        RectF rect = new RectF(face.rect);
        Matrix matrix = new Matrix();
        matrix.setScale(isFrontCamera ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)rotation);
        matrix.postScale((float)view.getWidth() / 2000.0f, (float)view.getHeight() / 2000.0f);
        matrix.postTranslate((float)view.getWidth() / 2.0f, (float)view.getHeight() / 2.0f);
        matrix.mapRect(rect);
        return this.getFace(rect, scale, view);
    }

    private FaceParsed getFace(RectF rectF, PointF scale, View view) {
        float posX = rectF.centerX() * 100.0f / (float)view.getWidth();
        float posY = rectF.centerY() * 100.0f / (float)view.getHeight();
        PointF positionParsed = new PointF(posX - scale.x / 2.0f, posY - scale.y / 2.0f);
        float scaleX = rectF.width() * 100.0f / (float)view.getWidth();
        float scaleY = rectF.height() * 100.0f / (float)view.getHeight();
        PointF scaleParsed = new PointF(scaleX, scaleY);
        return new FaceParsed(positionParsed, scaleParsed);
    }

    public class FaceParsed {
        private PointF position;
        private PointF scale;

        public FaceParsed(PointF position, PointF scale) {
            this.position = position;
            this.scale = scale;
        }

        public PointF getPosition() {
            return this.position;
        }

        public void setPosition(PointF position) {
            this.position = position;
        }

        public PointF getScale() {
            return this.scale;
        }

        public void setScale(PointF scale) {
            this.scale = scale;
        }
    }
}

