/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.R;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

@RequiresApi(api=18)
public class ScreenRender {
    private final float[] squareVertexData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private FloatBuffer squareVertex;
    private float[] MVPMatrix = new float[16];
    private float[] STMatrix = new float[16];
    private boolean AAEnabled = false;
    private int texId;
    private int program = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int aPositionHandle = -1;
    private int aTextureHandle = -1;
    private int uSamplerHandle = -1;
    private int uResolutionHandle = -1;
    private int uAAEnabledHandle = -1;
    private int streamWidth;
    private int streamHeight;

    public ScreenRender() {
        this.squareVertex = ByteBuffer.allocateDirect(this.squareVertexData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(this.squareVertexData).position(0);
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
    }

    public void initGl(Context context) {
        GlUtil.checkGlError("initGl start");
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.fxaa);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSamplerHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSampler");
        this.uResolutionHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uResolution");
        this.uAAEnabledHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uAAEnabled");
        GlUtil.checkGlError("initGl end");
    }

    public void draw(int width, int height, boolean keepAspectRatio) {
        GlUtil.checkGlError("drawScreen start");
        if (keepAspectRatio) {
            if (width > height) {
                int realWidth = height * this.streamWidth / this.streamHeight;
                GLES20.glViewport((int)((width - realWidth) / 2), (int)0, (int)realWidth, (int)height);
            } else {
                int realHeight = width * this.streamHeight / this.streamWidth;
                GLES20.glViewport((int)0, (int)((height - realHeight) / 2), (int)width, (int)realHeight);
            }
        } else {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.program);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glUniform2f((int)this.uResolutionHandle, (float)width, (float)height);
        GLES20.glUniform1f((int)this.uAAEnabledHandle, (float)(this.AAEnabled ? 1.0f : 0.0f));
        GLES20.glUniform1i((int)this.uSamplerHandle, (int)5);
        GLES20.glActiveTexture((int)33989);
        GLES20.glBindTexture((int)3553, (int)this.texId);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("drawScreen end");
    }

    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }

    public void setTexId(int texId) {
        this.texId = texId;
    }

    public void setAAEnabled(boolean AAEnabled) {
        this.AAEnabled = AAEnabled;
    }

    public boolean isAAEnabled() {
        return this.AAEnabled;
    }

    public void setStreamSize(int streamWidth, int streamHeight) {
        this.streamWidth = streamWidth;
        this.streamHeight = streamHeight;
    }
}

