/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render.filters;

import android.content.Context;
import android.opengl.GLES20;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.BaseRenderOffScreen;
import com.pedro.encoder.utils.gl.GlUtil;

@RequiresApi(api=18)
public abstract class BaseFilterRender
extends BaseRenderOffScreen {
    private int width;
    private int height;
    protected static int previousTexId;
    protected static final int[] fboId;
    private static final int[] rboId;
    private static final int[] texId;

    @Override
    public void initGl(int width, int height, Context context) {
        this.width = width;
        this.height = height;
        GlUtil.checkGlError("initGl start");
        this.initGlFilter(context);
        GlUtil.checkGlError("initGl end");
    }

    public void initFBOLink() {
        this.initFBO(this.width, this.height, fboId, rboId, texId);
    }

    protected abstract void initGlFilter(Context var1);

    @Override
    public void draw() {
        GlUtil.checkGlError("drawFilter start");
        GLES20.glBindFramebuffer((int)36160, (int)fboId[0]);
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        this.drawFilter();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("drawFilter end");
    }

    protected abstract void drawFilter();

    public void setTexId(int texId) {
        previousTexId = texId;
    }

    @Override
    public int getTexId() {
        return texId[0];
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    static {
        fboId = new int[]{0};
        rboId = new int[]{0};
        texId = new int[]{0};
    }
}

