/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.common.socket.java;

import com.pedro.common.socket.base.UdpStreamSocket;
import com.pedro.common.socket.base.UdpType;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pedro/common/socket/java/UdpStreamSocketJava;", "Lcom/pedro/common/socket/base/UdpStreamSocket;", "host", "", "port", "", "sourcePort", "receiveSize", "type", "Lcom/pedro/common/socket/base/UdpType;", "<init>", "(Ljava/lang/String;ILjava/lang/Integer;Ljava/lang/Integer;Lcom/pedro/common/socket/base/UdpType;)V", "Ljava/lang/Integer;", "socket", "Ljava/net/DatagramSocket;", "packetSize", "connect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "write", "bytes", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "isConnected", "", "isReachable", "common_release"})
@SourceDebugExtension(value={"SMAP\nUdpStreamSocketJava.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UdpStreamSocketJava.kt\ncom/pedro/common/socket/java/UdpStreamSocketJava\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class UdpStreamSocketJava
extends UdpStreamSocket {
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final Integer sourcePort;
    @NotNull
    private final UdpType type;
    @Nullable
    private DatagramSocket socket;
    private final int packetSize;

    public UdpStreamSocketJava(@NotNull String host, int port, @Nullable Integer sourcePort, @Nullable Integer receiveSize, @NotNull UdpType type) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.host = host;
        this.port = port;
        this.sourcePort = sourcePort;
        this.type = type;
        Integer n = receiveSize;
        this.packetSize = n != null ? n : 4098;
    }

    public /* synthetic */ UdpStreamSocketJava(String string, int n, Integer n2, Integer n3, UdpType udpType, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = null;
        }
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        if ((n4 & 0x10) != 0) {
            udpType = UdpType.UNICAST;
        }
        this(string, n, n2, n3, udpType);
    }

    @Override
    @Nullable
    public Object connect(@NotNull Continuation<? super Unit> $completion) {
        DatagramSocket socket = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> {
                int it;
                Integer v0 = this.sourcePort;
                if (v0 != null) {
                    it = ((Number)v0).intValue();
                    boolean $i$a$-let-UdpStreamSocketJava$connect$socket$1 = false;
                    yield new DatagramSocket(this.sourcePort);
                }
                yield new DatagramSocket();
            }
            case 2 -> {
                MulticastSocket v3;
                int it;
                Integer v2 = this.sourcePort;
                if (v2 != null) {
                    it = ((Number)v2).intValue();
                    boolean $i$a$-let-UdpStreamSocketJava$connect$socket$2 = false;
                    v3 = new MulticastSocket(this.sourcePort);
                } else {
                    v3 = new MulticastSocket();
                }
                yield v3;
            }
            case 3 -> {
                DatagramSocket socket;
                DatagramSocket var5_6;
                DatagramSocket v5;
                Integer v4 = this.sourcePort;
                if (v4 != null) {
                    int it = ((Number)v4).intValue();
                    boolean $i$a$-let-UdpStreamSocketJava$connect$socket$socket$1 = false;
                    v5 = new DatagramSocket(this.sourcePort);
                } else {
                    v5 = new DatagramSocket();
                }
                DatagramSocket $this$connect_u24lambda_u243 = var5_6 = (socket = v5);
                boolean $i$a$-apply-UdpStreamSocketJava$connect$socket$3 = false;
                $this$connect_u24lambda_u243.setBroadcast(true);
                yield var5_6;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        InetAddress address = InetAddress.getByName(this.host);
        socket.connect(address, this.port);
        socket.setReceiveBufferSize(this.packetSize);
        socket.setSoTimeout((int)this.getTimeout());
        this.socket = socket;
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        DatagramSocket datagramSocket = this.socket;
        boolean bl = datagramSocket != null ? !datagramSocket.isClosed() : false;
        if (bl) {
            DatagramSocket datagramSocket2 = this.socket;
            if (datagramSocket2 != null) {
                datagramSocket2.disconnect();
            }
            DatagramSocket datagramSocket3 = this.socket;
            if (datagramSocket3 != null) {
                datagramSocket3.close();
            }
            this.socket = null;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object write(@NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
        block0: {
            DatagramPacket udpPacket = new DatagramPacket(bytes, bytes.length);
            DatagramSocket datagramSocket = this.socket;
            if (datagramSocket == null) break block0;
            datagramSocket.send(udpPacket);
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object read(@NotNull Continuation<? super byte[]> $completion) {
        byte[] buffer = new byte[this.packetSize];
        DatagramPacket udpPacket = new DatagramPacket(buffer, buffer.length);
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket != null) {
            datagramSocket.receive(udpPacket);
        }
        byte[] byArray = udpPacket.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
        return ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)0, (int)udpPacket.getLength()));
    }

    @Override
    public boolean isConnected() {
        DatagramSocket datagramSocket = this.socket;
        return datagramSocket != null ? datagramSocket.isConnected() : false;
    }

    @Override
    public boolean isReachable() {
        Object object = this.socket;
        return object != null && (object = ((DatagramSocket)object).getInetAddress()) != null ? ((InetAddress)object).isReachable((int)this.getTimeout()) : false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UdpType.values().length];
            try {
                nArray[UdpType.UNICAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UdpType.MULTICAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UdpType.BROADCAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

