/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.udp.utils;

import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.udp.utils.UdpType;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pedro/udp/utils/UdpSocket;", "", "host", "", "type", "Lcom/pedro/udp/utils/UdpType;", "port", "", "(Ljava/lang/String;Lcom/pedro/udp/utils/UdpType;I)V", "packetSize", "socket", "Ljava/net/DatagramSocket;", "timeout", "close", "", "connect", "isConnected", "", "isReachable", "readBuffer", "", "setPacketSize", "size", "write", "mpegTsPacket", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "udp_release"})
@SourceDebugExtension(value={"SMAP\nUdpSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UdpSocket.kt\ncom/pedro/udp/utils/UdpSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class UdpSocket {
    @NotNull
    private final String host;
    @NotNull
    private final UdpType type;
    private final int port;
    @Nullable
    private DatagramSocket socket;
    private int packetSize;
    private final int timeout;

    public UdpSocket(@NotNull String host, @NotNull UdpType type, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.host = host;
        this.type = type;
        this.port = port;
        this.packetSize = 188;
        this.timeout = 5000;
    }

    public final void connect() {
        InetAddress address = InetAddress.getByName(this.host);
        UdpSocket udpSocket = this;
        udpSocket.socket = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> new DatagramSocket();
            case 2 -> new MulticastSocket();
            case 3 -> {
                void $this$connect_u24lambda_u240;
                DatagramSocket var2_2;
                DatagramSocket var3_3 = var2_2 = new DatagramSocket();
                UdpSocket var5_4 = udpSocket;
                boolean $i$a$-apply-UdpSocket$connect$1 = false;
                $this$connect_u24lambda_u240.setBroadcast(true);
                udpSocket = var5_4;
                yield var2_2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket != null) {
            datagramSocket.connect(address, this.port);
        }
        DatagramSocket datagramSocket2 = this.socket;
        if (datagramSocket2 != null) {
            datagramSocket2.setSoTimeout(this.timeout);
        }
    }

    public final void close() {
        DatagramSocket datagramSocket = this.socket;
        boolean bl = datagramSocket != null ? !datagramSocket.isClosed() : false;
        if (bl) {
            DatagramSocket datagramSocket2 = this.socket;
            if (datagramSocket2 != null) {
                datagramSocket2.disconnect();
            }
            DatagramSocket datagramSocket3 = this.socket;
            if (datagramSocket3 != null) {
                datagramSocket3.close();
            }
            this.socket = null;
        }
    }

    public final boolean isConnected() {
        DatagramSocket datagramSocket = this.socket;
        return datagramSocket != null ? datagramSocket.isConnected() : false;
    }

    public final boolean isReachable() {
        Object object = this.socket;
        return object != null && (object = ((DatagramSocket)object).getInetAddress()) != null ? ((InetAddress)object).isReachable(5000) : false;
    }

    public final void setPacketSize(int size) {
        this.packetSize = size;
    }

    public final int write(@NotNull MpegTsPacket mpegTsPacket) {
        byte[] buffer;
        block0: {
            Intrinsics.checkNotNullParameter((Object)mpegTsPacket, (String)"mpegTsPacket");
            buffer = mpegTsPacket.getBuffer();
            DatagramPacket udpPacket = new DatagramPacket(buffer, buffer.length);
            DatagramSocket datagramSocket = this.socket;
            if (datagramSocket == null) break block0;
            datagramSocket.send(udpPacket);
        }
        return buffer.length;
    }

    @NotNull
    public final byte[] readBuffer() {
        byte[] buffer = new byte[this.packetSize];
        DatagramPacket udpPacket = new DatagramPacket(buffer, buffer.length);
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket != null) {
            datagramSocket.receive(udpPacket);
        }
        byte[] byArray = udpPacket.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
        return ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)0, (int)udpPacket.getLength()));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UdpType.values().length];
            try {
                nArray[UdpType.UNICAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UdpType.MULTICAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UdpType.BROADCAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

