/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import android.util.Log;
import com.pedro.common.frame.MediaFrame;
import com.pedro.srt.mpeg2ts.Codec;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152(\u0010\u0016\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0017H\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010 \u001a\u00020\u00132\u0006\u0010\n\u001a\u00020!2\b\u0010\f\u001a\u0004\u0018\u00010!2\b\u0010\r\u001a\u0004\u0018\u00010!J\u0018\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020!H\u0002J\u0018\u0010&\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010#\u001a\u00020!H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/pedro/srt/mpeg2ts/packets/H26XPacket;", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "limitSize", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "<init>", "(ILcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "TAG", "", "sps", "", "pps", "vps", "codec", "Lcom/pedro/srt/mpeg2ts/Codec;", "configSend", "", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetPacket", "resetInfo", "setVideoCodec", "sendVideoInfo", "Ljava/nio/ByteBuffer;", "fixHeader", "byteBuffer", "isKeyFrame", "getVideoInfoData", "removeHeader", "getStartCodeSize", "srt_release"})
@SourceDebugExtension(value={"SMAP\nH26XPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H26XPacket.kt\ncom/pedro/srt/mpeg2ts/packets/H26XPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1563#2:207\n1634#2,3:208\n*S KotlinDebug\n*F\n+ 1 H26XPacket.kt\ncom/pedro/srt/mpeg2ts/packets/H26XPacket\n*L\n82#1:207\n82#1:208,3\n*E\n"})
public final class H26XPacket
extends BasePacket {
    @NotNull
    private final String TAG;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    @Nullable
    private byte[] vps;
    @NotNull
    private Codec codec;
    private boolean configSend;

    public H26XPacket(int limitSize, @NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        super(psiManager, limitSize);
        this.TAG = "H26XPacket";
        this.codec = Codec.AVC;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<MpegTsPacket>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        ByteBuffer fixedBuffer = com.pedro.common.ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        int length = fixedBuffer.remaining();
        if (length < 0) {
            return Unit.INSTANCE;
        }
        boolean isKeyFrame = mediaFrame.getInfo().isKeyFrame();
        if (this.codec == Codec.HEVC) {
            sps = this.sps;
            pps = this.pps;
            byte[] vps = this.vps;
            if (sps == null || pps == null || vps == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid sps, pps and vps");
                return Unit.INSTANCE;
            }
        } else {
            sps = this.sps;
            pps = this.pps;
            if (sps == null || pps == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid sps and pps");
                return Unit.INSTANCE;
            }
        }
        ByteBuffer validBuffer = this.fixHeader(fixedBuffer, isKeyFrame);
        byte[] payload = new byte[validBuffer.remaining()];
        validBuffer.get(payload, 0, validBuffer.remaining());
        short s = this.getPsiManager().getVideoPid();
        long l = mediaFrame.getInfo().getTimestamp();
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Pes pes = new Pes(s, isKeyFrame, PesType.VIDEO, l, byteBuffer);
        Iterable $this$map$iv = ExtensionsKt.chunkPackets(MpegTsPacketizer.write$default(this.getMpegTsPacketizer(), CollectionsKt.listOf((Object)pes), false, 2, null), this.getChunkSize());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void buffer;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MpegTsPacket((byte[])buffer, MpegType.VIDEO, PacketPosition.SINGLE, isKeyFrame));
        }
        List mpeg2tsPackets = (List)destination$iv$iv;
        if (!((Collection)mpeg2tsPackets).isEmpty()) {
            Object object = callback.invoke((Object)mpeg2tsPackets, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void resetPacket(boolean resetInfo) {
        if (resetInfo) {
            this.vps = null;
            this.sps = null;
            this.pps = null;
        }
        this.configSend = false;
    }

    public final void setVideoCodec(@NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)((Object)codec), (String)"codec");
        this.codec = codec;
    }

    public final void sendVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.sps = this.getVideoInfoData(sps);
        ByteBuffer byteBuffer = pps;
        this.pps = byteBuffer != null ? this.getVideoInfoData(byteBuffer) : null;
        ByteBuffer byteBuffer2 = vps;
        this.vps = byteBuffer2 != null ? this.getVideoInfoData(byteBuffer2) : null;
    }

    private final ByteBuffer fixHeader(ByteBuffer byteBuffer, boolean isKeyFrame) {
        ByteBuffer byteBuffer2;
        ByteBuffer noHeaderBuffer = this.removeHeader(byteBuffer, isKeyFrame);
        int startCodeSize = this.getStartCodeSize(noHeaderBuffer);
        if (startCodeSize == 0) {
            ByteBuffer bufferWithPrefix = ByteBuffer.allocate(noHeaderBuffer.remaining() + 4);
            bufferWithPrefix.putInt(1);
            bufferWithPrefix.put(noHeaderBuffer);
            Intrinsics.checkNotNull((Object)bufferWithPrefix);
            noHeaderBuffer = bufferWithPrefix;
        }
        if (isKeyFrame) {
            byte[] byArray = this.vps;
            if (this.vps == null) {
                byArray = new byte[]{};
            }
            byte[] vps = byArray;
            byte[] byArray2 = this.sps;
            if (this.sps == null) {
                byArray2 = new byte[]{};
            }
            byte[] sps = byArray2;
            byte[] byArray3 = this.pps;
            if (this.pps == null) {
                byArray3 = new byte[]{};
            }
            byte[] pps = byArray3;
            int audSize = this.codec == Codec.AVC ? 6 : 7;
            byte[] videoHeader = ArraysKt.plus((byte[])ArraysKt.plus((byte[])vps, (byte[])sps), (byte[])pps);
            ByteBuffer validBuffer = ByteBuffer.allocate(audSize + videoHeader.length + noHeaderBuffer.remaining());
            validBuffer.putInt(1);
            if (this.codec == Codec.AVC) {
                validBuffer.put((byte)9);
                v3 = validBuffer.put((byte)-16);
            } else {
                validBuffer.put((byte)70);
                validBuffer.put((byte)1);
                v3 = validBuffer.put((byte)80);
            }
            validBuffer.put(videoHeader);
            validBuffer.put(com.pedro.common.ExtensionsKt.toByteArray((ByteBuffer)noHeaderBuffer));
            validBuffer.rewind();
            this.configSend = true;
            ByteBuffer byteBuffer3 = validBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer3);
            byteBuffer2 = byteBuffer3;
        } else {
            noHeaderBuffer.rewind();
            byteBuffer2 = noHeaderBuffer;
        }
        return byteBuffer2;
    }

    private final byte[] getVideoInfoData(ByteBuffer byteBuffer) {
        byte[] byArray;
        byteBuffer.rewind();
        int startCodeSize = this.getStartCodeSize(byteBuffer);
        if (startCodeSize == 0) {
            ByteBuffer validBuffer = ByteBuffer.allocate(byteBuffer.remaining() + 4);
            validBuffer.putInt(1);
            validBuffer.put(byteBuffer);
            Intrinsics.checkNotNull((Object)validBuffer);
            byArray = com.pedro.common.ExtensionsKt.toByteArray((ByteBuffer)validBuffer);
        } else {
            byArray = com.pedro.common.ExtensionsKt.toByteArray((ByteBuffer)byteBuffer);
        }
        return byArray;
    }

    private final ByteBuffer removeHeader(ByteBuffer byteBuffer, boolean isKeyFrame) {
        if (isKeyFrame) {
            byte[] pps;
            ByteBuffer validBuffer = byteBuffer;
            byte[] byArray = this.vps;
            if (this.vps == null) {
                byArray = new byte[]{};
            }
            byte[] vps = byArray;
            byte[] byArray2 = this.sps;
            if (this.sps == null) {
                byArray2 = new byte[]{};
            }
            byte[] sps = byArray2;
            byte[] byArray3 = this.pps;
            if (this.pps == null) {
                byArray3 = pps = new byte[]{};
            }
            if (!(vps.length == 0) && ExtensionsKt.startWith(validBuffer, vps)) {
                validBuffer.position(vps.length);
                ByteBuffer byteBuffer2 = validBuffer.slice();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"slice(...)");
                validBuffer = byteBuffer2;
            }
            if (!(sps.length == 0) && ExtensionsKt.startWith(validBuffer, sps)) {
                validBuffer.position(sps.length);
                ByteBuffer byteBuffer3 = validBuffer.slice();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"slice(...)");
                validBuffer = byteBuffer3;
            }
            if (!(pps.length == 0) && ExtensionsKt.startWith(validBuffer, pps)) {
                validBuffer.position(pps.length);
                ByteBuffer byteBuffer4 = validBuffer.slice();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"slice(...)");
                validBuffer = byteBuffer4;
            }
            validBuffer.rewind();
            return validBuffer;
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private final int getStartCodeSize(ByteBuffer byteBuffer) {
        int startCodeSize = 0;
        if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 0 && byteBuffer.get(3) == 1) {
            startCodeSize = 4;
        } else if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 1) {
            startCodeSize = 3;
        }
        return startCodeSize;
    }
}

