/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts;

import com.pedro.common.TimeUtils;
import com.pedro.srt.mpeg2ts.AdaptationField;
import com.pedro.srt.mpeg2ts.AdaptationFieldControl;
import com.pedro.srt.mpeg2ts.MpegTsPayload;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.psi.Psi;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u000eJ \u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "<init>", "(Lcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "pesContinuity", "", "psiContinuity", "writeHeader", "", "buffer", "Ljava/nio/ByteBuffer;", "startIndicator", "", "pid", "adaptationFieldControl", "Lcom/pedro/srt/mpeg2ts/AdaptationFieldControl;", "continuity", "write", "", "", "payload", "Lcom/pedro/srt/mpeg2ts/MpegTsPayload;", "increasePsiContinuity", "writeStuffingBytes", "byteBuffer", "size", "addHeader", "reset", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nMpegTsPacketizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MpegTsPacketizer.kt\ncom/pedro/srt/mpeg2ts/MpegTsPacketizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1869#2,2:146\n*S KotlinDebug\n*F\n+ 1 MpegTsPacketizer.kt\ncom/pedro/srt/mpeg2ts/MpegTsPacketizer\n*L\n63#1:146,2\n*E\n"})
public final class MpegTsPacketizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiManager psiManager;
    private int pesContinuity;
    private int psiContinuity;
    public static final int packetSize = 188;
    public static final int headerSize = 4;

    public MpegTsPacketizer(@NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        this.psiManager = psiManager;
    }

    private final void writeHeader(ByteBuffer buffer, boolean startIndicator, int pid, AdaptationFieldControl adaptationFieldControl, int continuity) {
        boolean transportErrorIndicator = false;
        boolean transportPriority = false;
        int transportScramblingControl = 0;
        buffer.put((byte)71);
        short combined = (short)(ExtensionsKt.toInt(transportErrorIndicator) << 15 | ExtensionsKt.toInt(startIndicator) << 14 | ExtensionsKt.toInt(transportPriority) << 13 | pid);
        buffer.putShort(combined);
        byte combined2 = (byte)((transportScramblingControl & 3) << 6 | (adaptationFieldControl.getValue() & 3) << 4 | continuity & 0xF);
        buffer.put(combined2);
    }

    @NotNull
    public final List<byte[]> write(@NotNull List<? extends MpegTsPayload> payload, boolean increasePsiContinuity) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        List packets = new ArrayList();
        if (increasePsiContinuity) {
            this.psiContinuity = this.psiContinuity + 1 & 0xF;
        }
        Iterable $this$forEach$iv = payload;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MpegTsPayload mpegTsPayload = (MpegTsPayload)element$iv;
            boolean bl = false;
            ByteBuffer buffer = ByteBuffer.allocate(188);
            MpegTsPayload mpegTsPayload2 = mpegTsPayload;
            if (mpegTsPayload2 instanceof Psi) {
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                this.writeHeader(byteBuffer, true, mpegTsPayload.getPid(), AdaptationFieldControl.PAYLOAD, this.psiContinuity);
                Psi psi = (Psi)mpegTsPayload;
                byteBuffer = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                psi.write(byteBuffer);
                int stuffingSize = buffer.remaining();
                ByteBuffer byteBuffer2 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer2);
                this.writeStuffingBytes(byteBuffer2, stuffingSize, false);
                byteBuffer2 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer2);
                packets.add(com.pedro.common.ExtensionsKt.toByteArray((ByteBuffer)byteBuffer2));
                continue;
            }
            if (!(mpegTsPayload2 instanceof Pes)) continue;
            ByteBuffer data = ((Pes)mpegTsPayload).getBufferData();
            boolean isAudio = this.psiManager.getAudioPid() == mpegTsPayload.getPid();
            Long pcr = isAudio && !mpegTsPayload.isKeyFrame() ? null : Long.valueOf(TimeUtils.getCurrentTimeMicro());
            AdaptationField adaptationField = new AdaptationField(false, mpegTsPayload.isKeyFrame(), false, pcr, null, null, null, null, null, 500, null);
            byte[] adaptationData = adaptationField.getData();
            boolean isSmall = data.remaining() < buffer.remaining() - 4 - adaptationData.length - ((Pes)mpegTsPayload).getHeaderLength();
            AdaptationFieldControl adaptationFieldControl = isSmall ? AdaptationFieldControl.PAYLOAD : AdaptationFieldControl.ADAPTATION_PAYLOAD;
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            this.writeHeader(byteBuffer, true, mpegTsPayload.getPid(), adaptationFieldControl, this.pesContinuity);
            buffer.put(adaptationData);
            Pes pes = (Pes)mpegTsPayload;
            byteBuffer = buffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            pes.writeHeader(byteBuffer);
            if (isSmall) {
                buffer.put(data);
                int stuffingSize = buffer.remaining();
                ByteBuffer byteBuffer3 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer3);
                this.writeStuffingBytes(byteBuffer3, stuffingSize, true);
                byteBuffer3 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer3);
                packets.add(com.pedro.common.ExtensionsKt.toByteArray((ByteBuffer)byteBuffer3));
                this.pesContinuity = this.pesContinuity + 1 & 0xF;
                continue;
            }
            boolean isFirstPacket = true;
            adaptationFieldControl = AdaptationFieldControl.PAYLOAD;
            while (data.hasRemaining()) {
                ByteBuffer byteBuffer4;
                boolean lastPacket;
                boolean bl2 = lastPacket = data.remaining() < buffer.remaining() - 4;
                if (!isFirstPacket) {
                    if (lastPacket) {
                        adaptationFieldControl = AdaptationFieldControl.ADAPTATION_PAYLOAD;
                    }
                    ByteBuffer byteBuffer5 = buffer;
                    Intrinsics.checkNotNull((Object)byteBuffer5);
                    this.writeHeader(byteBuffer5, false, mpegTsPayload.getPid(), adaptationFieldControl, this.pesContinuity);
                }
                if (lastPacket) {
                    int stuffingSize = buffer.remaining() - data.remaining();
                    byteBuffer4 = buffer;
                    Intrinsics.checkNotNull((Object)byteBuffer4);
                    this.writeStuffingBytes(byteBuffer4, stuffingSize, true);
                }
                int size = Math.min(data.remaining(), buffer.remaining());
                buffer.put(data.array(), data.position(), size);
                data.position(data.position() + size);
                byteBuffer4 = buffer;
                Intrinsics.checkNotNull((Object)byteBuffer4);
                packets.add(com.pedro.common.ExtensionsKt.toByteArray((ByteBuffer)byteBuffer4));
                this.pesContinuity = this.pesContinuity + 1 & 0xF;
                buffer = ByteBuffer.allocate(188);
                isFirstPacket = false;
            }
        }
        return packets;
    }

    public static /* synthetic */ List write$default(MpegTsPacketizer mpegTsPacketizer, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return mpegTsPacketizer.write(list, bl);
    }

    private final void writeStuffingBytes(ByteBuffer byteBuffer, int size, boolean addHeader) {
        int fillSize;
        int n = fillSize = addHeader ? size - 2 : size;
        if (fillSize == -1) {
            v1 = byteBuffer.put((byte)(size - 1));
        } else {
            int n2 = 0;
            byte[] byArray = new byte[fillSize];
            while (n2 < fillSize) {
                int n3 = n2++;
                byArray[n3] = -1;
            }
            byte[] bytes = byArray;
            if (addHeader) {
                byteBuffer.put((byte)(size - 1));
                byteBuffer.put((byte)0);
            }
            v1 = byteBuffer.put(bytes);
        }
    }

    public final void reset() {
        this.pesContinuity = 0;
        this.psiContinuity = 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer$Companion;", "", "<init>", "()V", "packetSize", "", "headerSize", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

