/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import com.pedro.common.AudioUtils;
import com.pedro.common.frame.MediaFrame;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2(\u0010\u0010\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0019R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pedro/srt/mpeg2ts/packets/AacPacket;", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "limitSize", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "<init>", "(ILcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "sampleRate", "channels", "type", "headerSize", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetPacket", "resetInfo", "", "sendAudioInfo", "stereo", "srt_release"})
@SourceDebugExtension(value={"SMAP\nAacPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AacPacket.kt\ncom/pedro/srt/mpeg2ts/packets/AacPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1563#2:71\n1634#2,3:72\n*S KotlinDebug\n*F\n+ 1 AacPacket.kt\ncom/pedro/srt/mpeg2ts/packets/AacPacket\n*L\n58#1:71\n58#1:72,3\n*E\n"})
public final class AacPacket
extends BasePacket {
    private int sampleRate;
    private int channels;
    private final int type;
    private final int headerSize;

    public AacPacket(int limitSize, @NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        super(psiManager, limitSize);
        this.sampleRate = 44100;
        this.channels = 2;
        this.type = 2;
        this.headerSize = 7;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<MpegTsPacket>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        ByteBuffer fixedBuffer = com.pedro.common.ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        int length = fixedBuffer.remaining();
        if (length < 0) {
            return Unit.INSTANCE;
        }
        byte[] payload = new byte[length + this.headerSize];
        ByteBuffer adts = AudioUtils.INSTANCE.createAdtsHeader(this.type, payload.length, this.sampleRate, this.channels);
        adts.get(payload, 0, this.headerSize);
        fixedBuffer.get(payload, this.headerSize, length);
        short s = this.getPsiManager().getAudioPid();
        long l = mediaFrame.getInfo().getTimestamp();
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Pes pes = new Pes(s, false, PesType.AUDIO, l, byteBuffer);
        Iterable $this$map$iv = ExtensionsKt.chunkPackets(MpegTsPacketizer.write$default(this.getMpegTsPacketizer(), CollectionsKt.listOf((Object)pes), false, 2, null), this.getChunkSize());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void buffer;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MpegTsPacket((byte[])buffer, MpegType.AUDIO, PacketPosition.SINGLE, false));
        }
        List mpeg2tsPackets = (List)destination$iv$iv;
        if (!((Collection)mpeg2tsPackets).isEmpty()) {
            Object object = callback.invoke((Object)mpeg2tsPackets, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void resetPacket(boolean resetInfo) {
    }

    public final void sendAudioInfo(int sampleRate, boolean stereo) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
    }
}

