/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.srt.packets.data.PacketPosition;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102(\u0010\u0011\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\fJ \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pedro/srt/mpeg2ts/packets/AacPacket;", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "limitSize", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "<init>", "(ILcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "header", "", "sampleRate", "isStereo", "", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetPacket", "resetInfo", "sendAudioInfo", "stereo", "writeAdts", "buffer", "length", "offset", "getFrequency", "AUDIO_SAMPLING_RATES", "", "srt_release"})
@SourceDebugExtension(value={"SMAP\nAacPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AacPacket.kt\ncom/pedro/srt/mpeg2ts/packets/AacPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1872#2,2:114\n1863#2,2:117\n1874#2:119\n1#3:116\n*S KotlinDebug\n*F\n+ 1 AacPacket.kt\ncom/pedro/srt/mpeg2ts/packets/AacPacket\n*L\n57#1:114,2\n60#1:117,2\n57#1:119\n*E\n"})
public final class AacPacket
extends BasePacket {
    @NotNull
    private final byte[] header;
    private int sampleRate;
    private boolean isStereo;
    @NotNull
    private final int[] AUDIO_SAMPLING_RATES;

    public AacPacket(int limitSize, @NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        super(psiManager, limitSize);
        this.header = new byte[7];
        this.sampleRate = 44100;
        this.isStereo = true;
        int[] nArray = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
        this.AUDIO_SAMPLING_RATES = nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<MpegTsPacket>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        int length = fixedBuffer.remaining();
        if (length < 0) {
            return Unit.INSTANCE;
        }
        byte[] payload = new byte[length + this.header.length];
        this.writeAdts(payload, payload.length, 0);
        fixedBuffer.get(payload, this.header.length, length);
        short s = this.getPsiManager().getAudioPid();
        long l = mediaFrame.getInfo().getTimestamp();
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        Pes pes = new Pes(s, false, PesType.AUDIO, l, byteBuffer);
        List mpeg2tsPackets = MpegTsPacketizer.write$default(this.getMpegTsPacketizer(), CollectionsKt.listOf((Object)pes), false, 2, null);
        List chunked = CollectionsKt.chunked((Iterable)mpeg2tsPackets, (int)this.getChunkSize());
        List packets = new ArrayList();
        Iterable $this$forEachIndexed$iv = chunked;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object2;
            void chunks;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            Iterable iterable = (Iterable)chunks;
            int n2 = 0;
            for (Object object2 : iterable) {
                void it;
                byte[] byArray = (byte[])object2;
                int n3 = n2;
                boolean bl2 = false;
                int n4 = ((void)it).length;
                n2 = n3 + n4;
            }
            int size = n2;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            Iterable $this$forEach$iv = (Iterable)chunks;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                byte[] it = (byte[])element$iv;
                boolean bl3 = false;
                buffer.put(it);
            }
            PacketPosition packetPosition = PacketPosition.SINGLE;
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            packets.add(new MpegTsPacket(byArray, MpegType.AUDIO, packetPosition, false));
        }
        if (!((Collection)packets).isEmpty()) {
            Object object = callback.invoke((Object)packets, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void resetPacket(boolean resetInfo) {
    }

    public final void sendAudioInfo(int sampleRate, boolean stereo) {
        this.sampleRate = sampleRate;
        this.isStereo = stereo;
    }

    private final void writeAdts(byte[] buffer, int length, int offset) {
        int type = 2;
        int channels = this.isStereo ? 2 : 1;
        int frequency = this.getFrequency();
        buffer[offset] = -1;
        buffer[offset + 1] = -7;
        buffer[offset + 2] = (byte)(type - 1 << 6 | frequency << 2 | channels >> 2);
        buffer[offset + 3] = (byte)((channels & 3) << 6 | length >> 11);
        buffer[offset + 4] = (byte)((length & 0x7FF) >> 3);
        buffer[offset + 5] = (byte)((byte)((length & 7) << 5) + 31);
        buffer[offset + 6] = -4;
    }

    private final int getFrequency() {
        int frequency = ArraysKt.indexOf((int[])this.AUDIO_SAMPLING_RATES, (int)this.sampleRate);
        if (frequency == -1) {
            frequency = 4;
        }
        return frequency;
    }
}

