/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.utils;

import com.pedro.srt.srt.packets.control.handshake.EncryptionType;
import com.pedro.srt.srt.packets.control.handshake.extension.CipherType;
import com.pedro.srt.srt.packets.data.KeyBasedEncryption;
import com.pedro.srt.utils.EncryptInfo;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/pedro/srt/utils/EncryptionUtil;", "", "type", "Lcom/pedro/srt/srt/packets/control/handshake/EncryptionType;", "passphrase", "", "(Lcom/pedro/srt/srt/packets/control/handshake/EncryptionType;Ljava/lang/String;)V", "block", "Ljavax/crypto/spec/SecretKeySpec;", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "cipherType", "Lcom/pedro/srt/srt/packets/control/handshake/extension/CipherType;", "keyBasedEncryption", "Lcom/pedro/srt/srt/packets/data/KeyBasedEncryption;", "keyData", "", "keyLength", "", "salt", "getType", "()Lcom/pedro/srt/srt/packets/control/handshake/EncryptionType;", "calculateKEK", "encrypt", "bytes", "sequence", "generateSecureRandomBytes", "length", "getEncryptInfo", "Lcom/pedro/srt/utils/EncryptInfo;", "wrapKey", "kek", "keyToWrap", "srt_release"})
public final class EncryptionUtil {
    @NotNull
    private final EncryptionType type;
    @NotNull
    private final KeyBasedEncryption keyBasedEncryption;
    @NotNull
    private final CipherType cipherType;
    @NotNull
    private final byte[] salt;
    private final int keyLength;
    @NotNull
    private byte[] keyData;
    @NotNull
    private final SecretKeySpec block;
    private final Cipher cipher;

    public EncryptionUtil(@NotNull EncryptionType type, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        this.type = type;
        this.keyBasedEncryption = KeyBasedEncryption.PAIR_KEY;
        this.cipherType = CipherType.CTR;
        this.keyLength = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> 0;
            case 2 -> 16;
            case 3 -> 24;
            case 4 -> 32;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.keyData = new byte[0];
        this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
        this.salt = this.generateSecureRandomBytes(16);
        byte[] sek = this.generateSecureRandomBytes(this.keyLength);
        byte[] kek = this.calculateKEK(passphrase, this.salt, this.keyLength);
        this.keyData = this.wrapKey(kek, sek);
        this.block = new SecretKeySpec(sek, "AES");
    }

    @NotNull
    public final EncryptionType getType() {
        return this.type;
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] bytes, int sequence) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] ctr = new byte[16];
        ByteBuffer.wrap(ctr, 10, 4).putInt(sequence);
        for (int i = 0; i < 14; ++i) {
            ctr[i] = (byte)(ctr[i] ^ this.salt[i]);
        }
        this.cipher.init(1, (Key)this.block, new IvParameterSpec(ctr));
        byte[] byArray = this.cipher.doFinal(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final EncryptInfo getEncryptInfo() {
        return new EncryptInfo(this.keyBasedEncryption, this.cipherType, this.salt, this.keyData, this.keyLength);
    }

    private final byte[] generateSecureRandomBytes(int length) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[length];
        secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    private final byte[] wrapKey(byte[] kek, byte[] keyToWrap) {
        Cipher cipher = Cipher.getInstance("AESWrap");
        SecretKeySpec secretKek = new SecretKeySpec(kek, "AES");
        cipher.init(3, secretKek);
        SecretKeySpec secret = new SecretKeySpec(keyToWrap, "AES");
        byte[] byArray = cipher.wrap(secret);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"wrap(...)");
        return byArray;
    }

    private final byte[] calculateKEK(String passphrase, byte[] salt, int keyLength) {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        char[] cArray = passphrase.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        byte[] byArray = secretKeyFactory.generateSecret(new PBEKeySpec(cArray, ArraysKt.sliceArray((byte[])salt, (IntRange)RangesKt.until((int)8, (int)salt.length)), 2048, keyLength * 8)).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionType.values().length];
            try {
                nArray[EncryptionType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionType.AES128.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionType.AES192.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionType.AES256.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

