/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.srt;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateManager;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.Pid;
import com.pedro.srt.mpeg2ts.packets.AacPacket;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.packets.H26XPacket;
import com.pedro.srt.mpeg2ts.packets.OpusPacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.srt.CommandsManager;
import com.pedro.srt.srt.SrtSender;
import com.pedro.srt.utils.SrtSocket;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\u000eJ\u0006\u00103\u001a\u00020\u000eJ\u0006\u00104\u001a\u00020\bJ\u0006\u00105\u001a\u00020\bJ\u0010\u00106\u001a\u00020\u00182\b\b\u0002\u00107\u001a\u000208J\u0006\u00109\u001a\u000201J\u0006\u0010:\u001a\u000201J\u0006\u0010;\u001a\u000201J\u0006\u0010<\u001a\u000201J\u000e\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020\u000eJ\u0016\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u001c\u0010D\u001a\u00020\b2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0082@\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u0016\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\u0018J\u000e\u0010L\u001a\u0002012\u0006\u0010M\u001a\u00020\u0018J\u0018\u0010N\u001a\u0002012\u0006\u0010O\u001a\u00020\u00182\u0006\u0010P\u001a\u00020\u0018H\u0002J\"\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020A2\b\u0010S\u001a\u0004\u0018\u00010A2\b\u0010T\u001a\u0004\u0018\u00010AJ\u0006\u0010U\u001a\u000201J\u0016\u0010V\u001a\u0002012\u0006\u0010W\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010XR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/pedro/srt/srt/SrtSender;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "commandsManager", "Lcom/pedro/srt/srt/CommandsManager;", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/srt/srt/CommandsManager;)V", "audioFramesSent", "", "audioPacket", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "bitrateManager", "Lcom/pedro/common/BitrateManager;", "cacheSize", "", "<set-?>", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "h26XPacket", "Lcom/pedro/srt/mpeg2ts/packets/H26XPacket;", "isEnableLogs", "", "job", "Lkotlinx/coroutines/Job;", "limitSize", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "running", "scope", "Lkotlinx/coroutines/CoroutineScope;", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "socket", "Lcom/pedro/srt/utils/SrtSocket;", "getSocket", "()Lcom/pedro/srt/utils/SrtSocket;", "setSocket", "(Lcom/pedro/srt/utils/SrtSocket;)V", "videoFramesSent", "clearCache", "", "getCacheSize", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "percentUsed", "", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudioFrame", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendPackets", "packets", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendVideoFrame", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setLogs", "enable", "setTrackConfig", "videoEnabled", "audioEnabled", "setVideoInfo", "sps", "pps", "vps", "start", "stop", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nSrtSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SrtSender.kt\ncom/pedro/srt/srt/SrtSender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n1855#2,2:267\n*S KotlinDebug\n*F\n+ 1 SrtSender.kt\ncom/pedro/srt/srt/SrtSender\n*L\n184#1:267,2\n*E\n"})
public final class SrtSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private final Mpeg2TsService service;
    @NotNull
    private final PsiManager psiManager;
    private final int limitSize;
    @NotNull
    private final MpegTsPacketizer mpegTsPacketizer;
    @NotNull
    private BasePacket audioPacket;
    @NotNull
    private final H26XPacket h26XPacket;
    private volatile boolean running;
    private int cacheSize;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private volatile BlockingQueue<List<MpegTsPacket>> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    @Nullable
    private SrtSocket socket;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "SrtSender";

    /*
     * WARNING - void declaration
     */
    public SrtSender(@NotNull ConnectChecker connectChecker, @NotNull CommandsManager commandsManager) {
        void $this$psiManager_u24lambda_u240;
        PsiManager psiManager;
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)commandsManager, (String)"commandsManager");
        this.connectChecker = connectChecker;
        this.commandsManager = commandsManager;
        this.service = new Mpeg2TsService(0, 0, null, null, null, null, null, 127, null);
        PsiManager psiManager2 = psiManager = new PsiManager(this.service);
        SrtSender srtSender = this;
        boolean bl = false;
        $this$psiManager_u24lambda_u240.upgradePatVersion();
        $this$psiManager_u24lambda_u240.upgradeSdtVersion();
        srtSender.psiManager = psiManager;
        this.limitSize = this.commandsManager.getMTU() - 16;
        this.mpegTsPacketizer = new MpegTsPacketizer(this.psiManager);
        this.audioPacket = new AacPacket(this.limitSize, this.psiManager);
        this.h26XPacket = new H26XPacket(this.limitSize, this.psiManager);
        this.cacheSize = 200;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.bitrateManager = new BitrateManager(this.connectChecker);
        this.isEnableLogs = true;
    }

    @Nullable
    public final SrtSocket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable SrtSocket srtSocket) {
        this.socket = srtSocket;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    private final void setTrackConfig(boolean videoEnabled, boolean audioEnabled) {
        Pid.reset();
        this.service.clearTracks();
        if (audioEnabled) {
            this.service.addTrack(com.pedro.srt.utils.ExtensionsKt.toCodec(this.commandsManager.getAudioCodec()));
        }
        if (videoEnabled) {
            this.service.addTrack(com.pedro.srt.utils.ExtensionsKt.toCodec(this.commandsManager.getVideoCodec()));
        }
        this.service.generatePmt();
        this.psiManager.updateService(this.service);
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.h26XPacket.setVideoCodec(com.pedro.srt.utils.ExtensionsKt.toCodec(this.commandsManager.getVideoCodec()));
        this.h26XPacket.sendVideoInfo(sps, pps, vps);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.commandsManager.getAudioCodec().ordinal()]) {
            case 1: {
                BasePacket basePacket = this.audioPacket = (BasePacket)new AacPacket(this.limitSize, this.psiManager);
                AacPacket aacPacket = basePacket instanceof AacPacket ? (AacPacket)basePacket : null;
                if (aacPacket != null) {
                    aacPacket.sendAudioInfo(sampleRate, isStereo);
                }
                break;
            }
            case 2: {
                this.audioPacket = new OpusPacket(this.limitSize, this.psiManager);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Unsupported codec: " + this.commandsManager.getAudioCodec().name());
            }
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.h26XPacket.createAndSendPacket(h264Buffer, info, (Function1<? super List<MpegTsPacket>, Unit>)((Function1)new Function1<List<? extends MpegTsPacket>, Unit>(this){
                final /* synthetic */ SrtSender this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<MpegTsPacket> mpegTsPackets2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(mpegTsPackets2, (String)"mpegTsPackets");
                    BlockingQueue $this$trySend$iv = SrtSender.access$getQueue$p(this.this$0);
                    boolean $i$f$trySend = false;
                    try {
                        $this$trySend$iv.add(mpegTsPackets2);
                        bl = true;
                    }
                    catch (IllegalStateException e$iv) {
                        bl = false;
                    }
                    boolean result = bl;
                    if (!result) {
                        Log.i((String)"SrtSender", (String)"Video frame discarded");
                        SrtSender srtSender = this.this$0;
                        long l = srtSender.getDroppedVideoFrames();
                        SrtSender.access$setDroppedVideoFrames$p(srtSender, l + 1L);
                    }
                }
            }));
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.audioPacket.createAndSendPacket(aacBuffer, info, (Function1<? super List<MpegTsPacket>, Unit>)((Function1)new Function1<List<? extends MpegTsPacket>, Unit>(this){
                final /* synthetic */ SrtSender this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<MpegTsPacket> mpegTsPackets2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(mpegTsPackets2, (String)"mpegTsPackets");
                    BlockingQueue $this$trySend$iv = SrtSender.access$getQueue$p(this.this$0);
                    boolean $i$f$trySend = false;
                    try {
                        $this$trySend$iv.add(mpegTsPackets2);
                        bl = true;
                    }
                    catch (IllegalStateException e$iv) {
                        bl = false;
                    }
                    boolean result = bl;
                    if (!result) {
                        Log.i((String)"SrtSender", (String)"Audio frame discarded");
                        SrtSender srtSender = this.this$0;
                        long l = srtSender.getDroppedAudioFrames();
                        SrtSender.access$setDroppedAudioFrames$p(srtSender, l + 1L);
                    }
                }
            }));
        }
    }

    public final void start() {
        this.queue.clear();
        this.setTrackConfig(!this.commandsManager.getVideoDisabled(), !this.commandsManager.getAudioDisabled());
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SrtSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        bytesSend = new Ref.LongRef();
                        BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, bytesSend, null){
                            int label;
                            final /* synthetic */ SrtSender this$0;
                            final /* synthetic */ Ref.LongRef $bytesSend;
                            {
                                this.this$0 = $receiver;
                                this.$bytesSend = $bytesSend;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (CoroutineScopeKt.isActive((CoroutineScope)SrtSender.access$getScope$p(this.this$0)) && SrtSender.access$getRunning$p(this.this$0)) {
                                            this.label = 1;
                                            v0 = SrtSender.access$getBitrateManager$p(this.this$0).calculateBitrate(this.$bytesSend.element * (long)8, (Continuation)this);
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl15
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        this.$bytesSend.element = 0L;
                                        this.label = 2;
                                        v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                        if (v1 != var2_2) ** GOTO lbl5
                                        return var2_2;
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
lbl9:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)SrtSender.access$getScope$p(this.this$0)) && SrtSender.access$getRunning$p(this.this$0)) {
                            var5_6 = $this$launch;
                            var6_7 = this.this$0;
                            $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                            this.L$0 = $this$launch;
                            this.L$1 = bytesSend;
                            this.L$2 = var6_7;
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 1;
                            v0 = InterruptibleKt.runInterruptible$default(null, (Function0)((Function0)new Function0<List<? extends MpegTsPacket>>(var6_7){
                                final /* synthetic */ SrtSender this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final List<MpegTsPacket> invoke() {
                                    return (List)SrtSender.access$getQueue$p(this.this$0).poll(1L, TimeUnit.SECONDS);
                                }
                            }), (Continuation)this, (int)1, null);
                            ** if (v0 != var16_2) goto lbl25
lbl24:
                            // 1 sources

                            return var16_2;
lbl25:
                            // 1 sources

                            ** GOTO lbl36
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                        var6_7 = (SrtSender)this.L$2;
                        bytesSend = (Ref.LongRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        mpegTsPackets = (List)v0;
                        isKey = ((MpegTsPacket)mpegTsPackets.get(0)).isKey();
                        psiPackets = SrtSender.access$getPsiManager$p(var6_7).checkSendInfo(isKey != false, SrtSender.access$getMpegTsPacketizer$p(var6_7));
                        var12_14 = bytesSend.element;
                        var14_15 = bytesSend;
                        this.L$0 = $this$launch;
                        this.L$1 = bytesSend;
                        this.L$2 = var6_7;
                        this.L$3 = mpegTsPackets;
                        this.L$4 = var14_15;
                        this.J$0 = var12_14;
                        this.label = 2;
                        v1 = SrtSender.access$sendPackets(var6_7, psiPackets, (Continuation)this);
                        ** if (v1 != var16_2) goto lbl51
lbl50:
                        // 1 sources

                        return var16_2;
lbl51:
                        // 1 sources

                        ** GOTO lbl64
                    }
                    case 2: {
                        $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                        var12_14 = this.J$0;
                        var14_15 = (Ref.LongRef)this.L$4;
                        mpegTsPackets = (List)this.L$3;
                        var6_7 = (SrtSender)this.L$2;
                        bytesSend = (Ref.LongRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl64:
                        // 2 sources

                        var15_16 = v1;
                        var14_15.element = var12_14 + ((Number)var15_16).longValue();
                        var12_14 = bytesSend.element;
                        var14_15 = bytesSend;
                        Intrinsics.checkNotNull((Object)mpegTsPackets);
                        this.L$0 = $this$launch;
                        this.L$1 = bytesSend;
                        this.L$2 = var14_15;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.J$0 = var12_14;
                        this.label = 3;
                        v2 = SrtSender.access$sendPackets(var6_7, mpegTsPackets, (Continuation)this);
                        ** if (v2 != var16_2) goto lbl79
lbl78:
                        // 1 sources

                        return var16_2;
lbl79:
                        // 1 sources

                        ** GOTO lbl90
                    }
                    case 3: {
                        $i$a$-runCatching-SrtSender$start$1$error$1 = false;
                        var12_14 = this.J$0;
                        var14_15 = (Ref.LongRef)this.L$2;
                        bytesSend = (Ref.LongRef)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl90:
                            // 2 sources

                            var15_16 = v2;
                            var14_15.element = var12_14 + ((Number)var15_16).longValue();
                            var7_8 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable var8_10) {
                            var7_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_10));
                        }
                        if ((error = Result.exceptionOrNull-impl((Object)var7_8)) == null) ** GOTO lbl9
                        this.L$0 = error;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.label = 4;
                        v3 = ExtensionsKt.onMainThread((Function0)((Function0)new Function0<Unit>(this.this$0, error){
                            final /* synthetic */ SrtSender this$0;
                            final /* synthetic */ Throwable $error;
                            {
                                this.this$0 = $receiver;
                                this.$error = $error;
                                super(0);
                            }

                            public final void invoke() {
                                SrtSender.access$getConnectChecker$p(this.this$0).onConnectionFailed("Error send packet, " + this.$error.getMessage());
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl113
                    }
                    case 4: {
                        error = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl113:
                        // 2 sources

                        Log.e((String)"SrtSender", (String)"send error: ", (Throwable)error);
                        return Unit.INSTANCE;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendPackets(List<MpegTsPacket> var1_1, Continuation<? super Long> var2_2) {
        if (!(var2_2 instanceof sendPackets.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SrtSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SrtSender.access$sendPackets(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bytesSend = new Ref.LongRef();
                $this$forEach$iv = (Iterable)packets;
                $i$f$forEach = false;
                var6_9 = $this$forEach$iv.iterator();
lbl16:
                // 2 sources

                while (var6_9.hasNext()) {
                    element$iv = var6_9.next();
                    mpegTsPacket = (MpegTsPacket)element$iv;
                    $i$a$-forEach-SrtSender$sendPackets$2 = false;
                    var11_14 = size = 0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = bytesSend;
                    $continuation.L$2 = var6_9;
                    $continuation.L$3 = mpegTsPacket;
                    $continuation.I$0 = var11_14;
                    $continuation.label = 1;
                    v0 = this.commandsManager.writeData(mpegTsPacket, this.socket, (Continuation<? super Integer>)$continuation);
                    if (v0 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl42
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-SrtSender$sendPackets$2 = false;
                var11_14 = $continuation.I$0;
                mpegTsPacket = (MpegTsPacket)$continuation.L$3;
                var6_9 = (Iterator)$continuation.L$2;
                bytesSend = (Ref.LongRef)$continuation.L$1;
                this = (SrtSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 2 sources

                var12_15 = v0;
                size = var11_14 + ((Number)var12_15).intValue();
                if (this.isEnableLogs) {
                    Log.i((String)"SrtSender", (String)("wrote " + mpegTsPacket.getType().name() + " packet, size " + size));
                }
                bytesSend.element += (long)size;
                ** GOTO lbl16
            }
        }
        return Boxing.boxLong((long)bytesSend.element);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(boolean var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof stop.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SrtSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                this.psiManager.reset();
                this.service.clear();
                this.mpegTsPacketizer.reset();
                this.audioPacket.reset(clear != false);
                this.h26XPacket.reset(clear != false);
                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v0 = this.job;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                break;
            }
            case 1: {
                this = (SrtSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(SrtSender srtSender, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return srtSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(SrtSender $this) {
        return $this.queue;
    }

    public static final /* synthetic */ void access$setDroppedVideoFrames$p(SrtSender $this, long l) {
        $this.droppedVideoFrames = l;
    }

    public static final /* synthetic */ void access$setDroppedAudioFrames$p(SrtSender $this, long l) {
        $this.droppedAudioFrames = l;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(SrtSender $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getRunning$p(SrtSender $this) {
        return $this.running;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(SrtSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(SrtSender $this) {
        return $this.connectChecker;
    }

    public static final /* synthetic */ PsiManager access$getPsiManager$p(SrtSender $this) {
        return $this.psiManager;
    }

    public static final /* synthetic */ MpegTsPacketizer access$getMpegTsPacketizer$p(SrtSender $this) {
        return $this.mpegTsPacketizer;
    }

    public static final /* synthetic */ Object access$sendPackets(SrtSender $this, List packets, Continuation $completion) {
        return $this.sendPackets(packets, (Continuation<? super Long>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/srt/srt/SrtSender$Companion;", "", "()V", "TAG", "", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.AAC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.G711.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

