/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.psi;

import com.pedro.common.TimeUtils;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.psi.Pat;
import com.pedro.srt.mpeg2ts.psi.Pmt;
import com.pedro.srt.mpeg2ts.psi.Psi;
import com.pedro.srt.mpeg2ts.psi.Sdt;
import com.pedro.srt.mpeg2ts.service.Mpeg2TsService;
import com.pedro.srt.mpeg2ts.service.Track;
import com.pedro.srt.srt.packets.data.PacketPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "", "service", "Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;", "(Lcom/pedro/srt/mpeg2ts/service/Mpeg2TsService;)V", "idExtension", "", "lastTime", "", "pat", "Lcom/pedro/srt/mpeg2ts/psi/Pat;", "getPat", "()Lcom/pedro/srt/mpeg2ts/psi/Pat;", "sdt", "Lcom/pedro/srt/mpeg2ts/psi/Sdt;", "getSdt", "()Lcom/pedro/srt/mpeg2ts/psi/Sdt;", "checkSendInfo", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "isKey", "", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "getAudioPid", "getVideoPid", "reset", "", "updateService", "upgradePatVersion", "upgradeSdtVersion", "Companion", "srt_release"})
@SourceDebugExtension(value={"SMAP\nPsiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiManager.kt\ncom/pedro/srt/mpeg2ts/psi/PsiManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n1#3:95\n*S KotlinDebug\n*F\n+ 1 PsiManager.kt\ncom/pedro/srt/mpeg2ts/psi/PsiManager\n*L\n57#1:91\n57#1:92,3\n*E\n"})
public final class PsiManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Mpeg2TsService service;
    private final short idExtension;
    private long lastTime;
    @NotNull
    private final Sdt sdt;
    @NotNull
    private final Pat pat;
    public static final int INTERVAL = 100;

    public PsiManager(@NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.idExtension = (short)Random.Default.nextInt(-128, 127);
        this.sdt = new Sdt(this.idExtension, 0, 0, this.service, 4, null);
        this.pat = new Pat(this.idExtension, 0, this.service);
    }

    @NotNull
    public final Sdt getSdt() {
        return this.sdt;
    }

    @NotNull
    public final Pat getPat() {
        return this.pat;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MpegTsPacket> checkSendInfo(boolean isKey, @NotNull MpegTsPacketizer mpegTsPacketizer) {
        Intrinsics.checkNotNullParameter((Object)mpegTsPacketizer, (String)"mpegTsPacketizer");
        Pmt pmt = this.service.getPmt();
        if (pmt == null) {
            return new ArrayList();
        }
        Pmt pmt2 = pmt;
        long currentTime = TimeUtils.getCurrentTimeMillis();
        if (isKey || TimeUtils.getCurrentTimeMillis() - this.lastTime >= 100L) {
            void $this$mapTo$iv$iv;
            this.lastTime = currentTime;
            Object[] objectArray = new Psi[]{this.pat, pmt2, this.sdt};
            Iterable $this$map$iv = mpegTsPacketizer.write(CollectionsKt.listOf((Object[])objectArray), true);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void b;
                byte[] byArray = (byte[])item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new MpegTsPacket((byte[])b, MpegType.PSI, PacketPosition.SINGLE, false));
            }
            List psiPackets = (List)destination$iv$iv;
            return psiPackets;
        }
        return new ArrayList();
    }

    public static /* synthetic */ List checkSendInfo$default(PsiManager psiManager, boolean bl, MpegTsPacketizer mpegTsPacketizer, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return psiManager.checkSendInfo(bl, mpegTsPacketizer);
    }

    public final void upgradeSdtVersion() {
        this.sdt.setVersion((byte)(this.sdt.getVersion() + 1));
    }

    public final void upgradePatVersion() {
        this.pat.setVersion((byte)(this.pat.getVersion() + 1));
    }

    public final short getAudioPid() {
        Object v0;
        block1: {
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!it.getCodec().isAudio()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Track track = v0;
        return track != null ? track.getPid() : (short)0;
    }

    public final short getVideoPid() {
        Object v0;
        block1: {
            Iterable iterable = this.service.getTracks();
            for (Object t : iterable) {
                Track it = (Track)t;
                boolean bl = false;
                if (!(!it.getCodec().isAudio())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Track track = v0;
        return track != null ? track.getPid() : (short)0;
    }

    public final void reset() {
        this.lastTime = 0L;
    }

    public final void updateService(@NotNull Mpeg2TsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
        this.sdt.setService(service);
        this.pat.setService(service);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/srt/mpeg2ts/psi/PsiManager$Companion;", "", "()V", "INTERVAL", "", "srt_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

