/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts;

import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bk\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c2\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c2\u0003\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\nH\u00c2\u0003\u00a2\u0006\u0002\u0010\"J\u000b\u0010#\u001a\u0004\u0018\u00010\fH\u00c2\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\fH\u00c2\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\fH\u00c2\u0003Jt\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010*\u001a\u00020\fJ\u0006\u0010+\u001a\u00020\u0011J\t\u0010,\u001a\u00020\u0011H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/pedro/srt/mpeg2ts/AdaptationField;", "", "discontinuityIndicator", "", "randomAccessIndicator", "elementaryStreamPriorityIndicator", "pcr", "", "opcr", "spliceCountdown", "", "transportPrivateData", "", "adaptationExtension", "stuffingBytes", "(ZZZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/Byte;[B[B[B)V", "length", "", "Ljava/lang/Long;", "Ljava/lang/Byte;", "transportPrivateDataLength", "addClockReference", "", "buffer", "Ljava/nio/ByteBuffer;", "timestamp", "calculateSize", "component1", "component2", "component3", "component4", "()Ljava/lang/Long;", "component5", "component6", "()Ljava/lang/Byte;", "component7", "component8", "component9", "copy", "(ZZZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/Byte;[B[B[B)Lcom/pedro/srt/mpeg2ts/AdaptationField;", "equals", "other", "getData", "getSize", "hashCode", "toString", "", "srt_release"})
@SourceDebugExtension(value={"SMAP\nAdaptationField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptationField.kt\ncom/pedro/srt/mpeg2ts/AdaptationField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class AdaptationField {
    private final boolean discontinuityIndicator;
    private final boolean randomAccessIndicator;
    private final boolean elementaryStreamPriorityIndicator;
    @Nullable
    private final Long pcr;
    @Nullable
    private final Long opcr;
    @Nullable
    private final Byte spliceCountdown;
    @Nullable
    private final byte[] transportPrivateData;
    @Nullable
    private final byte[] adaptationExtension;
    @Nullable
    private final byte[] stuffingBytes;
    private final int length;
    private final int transportPrivateDataLength;

    public AdaptationField(boolean discontinuityIndicator, boolean randomAccessIndicator, boolean elementaryStreamPriorityIndicator, @Nullable Long pcr, @Nullable Long opcr, @Nullable Byte spliceCountdown, @Nullable byte[] transportPrivateData, @Nullable byte[] adaptationExtension, @Nullable byte[] stuffingBytes) {
        this.discontinuityIndicator = discontinuityIndicator;
        this.randomAccessIndicator = randomAccessIndicator;
        this.elementaryStreamPriorityIndicator = elementaryStreamPriorityIndicator;
        this.pcr = pcr;
        this.opcr = opcr;
        this.spliceCountdown = spliceCountdown;
        this.transportPrivateData = transportPrivateData;
        this.adaptationExtension = adaptationExtension;
        this.stuffingBytes = stuffingBytes;
        this.length = this.calculateSize();
        this.transportPrivateDataLength = this.transportPrivateData != null ? this.transportPrivateData.length : 0;
    }

    public /* synthetic */ AdaptationField(boolean bl, boolean bl2, boolean bl3, Long l, Long l2, Byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            l = null;
        }
        if ((n & 0x10) != 0) {
            l2 = null;
        }
        if ((n & 0x20) != 0) {
            by = null;
        }
        if ((n & 0x40) != 0) {
            byArray = null;
        }
        if ((n & 0x80) != 0) {
            byArray2 = null;
        }
        if ((n & 0x100) != 0) {
            byArray3 = null;
        }
        this(bl, bl2, bl3, l, l2, by, byArray, byArray2, byArray3);
    }

    @NotNull
    public final byte[] getData() {
        long it;
        ByteBuffer buffer = ByteBuffer.allocate(this.length);
        buffer.put((byte)(this.length - 1));
        boolean pcrFlag = this.pcr != null;
        boolean opcrFlag = this.opcr != null;
        boolean splicingPointFlag = this.spliceCountdown != null;
        boolean transportPrivateDataFlag = this.transportPrivateData != null;
        boolean adaptationFieldExtensionFlag = this.adaptationExtension != null;
        byte indicatorsAndFlags = (byte)(ExtensionsKt.toInt(this.discontinuityIndicator) << 7 | ExtensionsKt.toInt(this.randomAccessIndicator) << 6 | ExtensionsKt.toInt(this.elementaryStreamPriorityIndicator) << 5 | ExtensionsKt.toInt(pcrFlag) << 4 | ExtensionsKt.toInt(opcrFlag) << 3 | ExtensionsKt.toInt(splicingPointFlag) << 2 | ExtensionsKt.toInt(transportPrivateDataFlag) << 1 | ExtensionsKt.toInt(adaptationFieldExtensionFlag));
        buffer.put(indicatorsAndFlags);
        Long l = this.pcr;
        if (l != null) {
            it = ((Number)l).longValue();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)buffer);
            this.addClockReference(buffer, it);
        }
        Long l2 = this.opcr;
        if (l2 != null) {
            it = ((Number)l2).longValue();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)buffer);
            this.addClockReference(buffer, it);
        }
        Byte by = this.spliceCountdown;
        if (by != null) {
            byte it2 = ((Number)by).byteValue();
            boolean bl = false;
            buffer.put(it2);
        }
        if (this.transportPrivateData != null) {
            byte[] it3 = this.transportPrivateData;
            boolean bl = false;
            buffer.put(it3);
        }
        if (this.transportPrivateData != null) {
            byte[] it4 = this.transportPrivateData;
            boolean bl = false;
            buffer.put(it4);
        }
        if (this.stuffingBytes != null) {
            byte[] it5 = this.stuffingBytes;
            boolean bl = false;
            buffer.put(it5);
        }
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    private final int calculateSize() {
        return 2 + (this.pcr != null ? 6 : 0) + (this.opcr != null ? 6 : 0) + (this.spliceCountdown != null ? 1 : 0) + (this.transportPrivateDataLength > 0 ? this.transportPrivateDataLength + 1 : 0) + (this.adaptationExtension != null ? this.adaptationExtension.length : 0) + (this.stuffingBytes != null ? this.stuffingBytes.length : 0);
    }

    public final int getSize() {
        return this.length;
    }

    private final void addClockReference(ByteBuffer buffer, long timestamp) {
        long pcrBase = (long)27000000 * timestamp / (long)1000000 / (long)300 % (long)Math.pow(2.0, 33);
        long pcrExt = (long)27000000 * timestamp / (long)1000000 % (long)300;
        buffer.putInt((int)(pcrBase >> 1));
        buffer.putShort((short)((pcrBase & 1L) << 15 | 0x7E00L | pcrExt & 0x1FFL));
    }

    private final boolean component1() {
        return this.discontinuityIndicator;
    }

    private final boolean component2() {
        return this.randomAccessIndicator;
    }

    private final boolean component3() {
        return this.elementaryStreamPriorityIndicator;
    }

    private final Long component4() {
        return this.pcr;
    }

    private final Long component5() {
        return this.opcr;
    }

    private final Byte component6() {
        return this.spliceCountdown;
    }

    private final byte[] component7() {
        return this.transportPrivateData;
    }

    private final byte[] component8() {
        return this.adaptationExtension;
    }

    private final byte[] component9() {
        return this.stuffingBytes;
    }

    @NotNull
    public final AdaptationField copy(boolean discontinuityIndicator, boolean randomAccessIndicator, boolean elementaryStreamPriorityIndicator, @Nullable Long pcr, @Nullable Long opcr, @Nullable Byte spliceCountdown, @Nullable byte[] transportPrivateData, @Nullable byte[] adaptationExtension, @Nullable byte[] stuffingBytes) {
        return new AdaptationField(discontinuityIndicator, randomAccessIndicator, elementaryStreamPriorityIndicator, pcr, opcr, spliceCountdown, transportPrivateData, adaptationExtension, stuffingBytes);
    }

    public static /* synthetic */ AdaptationField copy$default(AdaptationField adaptationField, boolean bl, boolean bl2, boolean bl3, Long l, Long l2, Byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = adaptationField.discontinuityIndicator;
        }
        if ((n & 2) != 0) {
            bl2 = adaptationField.randomAccessIndicator;
        }
        if ((n & 4) != 0) {
            bl3 = adaptationField.elementaryStreamPriorityIndicator;
        }
        if ((n & 8) != 0) {
            l = adaptationField.pcr;
        }
        if ((n & 0x10) != 0) {
            l2 = adaptationField.opcr;
        }
        if ((n & 0x20) != 0) {
            by = adaptationField.spliceCountdown;
        }
        if ((n & 0x40) != 0) {
            byArray = adaptationField.transportPrivateData;
        }
        if ((n & 0x80) != 0) {
            byArray2 = adaptationField.adaptationExtension;
        }
        if ((n & 0x100) != 0) {
            byArray3 = adaptationField.stuffingBytes;
        }
        return adaptationField.copy(bl, bl2, bl3, l, l2, by, byArray, byArray2, byArray3);
    }

    @NotNull
    public String toString() {
        return "AdaptationField(discontinuityIndicator=" + this.discontinuityIndicator + ", randomAccessIndicator=" + this.randomAccessIndicator + ", elementaryStreamPriorityIndicator=" + this.elementaryStreamPriorityIndicator + ", pcr=" + this.pcr + ", opcr=" + this.opcr + ", spliceCountdown=" + this.spliceCountdown + ", transportPrivateData=" + Arrays.toString(this.transportPrivateData) + ", adaptationExtension=" + Arrays.toString(this.adaptationExtension) + ", stuffingBytes=" + Arrays.toString(this.stuffingBytes) + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.discontinuityIndicator);
        result = result * 31 + Boolean.hashCode(this.randomAccessIndicator);
        result = result * 31 + Boolean.hashCode(this.elementaryStreamPriorityIndicator);
        result = result * 31 + (this.pcr == null ? 0 : ((Object)this.pcr).hashCode());
        result = result * 31 + (this.opcr == null ? 0 : ((Object)this.opcr).hashCode());
        result = result * 31 + (this.spliceCountdown == null ? 0 : ((Object)this.spliceCountdown).hashCode());
        result = result * 31 + (this.transportPrivateData == null ? 0 : Arrays.hashCode(this.transportPrivateData));
        result = result * 31 + (this.adaptationExtension == null ? 0 : Arrays.hashCode(this.adaptationExtension));
        result = result * 31 + (this.stuffingBytes == null ? 0 : Arrays.hashCode(this.stuffingBytes));
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdaptationField)) {
            return false;
        }
        AdaptationField adaptationField = (AdaptationField)other;
        if (this.discontinuityIndicator != adaptationField.discontinuityIndicator) {
            return false;
        }
        if (this.randomAccessIndicator != adaptationField.randomAccessIndicator) {
            return false;
        }
        if (this.elementaryStreamPriorityIndicator != adaptationField.elementaryStreamPriorityIndicator) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pcr, (Object)adaptationField.pcr)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.opcr, (Object)adaptationField.opcr)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spliceCountdown, (Object)adaptationField.spliceCountdown)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transportPrivateData, (Object)adaptationField.transportPrivateData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.adaptationExtension, (Object)adaptationField.adaptationExtension)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stuffingBytes, (Object)adaptationField.stuffingBytes);
    }

    public AdaptationField() {
        this(false, false, false, null, null, null, null, null, null, 511, null);
    }
}

