/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import android.media.MediaCodec;
import android.os.Build;
import android.util.Log;
import com.pedro.srt.mpeg2ts.Codec;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegType;
import com.pedro.srt.mpeg2ts.Pes;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.mpeg2ts.packets.BasePacket;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import com.pedro.srt.srt.packets.data.PacketPosition;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\u0012H\u0016J \u0010!\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pedro/srt/mpeg2ts/packets/H26XPacket;", "Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "limitSize", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "(ILcom/pedro/srt/mpeg2ts/psi/PsiManager;)V", "TAG", "", "codec", "Lcom/pedro/srt/mpeg2ts/Codec;", "configSend", "", "pps", "", "sps", "vps", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "fixHeader", "isKeyFrame", "getStartCodeSize", "getVideoInfoData", "removeHeader", "resetPacket", "sendVideoInfo", "setVideoCodec", "srt_release"})
@SourceDebugExtension(value={"SMAP\nH26XPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H26XPacket.kt\ncom/pedro/srt/mpeg2ts/packets/H26XPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1864#2,2:218\n1855#2,2:221\n1866#2:223\n1#3:220\n*S KotlinDebug\n*F\n+ 1 H26XPacket.kt\ncom/pedro/srt/mpeg2ts/packets/H26XPacket\n*L\n90#1:218,2\n93#1:221,2\n90#1:223\n*E\n"})
public final class H26XPacket
extends BasePacket {
    @NotNull
    private final String TAG;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    @Nullable
    private byte[] vps;
    @NotNull
    private Codec codec;
    private boolean configSend;

    public H26XPacket(int limitSize, @NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        super(psiManager, limitSize);
        this.TAG = "H26XPacket";
        this.codec = Codec.AVC;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo info, @NotNull Function1<? super List<MpegTsPacket>, Unit> callback) {
        boolean isKeyFrame;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        int length = info.size;
        if (length < 0) {
            return;
        }
        boolean bl = Build.VERSION.SDK_INT >= 21 ? info.flags == 1 : (isKeyFrame = info.flags == 1);
        if (this.codec == Codec.HEVC) {
            sps = this.sps;
            pps = this.pps;
            byte[] vps = this.vps;
            if (sps == null || pps == null || vps == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid sps, pps and vps");
                return;
            }
        } else {
            sps = this.sps;
            pps = this.pps;
            if (sps == null || pps == null) {
                Log.e((String)this.TAG, (String)"waiting for a valid sps and pps");
                return;
            }
        }
        byteBuffer.rewind();
        ByteBuffer validBuffer = this.fixHeader(byteBuffer, isKeyFrame);
        byte[] payload = new byte[validBuffer.remaining()];
        validBuffer.get(payload, 0, validBuffer.remaining());
        short s = this.getPsiManager().getVideoPid();
        long l = info.presentationTimeUs;
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"wrap(...)");
        Pes pes = new Pes(s, isKeyFrame, PesType.VIDEO, l, byteBuffer2);
        List<byte[]> mpeg2tsPackets = this.getMpegTsPacketizer().write(CollectionsKt.listOf((Object)pes));
        List chunked = CollectionsKt.chunked((Iterable)mpeg2tsPackets, (int)this.getChunkSize());
        List packets = new ArrayList();
        Iterable $this$forEachIndexed$iv = chunked;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object2;
            void chunks;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl2 = false;
            Iterable iterable = (Iterable)chunks;
            int n2 = 0;
            for (Object object2 : iterable) {
                void it;
                byte[] byArray = (byte[])object2;
                int n3 = n2;
                boolean bl3 = false;
                int n4 = ((void)it).length;
                n2 = n3 + n4;
            }
            int size = n2;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            Iterable $this$forEach$iv = (Iterable)chunks;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                byte[] it = (byte[])element$iv;
                boolean bl4 = false;
                buffer.put(it);
            }
            PacketPosition packetPosition = index == 0 && chunked.size() == 1 ? PacketPosition.SINGLE : (index == 0 ? PacketPosition.FIRST : (index == chunked.size() - 1 ? PacketPosition.LAST : PacketPosition.MIDDLE));
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            packets.add(new MpegTsPacket(byArray, MpegType.VIDEO, packetPosition));
        }
        callback.invoke((Object)packets);
    }

    @Override
    public void resetPacket() {
        this.vps = null;
        this.sps = null;
        this.pps = null;
        this.configSend = false;
    }

    public final void setVideoCodec(@NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)((Object)codec), (String)"codec");
        this.codec = codec;
    }

    public final void sendVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.sps = this.getVideoInfoData(sps);
        this.pps = this.getVideoInfoData(pps);
        ByteBuffer byteBuffer = vps;
        this.vps = byteBuffer != null ? this.getVideoInfoData(byteBuffer) : null;
    }

    private final ByteBuffer fixHeader(ByteBuffer byteBuffer, boolean isKeyFrame) {
        ByteBuffer byteBuffer2;
        ByteBuffer noHeaderBuffer = this.removeHeader(byteBuffer, isKeyFrame);
        int startCodeSize = this.getStartCodeSize(noHeaderBuffer);
        if (startCodeSize == 0) {
            ByteBuffer bufferWithPrefix = ByteBuffer.allocate(noHeaderBuffer.remaining() + 4);
            bufferWithPrefix.putInt(1);
            bufferWithPrefix.put(noHeaderBuffer);
            Intrinsics.checkNotNull((Object)bufferWithPrefix);
            noHeaderBuffer = bufferWithPrefix;
        }
        if (isKeyFrame && !this.configSend) {
            byte[] byArray = this.vps;
            if (this.vps == null) {
                byArray = new byte[]{};
            }
            byte[] vps = byArray;
            byte[] byArray2 = this.sps;
            if (this.sps == null) {
                byArray2 = new byte[]{};
            }
            byte[] sps = byArray2;
            byte[] byArray3 = this.pps;
            if (this.pps == null) {
                byArray3 = new byte[]{};
            }
            byte[] pps = byArray3;
            int keyExtraSize = vps.length + sps.length + pps.length;
            ByteBuffer validBuffer = ByteBuffer.allocate(noHeaderBuffer.remaining() + keyExtraSize);
            byte[] videoHeader = ArraysKt.plus((byte[])ArraysKt.plus((byte[])vps, (byte[])sps), (byte[])pps);
            validBuffer.put(videoHeader);
            validBuffer.put(ExtensionsKt.toByteArray(noHeaderBuffer));
            validBuffer.rewind();
            this.configSend = true;
            ByteBuffer byteBuffer3 = validBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer3);
            byteBuffer2 = byteBuffer3;
        } else {
            noHeaderBuffer.rewind();
            byteBuffer2 = noHeaderBuffer;
        }
        return byteBuffer2;
    }

    private final byte[] getVideoInfoData(ByteBuffer byteBuffer) {
        byte[] byArray;
        byteBuffer.rewind();
        int startCodeSize = this.getStartCodeSize(byteBuffer);
        if (startCodeSize == 0) {
            ByteBuffer validBuffer = ByteBuffer.allocate(byteBuffer.remaining() + 4);
            validBuffer.putInt(1);
            validBuffer.put(byteBuffer);
            Intrinsics.checkNotNull((Object)validBuffer);
            byArray = ExtensionsKt.toByteArray(validBuffer);
        } else {
            byArray = ExtensionsKt.toByteArray(byteBuffer);
        }
        return byArray;
    }

    private final ByteBuffer removeHeader(ByteBuffer byteBuffer, boolean isKeyFrame) {
        if (isKeyFrame) {
            byte[] pps;
            ByteBuffer validBuffer = byteBuffer;
            byte[] byArray = this.vps;
            if (this.vps == null) {
                byArray = new byte[]{};
            }
            byte[] vps = byArray;
            byte[] byArray2 = this.sps;
            if (this.sps == null) {
                byArray2 = new byte[]{};
            }
            byte[] sps = byArray2;
            byte[] byArray3 = this.pps;
            if (this.pps == null) {
                byArray3 = pps = new byte[]{};
            }
            if (!(vps.length == 0) && ExtensionsKt.startWith(validBuffer, vps)) {
                validBuffer.position(vps.length);
                ByteBuffer byteBuffer2 = validBuffer.slice();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"slice(...)");
                validBuffer = byteBuffer2;
            }
            if (!(sps.length == 0) && ExtensionsKt.startWith(validBuffer, sps)) {
                validBuffer.position(sps.length);
                ByteBuffer byteBuffer3 = validBuffer.slice();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"slice(...)");
                validBuffer = byteBuffer3;
            }
            if (!(pps.length == 0) && ExtensionsKt.startWith(validBuffer, pps)) {
                validBuffer.position(pps.length);
                ByteBuffer byteBuffer4 = validBuffer.slice();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"slice(...)");
                validBuffer = byteBuffer4;
            }
            validBuffer.rewind();
            return validBuffer;
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private final int getStartCodeSize(ByteBuffer byteBuffer) {
        int startCodeSize = 0;
        if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 0 && byteBuffer.get(3) == 1) {
            startCodeSize = 4;
        } else if (byteBuffer.get(0) == 0 && byteBuffer.get(1) == 0 && byteBuffer.get(2) == 1) {
            startCodeSize = 3;
        }
        return startCodeSize;
    }
}

