/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts.packets;

import android.media.MediaCodec;
import com.pedro.srt.mpeg2ts.MpegTsPacket;
import com.pedro.srt.mpeg2ts.MpegTsPacketizer;
import com.pedro.srt.mpeg2ts.psi.PsiManager;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020\u00130\u0019H&J\u0006\u0010\u001c\u001a\u00020\u0013J\b\u0010\u001d\u001a\u00020\u0013H&J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005R\u001a\u0010\u0007\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/pedro/srt/mpeg2ts/packets/BasePacket;", "", "psiManager", "Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "limitSize", "", "(Lcom/pedro/srt/mpeg2ts/psi/PsiManager;I)V", "chunkSize", "getChunkSize", "()I", "setChunkSize", "(I)V", "mpegTsPacketizer", "Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "getMpegTsPacketizer", "()Lcom/pedro/srt/mpeg2ts/MpegTsPacketizer;", "getPsiManager", "()Lcom/pedro/srt/mpeg2ts/psi/PsiManager;", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "callback", "Lkotlin/Function1;", "", "Lcom/pedro/srt/mpeg2ts/MpegTsPacket;", "reset", "resetPacket", "setLimitSize", "srt_release"})
public abstract class BasePacket {
    @NotNull
    private final PsiManager psiManager;
    private int limitSize;
    @NotNull
    private final MpegTsPacketizer mpegTsPacketizer;
    private int chunkSize;

    public BasePacket(@NotNull PsiManager psiManager, int limitSize) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        this.psiManager = psiManager;
        this.limitSize = limitSize;
        this.mpegTsPacketizer = new MpegTsPacketizer();
        this.chunkSize = this.limitSize / 188;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        return this.psiManager;
    }

    @NotNull
    protected final MpegTsPacketizer getMpegTsPacketizer() {
        return this.mpegTsPacketizer;
    }

    protected final int getChunkSize() {
        return this.chunkSize;
    }

    protected final void setChunkSize(int n) {
        this.chunkSize = n;
    }

    public abstract void createAndSendPacket(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2, @NotNull Function1<? super List<MpegTsPacket>, Unit> var3);

    public abstract void resetPacket();

    public final void reset() {
        this.mpegTsPacketizer.reset();
        this.resetPacket();
    }

    public final void setLimitSize(int limitSize) {
        this.limitSize = limitSize;
        this.chunkSize = limitSize / 188;
    }
}

