/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016JA\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J8\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcom/pedro/rtsp/rtcp/SenderReportUdp;", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "videoSourcePort", "", "audioSourcePort", "multicastSocketVideo", "Ljava/net/MulticastSocket;", "multicastSocketAudio", "(IILjava/net/MulticastSocket;Ljava/net/MulticastSocket;)V", "datagramPacket", "Ljava/net/DatagramPacket;", "close", "", "sendReport", "buffer", "", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "type", "", "packetCount", "", "octetCount", "isEnableLogs", "", "([BLcom/pedro/rtsp/rtsp/RtpFrame;Ljava/lang/String;JJZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendReportUDP", "port", "packet", "octet", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "rtsp_release"})
public final class SenderReportUdp
extends BaseSenderReport {
    @Nullable
    private MulticastSocket multicastSocketVideo;
    @Nullable
    private MulticastSocket multicastSocketAudio;
    @NotNull
    private final DatagramPacket datagramPacket;

    public SenderReportUdp(int videoSourcePort, int audioSourcePort, @Nullable MulticastSocket multicastSocketVideo, @Nullable MulticastSocket multicastSocketAudio) {
        this.multicastSocketVideo = multicastSocketVideo;
        this.multicastSocketAudio = multicastSocketAudio;
        byte[] byArray = new byte[]{0};
        this.datagramPacket = new DatagramPacket(byArray, 1);
        if (this.multicastSocketVideo == null) {
            this.multicastSocketVideo = new MulticastSocket(videoSourcePort);
        }
        MulticastSocket multicastSocket = this.multicastSocketVideo;
        if (multicastSocket != null) {
            multicastSocket.setTimeToLive(64);
        }
        if (this.multicastSocketAudio == null) {
            this.multicastSocketAudio = new MulticastSocket(audioSourcePort);
        }
        MulticastSocket multicastSocket2 = this.multicastSocketAudio;
        if (multicastSocket2 != null) {
            multicastSocket2.setTimeToLive(64);
        }
    }

    public /* synthetic */ SenderReportUdp(int n, int n2, MulticastSocket multicastSocket, MulticastSocket multicastSocket2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            multicastSocket = null;
        }
        if ((n3 & 8) != 0) {
            multicastSocket2 = null;
        }
        this(n, n2, multicastSocket, multicastSocket2);
    }

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.datagramPacket.setAddress(InetAddress.getByName(host));
    }

    @Override
    @Nullable
    public Object sendReport(@NotNull byte[] buffer, @NotNull RtpFrame rtpFrame2, @NotNull String type, long packetCount, long octetCount, boolean isEnableLogs, @NotNull Continuation<? super Unit> $completion) throws IOException {
        this.sendReportUDP(buffer, rtpFrame2.getRtcpPort(), type, packetCount, octetCount, isEnableLogs);
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        block1: {
            MulticastSocket multicastSocket = this.multicastSocketVideo;
            if (multicastSocket != null) {
                multicastSocket.close();
            }
            MulticastSocket multicastSocket2 = this.multicastSocketAudio;
            if (multicastSocket2 == null) break block1;
            multicastSocket2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendReportUDP(byte[] buffer, int port, String type, long packet, long octet, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            boolean bl = false;
            this.datagramPacket.setData(buffer);
            this.datagramPacket.setPort(port);
            this.datagramPacket.setLength(this.getPACKET_LENGTH());
            if (Intrinsics.areEqual((Object)type, (Object)"Video")) {
                MulticastSocket multicastSocket = this.multicastSocketVideo;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            } else {
                MulticastSocket multicastSocket = this.multicastSocketAudio;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote report: " + type + ", port: " + port + ", packets: " + packet + ", octet: " + octet));
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

