/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.nio.ByteBuffer;

public class H264Packet
extends BasePacket {
    private byte[] header = new byte[5];
    private byte[] stapA;
    private VideoPacketCallback videoPacketCallback;

    public H264Packet(byte[] sps, byte[] pps, VideoPacketCallback videoPacketCallback) {
        super(90000L);
        this.videoPacketCallback = videoPacketCallback;
        this.channelIdentifier = (byte)2;
        this.setSpsPps(sps, pps);
    }

    @Override
    public void createAndSendPacket(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        byteBuffer.rewind();
        byteBuffer.get(this.header, 0, 5);
        long ts = bufferInfo.presentationTimeUs * 1000L;
        int naluLength = bufferInfo.size - byteBuffer.position() + 1;
        int type = this.header[4] & 0x1F;
        if (type == 5) {
            byte[] buffer = this.getBuffer(this.stapA.length + 12);
            this.updateTimeStamp(buffer, ts);
            this.markPacket(buffer);
            System.arraycopy(this.stapA, 0, buffer, 12, this.stapA.length);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, ts, this.stapA.length + 12, this.rtpPort, this.rtcpPort, this.channelIdentifier);
            this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
        }
        if (naluLength <= 1258) {
            int cont = naluLength - 1;
            int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
            byte[] buffer = this.getBuffer(length + 12 + 1);
            buffer[12] = this.header[4];
            byteBuffer.get(buffer, 13, length);
            this.updateTimeStamp(buffer, ts);
            this.markPacket(buffer);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, ts, naluLength + 12, this.rtpPort, this.rtcpPort, this.channelIdentifier);
            this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
        } else {
            this.header[1] = (byte)(this.header[4] & 0x1F);
            this.header[1] = (byte)(this.header[1] + 128);
            this.header[0] = (byte)(this.header[4] & 0x60 & 0xFF);
            this.header[0] = (byte)(this.header[0] + 28);
            int sum = 1;
            while (sum < naluLength) {
                int cont = naluLength - sum > 1258 ? 1258 : naluLength - sum;
                int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                byte[] buffer = this.getBuffer(length + 12 + 2);
                buffer[12] = this.header[0];
                buffer[13] = this.header[1];
                this.updateTimeStamp(buffer, ts);
                byteBuffer.get(buffer, 14, length);
                if ((sum += length) >= naluLength) {
                    buffer[13] = (byte)(buffer[13] + 64);
                    this.markPacket(buffer);
                }
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, ts, length + 12 + 2, this.rtpPort, this.rtcpPort, this.channelIdentifier);
                this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
                this.header[1] = (byte)(this.header[1] & 0x7F);
            }
        }
    }

    private void setSpsPps(byte[] sps, byte[] pps) {
        this.stapA = new byte[sps.length + pps.length + 5];
        this.stapA[0] = 24;
        this.stapA[1] = (byte)(sps.length >> 8);
        this.stapA[2] = (byte)(sps.length & 0xFF);
        this.stapA[sps.length + 3] = (byte)(pps.length >> 8);
        this.stapA[sps.length + 4] = (byte)(pps.length & 0xFF);
        System.arraycopy(sps, 0, this.stapA, 3, sps.length);
        System.arraycopy(pps, 0, this.stapA, 5 + sps.length, pps.length);
    }
}

