/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Base64;
import android.util.Log;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtsp.Body;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.utils.AuthUtil;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.CreateSSLSocket;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RtspClient {
    private final String TAG = "RtspClient";
    private static final Pattern rtspUrlPattern = Pattern.compile("^rtsps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
    private final long timestamp;
    private String host = "";
    private int port;
    private String path;
    private int sampleRate = 44100;
    private boolean isStereo = true;
    private final int trackVideo = 1;
    private final int trackAudio = 0;
    private Protocol protocol = Protocol.TCP;
    private int mCSeq = 0;
    private String authorization = null;
    private String user;
    private String password;
    private String sessionId;
    private ConnectCheckerRtsp connectCheckerRtsp;
    private Socket connectionSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private Thread thread;
    private byte[] sps;
    private byte[] pps;
    private String defaultSPS = "Z0KAHtoHgUZA";
    private String defaultPPS = "aM4NiA==";
    private int[] audioPorts = new int[]{5000, 5001};
    private int[] videoPorts = new int[]{5002, 5003};
    private OutputStream outputStream;
    private volatile boolean streaming = false;
    private boolean tlsEnabled = false;
    private H264Packet h264Packet;
    private AacPacket aacPacket;

    public RtspClient(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        long uptime = System.currentTimeMillis();
        this.timestamp = uptime / 1000L << 32 & (uptime - uptime / 1000L * 1000L >> 32) / 1000L;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setAuthorization(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setUrl(String url) {
        Matcher rtspMatcher = rtspUrlPattern.matcher(url);
        if (!rtspMatcher.matches()) {
            this.streaming = false;
            this.connectCheckerRtsp.onConnectionFailedRtsp("Endpoint malformed, should be: rtsp://ip:port/appname/streamname");
            return;
        }
        this.tlsEnabled = rtspMatcher.group(0).startsWith("rtsps");
        this.host = rtspMatcher.group(1);
        this.port = Integer.parseInt(rtspMatcher.group(2) != null ? rtspMatcher.group(2) : "1935");
        this.path = "/" + rtspMatcher.group(3) + "/" + rtspMatcher.group(4);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public ConnectCheckerRtsp getConnectCheckerRtsp() {
        return this.connectCheckerRtsp;
    }

    public void setSPSandPPS(ByteBuffer sps, ByteBuffer pps) {
        byte[] mSPS = new byte[sps.capacity() - 4];
        sps.position(4);
        sps.get(mSPS, 0, mSPS.length);
        byte[] mPPS = new byte[pps.capacity() - 4];
        pps.position(4);
        pps.get(mPPS, 0, mPPS.length);
        this.sps = mSPS;
        this.pps = mPPS;
    }

    public void setIsStereo(boolean isStereo) {
        this.isStereo = isStereo;
    }

    public void connect() {
        if (!this.streaming) {
            this.h264Packet = new H264Packet(this, this.protocol);
            if (this.sps != null && this.pps != null) {
                this.h264Packet.setSPSandPPS(this.sps, this.pps);
            }
            this.aacPacket = new AacPacket(this, this.protocol);
            this.aacPacket.setSampleRate(this.sampleRate);
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!RtspClient.this.tlsEnabled) {
                            RtspClient.this.connectionSocket = new Socket();
                            InetSocketAddress socketAddress = new InetSocketAddress(RtspClient.this.host, RtspClient.this.port);
                            RtspClient.this.connectionSocket.connect(socketAddress, 5000);
                        } else {
                            RtspClient.this.connectionSocket = CreateSSLSocket.createSSlSocket(RtspClient.this.host, RtspClient.this.port);
                            if (RtspClient.this.connectionSocket == null) {
                                throw new IOException("Socket creation failed");
                            }
                        }
                        RtspClient.this.connectionSocket.setSoTimeout(5000);
                        RtspClient.this.reader = new BufferedReader(new InputStreamReader(RtspClient.this.connectionSocket.getInputStream()));
                        RtspClient.this.outputStream = RtspClient.this.connectionSocket.getOutputStream();
                        RtspClient.this.writer = new BufferedWriter(new OutputStreamWriter(RtspClient.this.outputStream));
                        RtspClient.this.writer.write(RtspClient.this.sendOptions());
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(false, false);
                        RtspClient.this.writer.write(RtspClient.this.sendAnnounce());
                        RtspClient.this.writer.flush();
                        String response = RtspClient.this.getResponse(false, false);
                        int status = RtspClient.this.getResponseStatus(response);
                        if (status == 403) {
                            RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, access denied");
                            Log.e((String)"RtspClient", (String)"Response 403, access denied");
                            return;
                        }
                        if (status == 401) {
                            if (RtspClient.this.user == null || RtspClient.this.password == null) {
                                RtspClient.this.connectCheckerRtsp.onAuthErrorRtsp();
                                return;
                            }
                            RtspClient.this.writer.write(RtspClient.this.sendAnnounceWithAuth(response));
                            RtspClient.this.writer.flush();
                            int statusAuth = RtspClient.this.getResponseStatus(RtspClient.this.getResponse(false, false));
                            if (statusAuth == 401) {
                                RtspClient.this.connectCheckerRtsp.onAuthErrorRtsp();
                                return;
                            }
                            if (statusAuth == 200) {
                                RtspClient.this.connectCheckerRtsp.onAuthSuccessRtsp();
                            } else {
                                RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, announce with auth failed");
                            }
                        } else if (status != 200) {
                            RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, announce failed");
                        }
                        RtspClient.this.writer.write(RtspClient.this.sendSetup(0, RtspClient.this.protocol));
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(true, true);
                        RtspClient.this.writer.write(RtspClient.this.sendSetup(1, RtspClient.this.protocol));
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(false, true);
                        RtspClient.this.writer.write(RtspClient.this.sendRecord());
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(false, true);
                        RtspClient.this.h264Packet.updateDestinationVideo();
                        RtspClient.this.aacPacket.updateDestinationAudio();
                        RtspClient.this.streaming = true;
                        RtspClient.this.connectCheckerRtsp.onConnectionSuccessRtsp();
                    }
                    catch (IOException | NullPointerException e) {
                        Log.e((String)"RtspClient", (String)"connection error", (Throwable)e);
                        RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, " + e.getMessage());
                        RtspClient.this.streaming = false;
                    }
                }
            });
            this.thread.start();
        }
    }

    public void disconnect() {
        if (this.streaming) {
            this.streaming = false;
            if (this.h264Packet != null && this.aacPacket != null) {
                this.h264Packet.close();
                this.aacPacket.close();
            }
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RtspClient.this.writer.write(RtspClient.this.sendTearDown());
                        RtspClient.this.connectionSocket.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"RtspClient", (String)"disconnect error", (Throwable)e);
                    }
                    RtspClient.this.connectCheckerRtsp.onDisconnectRtsp();
                }
            });
            this.thread.start();
            this.mCSeq = 0;
            this.sps = null;
            this.pps = null;
            this.sessionId = null;
        }
    }

    private String sendAnnounce() {
        String body = this.createBody();
        String announce = this.authorization == null ? "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.mCSeq + "\r\nContent-Length: " + body.length() + "\r\nContent-Type: application/sdp\r\n\r\n" + body : "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.mCSeq + "\r\nContent-Length: " + body.length() + "\r\nAuthorization: " + this.authorization + "\r\nContent-Type: application/sdp\r\n\r\n" + body;
        Log.i((String)"RtspClient", (String)announce);
        return announce;
    }

    private String createBody() {
        String sPPS;
        String sSPS;
        if (this.sps != null && this.pps != null) {
            sSPS = Base64.encodeToString((byte[])this.sps, (int)0, (int)this.sps.length, (int)2);
            sPPS = Base64.encodeToString((byte[])this.pps, (int)0, (int)this.pps.length, (int)2);
        } else {
            sSPS = this.defaultSPS;
            sPPS = this.defaultPPS;
        }
        return "v=0\r\no=- " + this.timestamp + " " + this.timestamp + " IN IP4 127.0.0.1\r\ns=Unnamed\r\ni=N/A\r\nc=IN IP4 " + this.host + "\r\nt=0 0\r\na=recvonly\r\n" + Body.createAudioBody(0, this.sampleRate, this.isStereo) + Body.createVideoBody(1, sSPS, sPPS);
    }

    private String sendSetup(int track, Protocol protocol) {
        String params = protocol == Protocol.UDP ? "UDP;unicast;client_port=" + (5000 + 2 * track) + "-" + (5000 + 2 * track + 1) + ";mode=record" : "TCP;interleaved=" + 2 * track + "-" + (2 * track + 1) + ";mode=record";
        String setup = "SETUP rtsp://" + this.host + ":" + this.port + this.path + "/trackID=" + track + " RTSP/1.0\r\nTransport: RTP/AVP/" + params + "\r\n" + this.addHeaders(this.authorization);
        Log.i((String)"RtspClient", (String)setup);
        return setup;
    }

    private String sendOptions() {
        String options = "OPTIONS rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders(this.authorization);
        Log.i((String)"RtspClient", (String)options);
        return options;
    }

    private String sendRecord() {
        String record = "RECORD rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nRange: npt=0.000-\r\n" + this.addHeaders(this.authorization);
        Log.i((String)"RtspClient", (String)record);
        return record;
    }

    private String sendTearDown() {
        String teardown = "TEARDOWN rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders(this.authorization);
        Log.i((String)"RtspClient", (String)teardown);
        return teardown;
    }

    private String addHeaders(String authorization) {
        return "CSeq: " + ++this.mCSeq + "\r\n" + (this.sessionId != null ? "Session: " + this.sessionId + "\r\n" : "") + (authorization != null ? "Authorization: " + authorization + "\r\n" : "") + "\r\n";
    }

    private String getResponse(boolean isAudio, boolean checkStatus) {
        try {
            String line;
            String response = "";
            while ((line = this.reader.readLine()) != null) {
                Matcher matcher;
                Pattern rtspPattern;
                if (line.contains("Session")) {
                    rtspPattern = Pattern.compile("Session: (\\w+)");
                    matcher = rtspPattern.matcher(line);
                    if (matcher.find()) {
                        this.sessionId = matcher.group(1);
                    }
                    this.sessionId = line.split(";")[0].split(":")[1].trim();
                }
                if (line.contains("server_port") && (matcher = (rtspPattern = Pattern.compile("server_port=([0-9]+)-([0-9]+)")).matcher(line)).find()) {
                    if (isAudio) {
                        this.audioPorts[0] = Integer.parseInt(matcher.group(1));
                        this.audioPorts[1] = Integer.parseInt(matcher.group(2));
                    } else {
                        this.videoPorts[0] = Integer.parseInt(matcher.group(1));
                        this.videoPorts[1] = Integer.parseInt(matcher.group(2));
                    }
                }
                response = response + line + "\n";
                if (line.length() >= 3) continue;
            }
            if (checkStatus && this.getResponseStatus(response) != 200) {
                this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, " + response);
            }
            Log.i((String)"RtspClient", (String)response);
            return response;
        }
        catch (IOException e) {
            Log.e((String)"RtspClient", (String)"read error", (Throwable)e);
            return null;
        }
    }

    private String sendAnnounceWithAuth(String authResponse) {
        this.authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)this.authorization);
        String body = this.createBody();
        String announce = "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.mCSeq + "\r\nContent-Length: " + body.length() + "\r\nAuthorization: " + this.authorization + "\r\nContent-Type: application/sdp\r\n\r\n" + body;
        Log.i((String)"RtspClient", (String)announce);
        return announce;
    }

    private String createAuth(String authResponse) {
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        if (matcher.find()) {
            Log.i((String)"RtspClient", (String)"using digest auth");
            String realm = matcher.group(1);
            String nonce = matcher.group(2);
            String hash1 = AuthUtil.getMd5Hash(this.user + ":" + realm + ":" + this.password);
            String hash2 = AuthUtil.getMd5Hash("ANNOUNCE:rtsp://" + this.host + ":" + this.port + this.path);
            String hash3 = AuthUtil.getMd5Hash(hash1 + ":" + nonce + ":" + hash2);
            return "Digest username=\"" + this.user + "\",realm=\"" + realm + "\",nonce=\"" + nonce + "\",uri=\"rtsp://" + this.host + ":" + this.port + this.path + "\",response=\"" + hash3 + "\"";
        }
        Log.i((String)"RtspClient", (String)"using basic auth");
        String data = this.user + ":" + this.password;
        String base64Data = Base64.encodeToString((byte[])data.getBytes(), (int)0);
        return "Basic " + base64Data;
    }

    private int getResponseStatus(String response) {
        Matcher matcher = Pattern.compile("RTSP/\\d.\\d (\\d+) (\\w+)", 2).matcher(response);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public int[] getAudioPorts() {
        return this.audioPorts;
    }

    public int[] getVideoPorts() {
        return this.videoPorts;
    }

    public void sendVideo(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.isStreaming()) {
            this.h264Packet.createAndSendPacket(h264Buffer, info);
        }
    }

    public void sendAudio(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.isStreaming()) {
            this.aacPacket.createAndSendPacket(aacBuffer, info);
        }
    }
}

