/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportUdp;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class RtpSocketUdp
extends BaseRtpSocket
implements Runnable {
    private SenderReportUdp senderReportUdp;
    private MulticastSocket mSocket;
    private DatagramPacket[] packets;
    private int port = -1;
    private ConnectCheckerRtsp connectCheckerRtsp;

    public RtpSocketUdp(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.senderReportUdp = new SenderReportUdp(connectCheckerRtsp);
        this.senderReportUdp.reset();
        this.packets = new DatagramPacket[this.bufferCount];
        for (int i = 0; i < this.bufferCount; ++i) {
            this.packets[i] = new DatagramPacket(this.buffers[i], 1);
        }
        try {
            this.mSocket = new MulticastSocket();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.mSocket.close();
        this.senderReportUdp.close();
    }

    @Override
    public void setSSRC(int ssrc) {
        this.setLongSSRC(ssrc);
        this.senderReportUdp.setSSRC(ssrc);
    }

    public void setTimeToLive(int ttl) throws IOException {
        this.mSocket.setTimeToLive(ttl);
    }

    public void setDestination(String dest, int dport, int rtcpPort) {
        try {
            if (dport != 0 && rtcpPort != 0) {
                this.port = dport;
                for (int i = 0; i < this.bufferCount; ++i) {
                    this.packets[i].setPort(dport);
                    this.packets[i].setAddress(InetAddress.getByName(dest));
                }
                this.senderReportUdp.setDestination(InetAddress.getByName(dest), rtcpPort);
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void implementCommitBuffer(int length) {
        this.packets[this.bufferIn].setLength(length);
    }

    @Override
    public void run() {
        try {
            while (this.bufferCommitted.tryAcquire(4L, TimeUnit.SECONDS)) {
                if (!this.running) continue;
                this.senderReportUdp.update(this.packets[this.bufferOut].getLength(), this.timestamps[this.bufferOut], this.port);
                this.mSocket.send(this.packets[this.bufferOut]);
                Log.i((String)"RtpSocket", (String)("send packet, " + this.packets[this.bufferOut].getLength() + " Size, " + this.packets[this.bufferOut].getPort() + " Port"));
                if (++this.bufferOut >= this.bufferCount) {
                    this.bufferOut = 0;
                }
                this.bufferRequested.release();
            }
        }
        catch (IOException | InterruptedException e) {
            Log.e((String)"RtpSocket", (String)"UDP send error: ", (Throwable)e);
            this.connectCheckerRtsp.onConnectionFailedRtsp("Error send packet, " + e.getMessage());
        }
        this.thread = null;
        this.resetFifo();
        this.senderReportUdp.reset();
    }
}

