/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtp.sockets.RtpSocketTcp;
import com.pedro.rtsp.rtp.sockets.RtpSocketUdp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.util.Random;

public abstract class BasePacket {
    protected static final int maxPacketSize = 1272;
    protected BaseRtpSocket socket = null;
    protected byte[] buffer;
    protected long ts;
    protected RtspClient rtspClient;

    public BasePacket(RtspClient rtspClient, Protocol protocol) {
        this.rtspClient = rtspClient;
        this.ts = new Random().nextInt();
        this.socket = protocol == Protocol.UDP ? new RtpSocketUdp(rtspClient.getConnectCheckerRtsp()) : new RtpSocketTcp(rtspClient.getConnectCheckerRtsp());
        this.socket.setSSRC(new Random().nextInt());
        if (this.socket instanceof RtpSocketUdp) {
            try {
                ((RtpSocketUdp)this.socket).setTimeToLive(64);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.socket instanceof RtpSocketUdp) {
            ((RtpSocketUdp)this.socket).close();
        }
    }

    public ConnectCheckerRtsp getConnectCheckerRtsp() {
        return this.rtspClient.getConnectCheckerRtsp();
    }
}

