/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.sockets.RtpSocketTcp;
import com.pedro.rtsp.rtp.sockets.RtpSocketUdp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AacPacket
extends BasePacket {
    private final String TAG = "AacPacket";
    private long oldTs;

    public AacPacket(RtspClient rtspClient, Protocol protocol) {
        super(rtspClient, protocol);
    }

    public void updateDestinationAudio() {
        if (this.socket instanceof RtpSocketUdp) {
            ((RtpSocketUdp)this.socket).setDestination(this.rtspClient.getHost(), this.rtspClient.getAudioPorts()[0], this.rtspClient.getAudioPorts()[1]);
        } else {
            ((RtpSocketTcp)this.socket).setOutputStream(this.rtspClient.getOutputStream(), (byte)0);
        }
    }

    public void setSampleRate(int sampleRate) {
        this.socket.setClockFrequency(sampleRate);
    }

    public void createAndSendPacket(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        try {
            int length;
            this.buffer = this.socket.requestBuffer();
            int n = length = 1256 < bufferInfo.size - byteBuffer.position() ? 1256 : bufferInfo.size - byteBuffer.position();
            if (length > 0) {
                byteBuffer.get(this.buffer, 16, length);
                this.oldTs = this.ts;
                this.ts = bufferInfo.presentationTimeUs * 1000L;
                if (this.oldTs > this.ts) {
                    this.socket.commitBuffer();
                    return;
                }
                this.socket.markNextPacket();
                this.socket.updateTimestamp(this.ts);
                this.buffer[12] = 0;
                this.buffer[13] = 16;
                this.buffer[14] = (byte)(length >> 5);
                this.buffer[15] = (byte)(length << 3);
                this.buffer[15] = (byte)(this.buffer[15] & 0xF8);
                this.buffer[15] = (byte)(this.buffer[15] | 0);
                this.socket.commitBuffer(12 + length + 4);
            } else {
                this.socket.commitBuffer();
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.getConnectCheckerRtsp().onConnectionFailedRtsp(e.getMessage());
        }
    }
}

