/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.rtmp.flv.BasePacket;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.flv.audio.packet.AacPacket;
import com.pedro.rtmp.flv.audio.packet.G711Packet;
import com.pedro.rtmp.flv.video.packet.Av1Packet;
import com.pedro.rtmp.flv.video.packet.H264Packet;
import com.pedro.rtmp.flv.video.packet.H265Packet;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.RtmpSender;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0012\u0018\u0000 N2\u00020\u0001:\u0001NB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010+2\b\u0010-\u001a\u0004\u0018\u00010+J\u0016\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\fJ\u0016\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020+2\u0006\u00103\u001a\u000204J\u0006\u00107\u001a\u00020)J\u0018\u00108\u001a\u00020)2\b\b\u0002\u00109\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\f2\b\b\u0002\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u000eJ\u0006\u0010@\u001a\u00020\u000eJ\u0006\u0010A\u001a\u00020\u000eJ\u0006\u0010B\u001a\u00020)J\u0006\u0010C\u001a\u00020\u0017J\u0006\u0010D\u001a\u00020\u0017J\u0006\u0010E\u001a\u00020)J\u0006\u0010F\u001a\u00020)J\u0006\u0010G\u001a\u00020)J\u0006\u0010H\u001a\u00020)J\u000e\u0010I\u001a\u00020)2\u0006\u0010J\u001a\u00020\fJ\u000e\u0010K\u001a\u00020)2\u0006\u0010L\u001a\u00020=J\u0006\u0010M\u001a\u00020=R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpSender;", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "commandsManager", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "<init>", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/rtmp/rtmp/CommandsManager;)V", "audioPacket", "Lcom/pedro/rtmp/flv/BasePacket;", "videoPacket", "running", "", "cacheSize", "", "job", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/rtmp/flv/FlvPacket;", "audioFramesSent", "", "videoFramesSent", "socket", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "getSocket", "()Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "setSocket", "(Lcom/pedro/rtmp/utils/socket/RtmpSocket;)V", "value", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "bitrateManager", "Lcom/pedro/common/BitrateManager;", "isEnableLogs", "setVideoInfo", "", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "setAudioInfo", "sampleRate", "isStereo", "sendVideoFrame", "h264Buffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendAudioFrame", "aacBuffer", "start", "stop", "clear", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasCongestion", "percentUsed", "", "resizeCache", "newSize", "getCacheSize", "getItemsInCache", "clearCache", "getSentAudioFrames", "getSentVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setLogs", "enable", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "Companion", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nRtmpSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtmpSender.kt\ncom/pedro/rtmp/rtmp/RtmpSender\n+ 2 Extensions.kt\ncom/pedro/common/ExtensionsKt\n*L\n1#1,269:1\n66#2,5:270\n66#2,5:275\n*S KotlinDebug\n*F\n+ 1 RtmpSender.kt\ncom/pedro/rtmp/rtmp/RtmpSender\n*L\n120#1:270,5\n132#1:275,5\n*E\n"})
public final class RtmpSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final CommandsManager commandsManager;
    @NotNull
    private BasePacket audioPacket;
    @NotNull
    private BasePacket videoPacket;
    private volatile boolean running;
    private int cacheSize;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private volatile BlockingQueue<FlvPacket> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    @Nullable
    private RtmpSocket socket;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "RtmpSender";

    public RtmpSender(@NotNull ConnectChecker connectChecker, @NotNull CommandsManager commandsManager) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)commandsManager, (String)"commandsManager");
        this.connectChecker = connectChecker;
        this.commandsManager = commandsManager;
        this.audioPacket = new AacPacket();
        this.videoPacket = new H264Packet();
        this.cacheSize = 200;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.bitrateManager = new BitrateManager((BitrateChecker)this.connectChecker);
        this.isEnableLogs = true;
    }

    @Nullable
    public final RtmpSocket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable RtmpSocket rtmpSocket) {
        this.socket = rtmpSocket;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        switch (WhenMappings.$EnumSwitchMapping$0[this.commandsManager.getVideoCodec().ordinal()]) {
            case 1: {
                if (vps == null || pps == null) {
                    throw new IllegalArgumentException("pps or vps can't be null with h265");
                }
                BasePacket basePacket = this.videoPacket = (BasePacket)new H265Packet();
                Intrinsics.checkNotNull((Object)basePacket, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.H265Packet");
                ((H265Packet)basePacket).sendVideoInfo(sps, pps, vps);
                break;
            }
            case 2: {
                BasePacket basePacket = this.videoPacket = (BasePacket)new Av1Packet();
                Intrinsics.checkNotNull((Object)basePacket, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.Av1Packet");
                ((Av1Packet)basePacket).sendVideoInfo(sps);
                break;
            }
            default: {
                if (pps == null) {
                    throw new IllegalArgumentException("pps can't be null with h264");
                }
                BasePacket basePacket = this.videoPacket = (BasePacket)new H264Packet();
                Intrinsics.checkNotNull((Object)basePacket, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.video.packet.H264Packet");
                ((H264Packet)basePacket).sendVideoInfo(sps, pps);
            }
        }
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        switch (WhenMappings.$EnumSwitchMapping$1[this.commandsManager.getAudioCodec().ordinal()]) {
            case 1: {
                BasePacket basePacket = this.audioPacket = (BasePacket)new G711Packet();
                Intrinsics.checkNotNull((Object)basePacket, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.audio.packet.G711Packet");
                G711Packet.sendAudioInfo$default((G711Packet)basePacket, null, 1, null);
                break;
            }
            case 2: {
                BasePacket basePacket = this.audioPacket = (BasePacket)new AacPacket();
                Intrinsics.checkNotNull((Object)basePacket, (String)"null cannot be cast to non-null type com.pedro.rtmp.flv.audio.packet.AacPacket");
                AacPacket.sendAudioInfo$default((AacPacket)basePacket, sampleRate, isStereo, null, 4, null);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Unsupported codec: " + this.commandsManager.getAudioCodec().name());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.videoPacket.createFlvPacket(h264Buffer, info, (Function1<? super FlvPacket, Unit>)((Function1)arg_0 -> RtmpSender.sendVideoFrame$lambda$0(this, arg_0)));
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.running) {
            this.audioPacket.createFlvPacket(aacBuffer, info, (Function1<? super FlvPacket, Unit>)((Function1)arg_0 -> RtmpSender.sendAudioFrame$lambda$1(this, arg_0)));
        }
    }

    public final void start() {
        this.bitrateManager.reset();
        this.queue.clear();
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RtmpSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CASE], 4[SWITCH]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FlvPacket invokeSuspend$lambda$3$lambda$0(RtmpSender this$0) {
                return (FlvPacket)RtmpSender.access$getQueue$p(this$0).poll(1L, TimeUnit.SECONDS);
            }

            private static final Unit invokeSuspend$lambda$4(RtmpSender this$0, Throwable $error) {
                RtmpSender.access$getConnectChecker$p(this$0).onConnectionFailed("Error send packet, " + $error.getMessage());
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(boolean var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof stop.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RtmpSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop(false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                this.audioPacket.reset(clear != false);
                this.videoPacket.reset(clear != false);
                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v0 = this.job;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = JobKt.cancelAndJoin((Job)v0, (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                break;
            }
            case 1: {
                this = (RtmpSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object stop$default(RtmpSender rtmpSender, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return rtmpSender.stop(bl, (Continuation<? super Unit>)continuation);
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(RtmpSender rtmpSender, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return rtmpSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public final void setBitrateExponentialFactor(float factor) {
        this.bitrateManager.setExponentialFactor(factor);
    }

    public final float getBitrateExponentialFactor() {
        return this.bitrateManager.getExponentialFactor();
    }

    private static final Unit sendVideoFrame$lambda$0(RtmpSender this$0, FlvPacket flvPacket) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        BlockingQueue<FlvPacket> $this$trySend$iv = this$0.queue;
        boolean $i$f$trySend = false;
        try {
            $this$trySend$iv.add(flvPacket);
            bl = true;
        }
        catch (IllegalStateException e$iv) {
            bl = false;
        }
        boolean result = bl;
        if (!result) {
            Log.i((String)TAG, (String)"Video frame discarded");
            long l = this$0.droppedVideoFrames;
            this$0.droppedVideoFrames = l + 1L;
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendAudioFrame$lambda$1(RtmpSender this$0, FlvPacket flvPacket) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        BlockingQueue<FlvPacket> $this$trySend$iv = this$0.queue;
        boolean $i$f$trySend = false;
        try {
            $this$trySend$iv.add(flvPacket);
            bl = true;
        }
        catch (IllegalStateException e$iv) {
            bl = false;
        }
        boolean result = bl;
        if (!result) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            long l = this$0.droppedAudioFrames;
            this$0.droppedAudioFrames = l + 1L;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(RtmpSender $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getRunning$p(RtmpSender $this) {
        return $this.running;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(RtmpSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(RtmpSender $this) {
        return $this.queue;
    }

    public static final /* synthetic */ CommandsManager access$getCommandsManager$p(RtmpSender $this) {
        return $this.commandsManager;
    }

    public static final /* synthetic */ boolean access$isEnableLogs$p(RtmpSender $this) {
        return $this.isEnableLogs;
    }

    public static final /* synthetic */ long access$getVideoFramesSent$p(RtmpSender $this) {
        return $this.videoFramesSent;
    }

    public static final /* synthetic */ void access$setVideoFramesSent$p(RtmpSender $this, long l) {
        $this.videoFramesSent = l;
    }

    public static final /* synthetic */ long access$getAudioFramesSent$p(RtmpSender $this) {
        return $this.audioFramesSent;
    }

    public static final /* synthetic */ void access$setAudioFramesSent$p(RtmpSender $this, long l) {
        $this.audioFramesSent = l;
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(RtmpSender $this) {
        return $this.connectChecker;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpSender$Companion;", "", "<init>", "()V", "TAG", "", "rtmp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H265.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

