/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.rtmp.amf.v0.AmfEcmaArray;
import com.pedro.rtmp.amf.v0.AmfNull;
import com.pedro.rtmp.amf.v0.AmfObject;
import com.pedro.rtmp.amf.v0.AmfStrictArray;
import com.pedro.rtmp.amf.v0.AmfString;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.command.CommandAmf0;
import com.pedro.rtmp.rtmp.message.data.DataAmf0;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/pedro/rtmp/rtmp/CommandsManagerAmf0;", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "()V", "createStream", "", "output", "Ljava/io/OutputStream;", "sendClose", "sendConnect", "auth", "", "sendMetadata", "sendPublish", "rtmp_release"})
public final class CommandsManagerAmf0
extends CommandsManager {
    @Override
    public void sendConnect(@NotNull String auth, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 connect2 = new CommandAmf0("connect", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        AmfObject connectInfo = new AmfObject(null, 1, null);
        connectInfo.setProperty("app", this.getAppName() + auth);
        connectInfo.setProperty("flashVer", this.getFlashVersion());
        connectInfo.setProperty("tcUrl", this.getTcUrl() + auth);
        if (!this.getVideoDisabled()) {
            if (this.getVideoCodec() == VideoCodec.H265) {
                List list = new ArrayList();
                list.add(new AmfString("hvc1"));
                AmfStrictArray array = new AmfStrictArray(list);
                connectInfo.setProperty("fourCcList", array);
            } else if (this.getVideoCodec() == VideoCodec.AV1) {
                List list = new ArrayList();
                list.add(new AmfString("av01"));
                AmfStrictArray array = new AmfStrictArray(list);
                connectInfo.setProperty("fourCcList", array);
            }
        }
        connectInfo.setProperty("objectEncoding", 0.0);
        connect2.addData(connectInfo);
        connect2.writeHeader(output);
        connect2.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "connect");
        Log.i((String)this.getTAG(), (String)("send " + connect2));
    }

    @Override
    public void createStream(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 releaseStream = new CommandAmf0("releaseStream", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        releaseStream.addData(new AmfNull());
        releaseStream.addData(new AmfString(this.getStreamName()));
        releaseStream.writeHeader(output);
        releaseStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "releaseStream");
        Log.i((String)this.getTAG(), (String)("send " + releaseStream));
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 fcPublish = new CommandAmf0("FCPublish", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        fcPublish.addData(new AmfNull());
        fcPublish.addData(new AmfString(this.getStreamName()));
        fcPublish.writeHeader(output);
        fcPublish.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "FCPublish");
        Log.i((String)this.getTAG(), (String)("send " + fcPublish));
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 createStream2 = new CommandAmf0("createStream", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        createStream2.addData(new AmfNull());
        createStream2.writeHeader(output);
        createStream2.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "createStream");
        Log.i((String)this.getTAG(), (String)("send " + createStream2));
    }

    @Override
    public void sendMetadata(@NotNull OutputStream output) {
        int codecValue;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "@setDataFrame";
        DataAmf0 metadata = new DataAmf0(name, this.getCurrentTimestamp(), this.getStreamId(), null, 8, null);
        metadata.addData(new AmfString("onMetaData"));
        AmfEcmaArray amfEcmaArray = new AmfEcmaArray(null, 1, null);
        amfEcmaArray.setProperty("duration", 0.0);
        if (!this.getVideoDisabled()) {
            amfEcmaArray.setProperty("width", this.getWidth());
            amfEcmaArray.setProperty("height", this.getHeight());
            codecValue = switch (WhenMappings.$EnumSwitchMapping$0[this.getVideoCodec().ordinal()]) {
                case 1 -> VideoFormat.AVC.getValue();
                case 2 -> VideoFormat.HEVC.getValue();
                case 3 -> VideoFormat.AV1.getValue();
                default -> throw new NoWhenBranchMatchedException();
            };
            amfEcmaArray.setProperty("videocodecid", codecValue);
            amfEcmaArray.setProperty("framerate", this.getFps());
            amfEcmaArray.setProperty("videodatarate", 0.0);
        }
        if (!this.getAudioDisabled()) {
            codecValue = switch (WhenMappings.$EnumSwitchMapping$1[this.getAudioCodec().ordinal()]) {
                case 1 -> AudioFormat.G711_A.getValue();
                case 2 -> AudioFormat.AAC.getValue();
                case 3 -> throw new IllegalArgumentException("Unsupported codec: " + this.getAudioCodec().name());
                default -> throw new NoWhenBranchMatchedException();
            };
            amfEcmaArray.setProperty("audiocodecid", codecValue);
            amfEcmaArray.setProperty("audiosamplerate", this.getSampleRate());
            amfEcmaArray.setProperty("audiosamplesize", 16.0);
            amfEcmaArray.setProperty("audiodatarate", 0.0);
            amfEcmaArray.setProperty("stereo", this.isStereo());
        }
        amfEcmaArray.setProperty("filesize", 0.0);
        metadata.addData(amfEcmaArray);
        metadata.writeHeader(output);
        metadata.writeBody(output);
        Log.i((String)this.getTAG(), (String)("send " + metadata));
    }

    @Override
    public void sendPublish(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "publish";
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 publish = new CommandAmf0(name, this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        publish.addData(new AmfNull());
        publish.addData(new AmfString(this.getStreamName()));
        publish.addData(new AmfString("live"));
        publish.writeHeader(output);
        publish.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), name);
        Log.i((String)this.getTAG(), (String)("send " + publish));
    }

    @Override
    public void sendClose(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "closeStream";
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf0 closeStream = new CommandAmf0(name, this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        closeStream.addData(new AmfNull());
        closeStream.writeHeader(output);
        closeStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), name);
        Log.i((String)this.getTAG(), (String)("send " + closeStream));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

