/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.util.Log;
import com.pedro.common.VideoCodec;
import com.pedro.rtmp.amf.v3.Amf3Array;
import com.pedro.rtmp.amf.v3.Amf3Dictionary;
import com.pedro.rtmp.amf.v3.Amf3Null;
import com.pedro.rtmp.amf.v3.Amf3Object;
import com.pedro.rtmp.amf.v3.Amf3String;
import com.pedro.rtmp.flv.audio.AudioFormat;
import com.pedro.rtmp.flv.video.VideoFormat;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.command.CommandAmf3;
import com.pedro.rtmp.rtmp.message.data.DataAmf3;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/pedro/rtmp/rtmp/CommandsManagerAmf3;", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "()V", "createStream", "", "output", "Ljava/io/OutputStream;", "sendClose", "sendConnect", "auth", "", "sendMetadata", "sendPublish", "rtmp_release"})
public final class CommandsManagerAmf3
extends CommandsManager {
    @Override
    public void sendConnect(@NotNull String auth, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf3 connect2 = new CommandAmf3("connect", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        Amf3Object connectInfo = new Amf3Object(null, 1, null);
        connectInfo.setProperty("app", this.getAppName() + auth);
        connectInfo.setProperty("flashVer", "FMLE/3.0 (compatible; Lavf57.56.101)");
        connectInfo.setProperty("tcUrl", this.getTcUrl() + auth);
        if (!this.getVideoDisabled()) {
            if (this.getVideoCodec() == VideoCodec.H265) {
                List list = new ArrayList();
                list.add(new Amf3String("hvc1"));
                Amf3Array array = new Amf3Array(list);
                connectInfo.setProperty("fourCcList", array);
            } else if (this.getVideoCodec() == VideoCodec.AV1) {
                List list = new ArrayList();
                list.add(new Amf3String("av01"));
                Amf3Array array = new Amf3Array(list);
                connectInfo.setProperty("fourCcList", array);
            }
        }
        connectInfo.setProperty("objectEncoding", 3.0);
        connect2.addData(connectInfo);
        connect2.writeHeader(output);
        connect2.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "connect");
        Log.i((String)this.getTAG(), (String)("send " + connect2));
    }

    @Override
    public void createStream(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf3 releaseStream = new CommandAmf3("releaseStream", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        releaseStream.addData(new Amf3Null());
        releaseStream.addData(new Amf3String(this.getStreamName()));
        releaseStream.writeHeader(output);
        releaseStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "releaseStream");
        Log.i((String)this.getTAG(), (String)("send " + releaseStream));
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf3 fcPublish = new CommandAmf3("FCPublish", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        fcPublish.addData(new Amf3Null());
        fcPublish.addData(new Amf3String(this.getStreamName()));
        fcPublish.writeHeader(output);
        fcPublish.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "FCPublish");
        Log.i((String)this.getTAG(), (String)("send " + fcPublish));
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf3 createStream2 = new CommandAmf3("createStream", this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark()));
        createStream2.addData(new Amf3Null());
        createStream2.writeHeader(output);
        createStream2.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), "createStream");
        Log.i((String)this.getTAG(), (String)("send " + createStream2));
    }

    @Override
    public void sendMetadata(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "@setDataFrame";
        DataAmf3 metadata = new DataAmf3(name, this.getCurrentTimestamp(), this.getStreamId(), null, 8, null);
        metadata.addData(new Amf3String("onMetaData"));
        Amf3Dictionary amfEcmaArray = new Amf3Dictionary(null, 1, null);
        amfEcmaArray.setProperty("duration", 0.0);
        if (!this.getVideoDisabled()) {
            amfEcmaArray.setProperty("width", this.getWidth());
            amfEcmaArray.setProperty("height", this.getHeight());
            amfEcmaArray.setProperty("videocodecid", VideoFormat.AVC.getValue());
            amfEcmaArray.setProperty("framerate", this.getFps());
            amfEcmaArray.setProperty("videodatarate", 0.0);
        }
        if (!this.getAudioDisabled()) {
            amfEcmaArray.setProperty("audiocodecid", AudioFormat.AAC.getValue());
            amfEcmaArray.setProperty("audiosamplerate", this.getSampleRate());
            amfEcmaArray.setProperty("audiosamplesize", 16.0);
            amfEcmaArray.setProperty("audiodatarate", 0.0);
            amfEcmaArray.setProperty("stereo", this.isStereo());
        }
        amfEcmaArray.setProperty("filesize", 0.0);
        metadata.addData(amfEcmaArray);
        metadata.writeHeader(output);
        metadata.writeBody(output);
        Log.i((String)this.getTAG(), (String)("send " + metadata));
    }

    @Override
    public void sendPublish(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "publish";
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf3 publish = new CommandAmf3(name, this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        publish.addData(new Amf3Null());
        publish.addData(new Amf3String(this.getStreamName()));
        publish.addData(new Amf3String("live"));
        publish.writeHeader(output);
        publish.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), name);
        Log.i((String)this.getTAG(), (String)("send " + publish));
    }

    @Override
    public void sendClose(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String name = "closeStream";
        this.setCommandId(this.getCommandId() + 1);
        CommandAmf3 closeStream = new CommandAmf3(name, this.getCommandId(), this.getCurrentTimestamp(), this.getStreamId(), new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_STREAM.getMark()));
        closeStream.addData(new Amf3Null());
        closeStream.writeHeader(output);
        closeStream.writeBody(output);
        this.getSessionHistory().setPacket(this.getCommandId(), name);
        Log.i((String)this.getTAG(), (String)("send " + closeStream));
    }
}

