/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.utils;

import com.pedro.rtmp.utils.UtilsKt;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/pedro/rtmp/utils/BitBuffer;", "", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "bitRemaining", "", "getBitRemaining", "()I", "getBuffer", "()Ljava/nio/ByteBuffer;", "bufferEnd", "bufferPosition", "hasRemaining", "", "getHasRemaining", "()Z", "remaining", "getRemaining", "get", "", "i", "getBool", "getInt", "getLong", "", "getShort", "", "readUE", "Companion", "rtmp_release"})
public final class BitBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    private int bufferPosition;
    private final int bufferEnd;

    public BitBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.bufferPosition = this.buffer.position() * 8;
        this.bufferEnd = this.buffer.limit() * 8;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final boolean getHasRemaining() {
        return this.getBitRemaining() > 0;
    }

    public final int getBitRemaining() {
        return this.bufferEnd - this.bufferPosition + 1;
    }

    public final int getRemaining() {
        return (int)Math.ceil((double)this.getBitRemaining() / (double)8);
    }

    public final boolean getBool() {
        return this.getInt(1) == 1;
    }

    public final byte get(int i) {
        return (byte)this.getLong(i);
    }

    public final short getShort(int i) {
        return (short)this.getLong(i);
    }

    public final int getInt(int i) {
        return (int)this.getLong(i);
    }

    public final long getLong(int i) {
        if (!this.getHasRemaining()) {
            throw new IllegalStateException("No more bits to read");
        }
        int b = this.buffer.get(this.bufferPosition / 8);
        int v = b < 0 ? b + 256 : b;
        int left = 8 - this.bufferPosition % 8;
        long rc = 0L;
        if (i <= left) {
            rc = (v << this.bufferPosition % 8 & 0xFF) >> this.bufferPosition % 8 + (left - i);
            this.bufferPosition += i;
        } else {
            int then = i - left;
            rc = this.getLong(left);
            rc <<= then;
            rc += this.getLong(then);
        }
        this.buffer.position((int)Math.ceil((double)this.bufferPosition / (double)8));
        return rc;
    }

    public final int readUE() {
        int leadingZeroBits = 0;
        while (!this.getBool()) {
            ++leadingZeroBits;
        }
        return leadingZeroBits > 0 ? (1 << leadingZeroBits) - 1 + this.getInt(leadingZeroBits) : 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/pedro/rtmp/utils/BitBuffer$Companion;", "", "()V", "extractRbsp", "Ljava/nio/ByteBuffer;", "buffer", "headerLength", "", "rtmp_release"})
    @SourceDebugExtension(value={"SMAP\nBitBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitBuffer.kt\ncom/pedro/rtmp/utils/BitBuffer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1855#2,2:107\n*S KotlinDebug\n*F\n+ 1 BitBuffer.kt\ncom/pedro/rtmp/utils/BitBuffer$Companion\n*L\n95#1:107,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteBuffer extractRbsp(@NotNull ByteBuffer buffer, int headerLength) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            ByteBuffer rbsp = ByteBuffer.allocateDirect(buffer.remaining());
            byte[] byArray = new byte[]{0, 0, 3};
            List<Integer> indices = UtilsKt.indicesOf(buffer, byArray);
            Intrinsics.checkNotNull((Object)rbsp);
            UtilsKt.put(rbsp, buffer, 0, headerLength);
            int previous = 0;
            previous = buffer.position();
            Iterable $this$forEach$iv = indices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                UtilsKt.put(rbsp, buffer, previous, it + 2 - previous);
                previous = it + 3;
            }
            UtilsKt.put(rbsp, buffer, previous, buffer.limit() - previous);
            rbsp.limit(rbsp.position());
            rbsp.rewind();
            return rbsp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

