/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message.command;

import com.pedro.rtmp.amf.v3.Amf3Data;
import com.pedro.rtmp.amf.v3.Amf3Double;
import com.pedro.rtmp.amf.v3.Amf3Object;
import com.pedro.rtmp.amf.v3.Amf3String;
import com.pedro.rtmp.rtmp.chunk.ChunkStreamId;
import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.command.Command;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pedro/rtmp/rtmp/message/command/CommandAmf3;", "Lcom/pedro/rtmp/rtmp/message/command/Command;", "name", "", "commandId", "", "timestamp", "streamId", "basicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "(Ljava/lang/String;IIILcom/pedro/rtmp/rtmp/message/BasicHeader;)V", "data", "", "Lcom/pedro/rtmp/amf/v3/Amf3Data;", "addData", "", "amf3Data", "getCode", "getDescription", "getStreamId", "getType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "readBody", "input", "Ljava/io/InputStream;", "storeBody", "", "toString", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nCommandAmf3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAmf3.kt\ncom/pedro/rtmp/rtmp/message/command/CommandAmf3\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1855#2,2:100\n*S KotlinDebug\n*F\n+ 1 CommandAmf3.kt\ncom/pedro/rtmp/rtmp/message/command/CommandAmf3\n*L\n87#1:100,2\n*E\n"})
public final class CommandAmf3
extends Command {
    private final int timestamp;
    private final int streamId;
    @NotNull
    private final List<Amf3Data> data;

    public CommandAmf3(@NotNull String name, int commandId, int timestamp, int streamId, @NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        super(name, commandId, timestamp, streamId, basicHeader);
        this.timestamp = timestamp;
        this.streamId = streamId;
        this.data = new ArrayList();
        Amf3String amf3String = new Amf3String(name);
        this.data.add(amf3String);
        this.setBodySize(this.getBodySize() + (amf3String.getSize() + 1));
        Amf3Double amf3Double = new Amf3Double(commandId);
        this.setBodySize(this.getBodySize() + (amf3Double.getSize() + 1));
        this.data.add(amf3Double);
    }

    public /* synthetic */ CommandAmf3(String string, int n, int n2, int n3, BasicHeader basicHeader, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "";
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x10) != 0) {
            basicHeader = new BasicHeader(ChunkType.TYPE_0, ChunkStreamId.OVER_CONNECTION.getMark());
        }
        this(string, n, n2, n3, basicHeader);
    }

    public final void addData(@NotNull Amf3Data amf3Data) {
        Intrinsics.checkNotNullParameter((Object)amf3Data, (String)"amf3Data");
        this.data.add(amf3Data);
        this.setBodySize(this.getBodySize() + (amf3Data.getSize() + 1));
        this.getHeader().setMessageLength(this.getBodySize());
    }

    @Override
    public int getStreamId() {
        Amf3Data amf3Data = this.data.get(3);
        Intrinsics.checkNotNull((Object)amf3Data, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3Double");
        return (int)((Amf3Double)amf3Data).getValue();
    }

    @Override
    @NotNull
    public String getDescription() {
        Amf3Data amf3Data = this.data.get(3);
        Intrinsics.checkNotNull((Object)amf3Data, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3Object");
        Amf3Data amf3Data2 = ((Amf3Object)amf3Data).getProperty("description");
        Intrinsics.checkNotNull((Object)amf3Data2, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3String");
        return ((Amf3String)amf3Data2).getValue();
    }

    @Override
    @NotNull
    public String getCode() {
        Amf3Data amf3Data = this.data.get(3);
        Intrinsics.checkNotNull((Object)amf3Data, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3Object");
        Amf3Data amf3Data2 = ((Amf3Object)amf3Data).getProperty("code");
        Intrinsics.checkNotNull((Object)amf3Data2, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3String");
        return ((Amf3String)amf3Data2).getValue();
    }

    @Override
    public void readBody(@NotNull InputStream input) {
        int bytesRead;
        Amf3Data amf3Data;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.data.clear();
        for (bytesRead = 0; bytesRead < this.getHeader().getMessageLength(); bytesRead += amf3Data.getSize() + 1) {
            amf3Data = Amf3Data.Companion.getAmf3Data(input);
            this.data.add(amf3Data);
        }
        if (!((Collection)this.data).isEmpty()) {
            if (this.data.get(0) instanceof Amf3String) {
                Amf3Data amf3Data2 = this.data.get(0);
                Intrinsics.checkNotNull((Object)amf3Data2, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3String");
                this.setName(((Amf3String)amf3Data2).getValue());
            }
            if (this.data.size() >= 2 && this.data.get(1) instanceof Amf3Double) {
                Amf3Data amf3Data3 = this.data.get(1);
                Intrinsics.checkNotNull((Object)amf3Data3, (String)"null cannot be cast to non-null type com.pedro.rtmp.amf.v3.Amf3Double");
                this.setCommandId((int)((Amf3Double)amf3Data3).getValue());
            }
        }
        this.setBodySize(bytesRead);
        this.getHeader().setMessageLength(this.getBodySize());
    }

    @Override
    @NotNull
    public byte[] storeBody() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterable $this$forEach$iv = this.data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Amf3Data it = (Amf3Data)element$iv;
            boolean bl = false;
            it.writeHeader(byteArrayOutputStream);
            it.writeBody(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.COMMAND_AMF3;
    }

    @NotNull
    public String toString() {
        return "Command(name='" + this.getName() + "', transactionId=" + this.getCommandId() + ", timeStamp=" + this.timestamp + ", streamId=" + this.streamId + ", data=" + this.data + ", bodySize=" + this.getBodySize() + ")";
    }

    public CommandAmf3() {
        this(null, 0, 0, 0, null, 31, null);
    }
}

