/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.util.Log;
import com.pedro.rtmp.flv.FlvPacket;
import com.pedro.rtmp.rtmp.message.Audio;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.Video;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.control.Event;
import com.pedro.rtmp.rtmp.message.control.Type;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.utils.CommandSessionHistory;
import com.pedro.rtmp.utils.RtmpConfig;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u0010\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020YH&J\b\u0010Z\u001a\u00020\u0015H\u0004J\u000e\u0010[\u001a\u00020\\2\u0006\u0010V\u001a\u00020WJ\u0006\u0010]\u001a\u00020UJ\u0016\u0010^\u001a\u00020\u00152\u0006\u0010_\u001a\u00020`2\u0006\u0010V\u001a\u00020WJ\u000e\u0010a\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u000e\u0010b\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u0010\u0010b\u001a\u00020U2\u0006\u0010X\u001a\u00020YH&J\u0016\u0010c\u001a\u00020U2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010V\u001a\u00020WJ\u0018\u0010c\u001a\u00020U2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010X\u001a\u00020YH&J\u000e\u0010e\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u0010\u0010e\u001a\u00020U2\u0006\u0010X\u001a\u00020YH&J\u0016\u0010f\u001a\u00020U2\u0006\u0010g\u001a\u00020h2\u0006\u0010V\u001a\u00020WJ\u000e\u0010i\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u0010\u0010i\u001a\u00020U2\u0006\u0010X\u001a\u00020YH&J\u0016\u0010j\u001a\u00020\u00152\u0006\u0010_\u001a\u00020`2\u0006\u0010V\u001a\u00020WJ\u000e\u0010k\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ\u0016\u0010l\u001a\u00020U2\u0006\u00101\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\bJ\u001a\u0010m\u001a\u00020U2\b\u0010J\u001a\u0004\u0018\u00010\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0016\u0010n\u001a\u00020U2\u0006\u0010P\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\u0010R\u001a\u0010#\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\fR\u001a\u0010%\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fR\u001c\u0010(\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0006\"\u0004\b*\u0010\u0010R\u001a\u0010+\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010\u0019R\u001a\u0010.\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010\u0019R\u001a\u00101\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0017\"\u0004\b3\u0010\u0019R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0017\"\u0004\b@\u0010\u0019R\u001a\u0010A\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0006\"\u0004\bC\u0010\u0010R\u001a\u0010D\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0006\"\u0004\bF\u0010\u0010R\u001a\u0010G\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0017\"\u0004\bI\u0010\u0019R\u001c\u0010J\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0006\"\u0004\bL\u0010\u0010R\u001a\u0010M\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\n\"\u0004\bO\u0010\fR\u001a\u0010P\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u0017\"\u0004\bR\u0010\u0019R\u000e\u0010S\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/pedro/rtmp/rtmp/CommandsManager;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "akamaiTs", "", "getAkamaiTs", "()Z", "setAkamaiTs", "(Z)V", "appName", "getAppName", "setAppName", "(Ljava/lang/String;)V", "audioDisabled", "getAudioDisabled", "setAudioDisabled", "commandId", "", "getCommandId", "()I", "setCommandId", "(I)V", "fps", "getFps", "setFps", "height", "getHeight", "setHeight", "host", "getHost", "setHost", "isStereo", "setStereo", "onAuth", "getOnAuth", "setOnAuth", "password", "getPassword", "setPassword", "port", "getPort", "setPort", "readChunkSize", "getReadChunkSize", "setReadChunkSize", "sampleRate", "getSampleRate", "setSampleRate", "sessionHistory", "Lcom/pedro/rtmp/utils/CommandSessionHistory;", "getSessionHistory", "()Lcom/pedro/rtmp/utils/CommandSessionHistory;", "startTs", "", "getStartTs", "()J", "setStartTs", "(J)V", "streamId", "getStreamId", "setStreamId", "streamName", "getStreamName", "setStreamName", "tcUrl", "getTcUrl", "setTcUrl", "timestamp", "getTimestamp", "setTimestamp", "user", "getUser", "setUser", "videoDisabled", "getVideoDisabled", "setVideoDisabled", "width", "getWidth", "setWidth", "writeSync", "createStream", "", "socket", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "output", "Ljava/io/OutputStream;", "getCurrentTimestamp", "readMessageResponse", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "reset", "sendAudioPacket", "flvPacket", "Lcom/pedro/rtmp/flv/FlvPacket;", "sendChunkSize", "sendClose", "sendConnect", "auth", "sendMetadata", "sendPong", "event", "Lcom/pedro/rtmp/rtmp/message/control/Event;", "sendPublish", "sendVideoPacket", "sendWindowAcknowledgementSize", "setAudioInfo", "setAuth", "setVideoResolution", "rtmp_release"})
public abstract class CommandsManager {
    @NotNull
    private final String TAG;
    @NotNull
    private final CommandSessionHistory sessionHistory = new CommandSessionHistory(null, null, 3, null);
    private int timestamp;
    private int commandId;
    private int streamId;
    @NotNull
    private String host = "";
    private int port = 1935;
    @NotNull
    private String appName = "";
    @NotNull
    private String streamName = "";
    @NotNull
    private String tcUrl = "";
    @Nullable
    private String user;
    @Nullable
    private String password;
    private boolean onAuth;
    private boolean akamaiTs;
    private long startTs;
    private int readChunkSize = 128;
    private boolean audioDisabled;
    private boolean videoDisabled;
    private int width = 640;
    private int height = 480;
    private int fps = 30;
    private int sampleRate = 44100;
    private boolean isStereo = true;
    @NotNull
    private final Object writeSync = new Object();

    public CommandsManager() {
        this.TAG = "CommandsManager";
    }

    @NotNull
    protected final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final CommandSessionHistory getSessionHistory() {
        return this.sessionHistory;
    }

    public final int getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(int n) {
        this.timestamp = n;
    }

    protected final int getCommandId() {
        return this.commandId;
    }

    protected final void setCommandId(int n) {
        this.commandId = n;
    }

    public final int getStreamId() {
        return this.streamId;
    }

    public final void setStreamId(int n) {
        this.streamId = n;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getAppName() {
        return this.appName;
    }

    public final void setAppName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.appName = string;
    }

    @NotNull
    public final String getStreamName() {
        return this.streamName;
    }

    public final void setStreamName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.streamName = string;
    }

    @NotNull
    public final String getTcUrl() {
        return this.tcUrl;
    }

    public final void setTcUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tcUrl = string;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@Nullable String string) {
        this.user = string;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@Nullable String string) {
        this.password = string;
    }

    public final boolean getOnAuth() {
        return this.onAuth;
    }

    public final void setOnAuth(boolean bl) {
        this.onAuth = bl;
    }

    public final boolean getAkamaiTs() {
        return this.akamaiTs;
    }

    public final void setAkamaiTs(boolean bl) {
        this.akamaiTs = bl;
    }

    public final long getStartTs() {
        return this.startTs;
    }

    public final void setStartTs(long l) {
        this.startTs = l;
    }

    public final int getReadChunkSize() {
        return this.readChunkSize;
    }

    public final void setReadChunkSize(int n) {
        this.readChunkSize = n;
    }

    public final boolean getAudioDisabled() {
        return this.audioDisabled;
    }

    public final void setAudioDisabled(boolean bl) {
        this.audioDisabled = bl;
    }

    public final boolean getVideoDisabled() {
        return this.videoDisabled;
    }

    public final void setVideoDisabled(boolean bl) {
        this.videoDisabled = bl;
    }

    protected final int getWidth() {
        return this.width;
    }

    protected final void setWidth(int n) {
        this.width = n;
    }

    protected final int getHeight() {
        return this.height;
    }

    protected final void setHeight(int n) {
        this.height = n;
    }

    public final int getFps() {
        return this.fps;
    }

    public final void setFps(int n) {
        this.fps = n;
    }

    protected final int getSampleRate() {
        return this.sampleRate;
    }

    protected final void setSampleRate(int n) {
        this.sampleRate = n;
    }

    protected final boolean isStereo() {
        return this.isStereo;
    }

    protected final void setStereo(boolean bl) {
        this.isStereo = bl;
    }

    public final void setVideoResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.sampleRate = sampleRate;
        this.isStereo = isStereo;
    }

    public final void setAuth(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    protected final int getCurrentTimestamp() {
        return (int)(System.currentTimeMillis() / (long)1000 - (long)this.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendChunkSize(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            int n;
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            if (RtmpConfig.INSTANCE.getWriteChunkSize() != 128) {
                SetChunkSize chunkSize = new SetChunkSize(RtmpConfig.INSTANCE.getWriteChunkSize());
                chunkSize.getHeader().setTimeStamp(this.getCurrentTimestamp());
                chunkSize.getHeader().setMessageStreamId(this.streamId);
                chunkSize.writeHeader(output);
                chunkSize.writeBody(output);
                socket.flush();
                n = Log.i((String)this.TAG, (String)("send " + chunkSize));
            } else {
                n = Log.i((String)this.TAG, (String)"using default write chunk size 128");
            }
            int n2 = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendConnect(@NotNull String auth, @NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            this.sendConnect(auth, output);
            socket.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createStream(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            this.createStream(output);
            socket.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final RtmpMessage readMessageResponse(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        InputStream input = socket.getInputStream();
        RtmpMessage message = RtmpMessage.Companion.getRtmpMessage(input, this.readChunkSize, this.sessionHistory);
        this.sessionHistory.setReadHeader(message.getHeader());
        Log.i((String)this.TAG, (String)("read " + message));
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMetadata(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            this.sendMetadata(output);
            socket.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendPublish(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            this.sendPublish(output);
            socket.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendWindowAcknowledgementSize(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            WindowAcknowledgementSize windowAcknowledgementSize = new WindowAcknowledgementSize(RtmpConfig.INSTANCE.getAcknowledgementWindowSize(), this.getCurrentTimestamp());
            windowAcknowledgementSize.writeHeader(output);
            windowAcknowledgementSize.writeBody(output);
            socket.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendPong(@NotNull Event event, @NotNull RtmpSocket socket) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            UserControl pong = new UserControl(Type.PONG_REPLY, event);
            pong.writeHeader(output);
            pong.writeBody(output);
            socket.flush();
            int n = Log.i((String)this.TAG, (String)"send pong");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendClose(@NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            this.sendClose(output);
            socket.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int sendVideoPacket(@NotNull FlvPacket flvPacket, @NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            if (this.akamaiTs) {
                flvPacket.setTimeStamp((System.nanoTime() / (long)1000 - this.startTs) / (long)1000);
            }
            Video video = new Video(flvPacket, this.streamId);
            video.writeHeader(output);
            video.writeBody(output);
            socket.flush();
            int n = video.getHeader().getPacketLength();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int sendAudioPacket(@NotNull FlvPacket flvPacket, @NotNull RtmpSocket socket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)flvPacket, (String)"flvPacket");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Object object = this.writeSync;
        synchronized (object) {
            boolean bl = false;
            OutputStream output = socket.getOutStream();
            if (this.akamaiTs) {
                flvPacket.setTimeStamp((System.nanoTime() / (long)1000 - this.startTs) / (long)1000);
            }
            Audio audio = new Audio(flvPacket, this.streamId);
            audio.writeHeader(output);
            audio.writeBody(output);
            socket.flush();
            int n = audio.getHeader().getPacketLength();
            return n;
        }
    }

    public abstract void sendConnect(@NotNull String var1, @NotNull OutputStream var2);

    public abstract void createStream(@NotNull OutputStream var1);

    public abstract void sendMetadata(@NotNull OutputStream var1);

    public abstract void sendPublish(@NotNull OutputStream var1);

    public abstract void sendClose(@NotNull OutputStream var1);

    public final void reset() {
        this.startTs = 0L;
        this.timestamp = 0;
        this.streamId = 0;
        this.commandId = 0;
        this.readChunkSize = 128;
        this.sessionHistory.reset();
    }
}

