/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message;

import com.pedro.rtmp.rtmp.chunk.ChunkType;
import com.pedro.rtmp.rtmp.message.Abort;
import com.pedro.rtmp.rtmp.message.Acknowledgement;
import com.pedro.rtmp.rtmp.message.Aggregate;
import com.pedro.rtmp.rtmp.message.Audio;
import com.pedro.rtmp.rtmp.message.BasicHeader;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpHeader;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.SetPeerBandwidth;
import com.pedro.rtmp.rtmp.message.Video;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.command.CommandAmf0;
import com.pedro.rtmp.rtmp.message.command.CommandAmf3;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.rtmp.message.data.DataAmf0;
import com.pedro.rtmp.rtmp.message.data.DataAmf3;
import com.pedro.rtmp.rtmp.message.shared.SharedObjectAmf0;
import com.pedro.rtmp.rtmp.message.shared.SharedObjectAmf3;
import com.pedro.rtmp.utils.CommandSessionHistory;
import com.pedro.rtmp.utils.RtmpConfig;
import com.pedro.rtmp.utils.UtilsKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\b\u0010\u0013\u001a\u00020\u0014H&J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "", "basicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "(Lcom/pedro/rtmp/rtmp/message/BasicHeader;)V", "header", "Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "getHeader", "()Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "header$delegate", "Lkotlin/Lazy;", "getSize", "", "getType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "readBody", "", "input", "Ljava/io/InputStream;", "storeBody", "", "updateHeader", "rtmpHeader", "writeBody", "output", "Ljava/io/OutputStream;", "writeHeader", "Companion", "rtmp_release"})
public abstract class RtmpMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy header$delegate;
    @NotNull
    private static final String TAG = "RtmpMessage";

    public RtmpMessage(@NotNull BasicHeader basicHeader) {
        Intrinsics.checkNotNullParameter((Object)basicHeader, (String)"basicHeader");
        this.header$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RtmpHeader>(basicHeader, this){
            final /* synthetic */ BasicHeader $basicHeader;
            final /* synthetic */ RtmpMessage this$0;
            {
                this.$basicHeader = $basicHeader;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RtmpHeader invoke() {
                RtmpHeader rtmpHeader = new RtmpHeader(this.$basicHeader);
                RtmpMessage rtmpMessage = this.this$0;
                RtmpHeader $this$invoke_u24lambda_u240 = rtmpHeader;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setMessageType(rtmpMessage.getType());
                $this$invoke_u24lambda_u240.setMessageLength(rtmpMessage.getSize());
                return rtmpHeader;
            }
        }));
    }

    @NotNull
    public final RtmpHeader getHeader() {
        Lazy lazy = this.header$delegate;
        return (RtmpHeader)lazy.getValue();
    }

    public final void updateHeader(@NotNull RtmpHeader rtmpHeader) {
        Intrinsics.checkNotNullParameter((Object)rtmpHeader, (String)"rtmpHeader");
        this.getHeader().setBasicHeader(rtmpHeader.getBasicHeader());
        this.getHeader().setMessageType(rtmpHeader.getMessageType());
        this.getHeader().setMessageLength(rtmpHeader.getMessageLength());
        this.getHeader().setMessageStreamId(rtmpHeader.getMessageStreamId());
        this.getHeader().setTimeStamp(rtmpHeader.getTimeStamp());
    }

    public final void writeHeader(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.getHeader().writeHeader(output);
    }

    public final void writeBody(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int chunkSize = RtmpConfig.INSTANCE.getWriteChunkSize();
        byte[] bytes = this.storeBody();
        int pos = 0;
        int length = this.getSize();
        while (length > chunkSize) {
            output.write(bytes, pos, chunkSize);
            length -= chunkSize;
            pos += chunkSize;
            this.getHeader().writeHeader(new BasicHeader(ChunkType.TYPE_3, this.getHeader().getBasicHeader().getChunkStreamId()), output);
        }
        output.write(bytes, pos, length);
    }

    public abstract void readBody(@NotNull InputStream var1);

    @NotNull
    public abstract byte[] storeBody();

    @NotNull
    public abstract MessageType getType();

    public abstract int getSize();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pedro/rtmp/rtmp/message/RtmpMessage$Companion;", "", "()V", "TAG", "", "getInputWithoutChunks", "Ljava/io/InputStream;", "input", "header", "Lcom/pedro/rtmp/rtmp/message/RtmpHeader;", "chunkSize", "", "commandSessionHistory", "Lcom/pedro/rtmp/utils/CommandSessionHistory;", "getMarkType", "Lcom/pedro/rtmp/rtmp/message/MessageType;", "type", "getRtmpMessage", "Lcom/pedro/rtmp/rtmp/message/RtmpMessage;", "rtmp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RtmpMessage getRtmpMessage(@NotNull InputStream input, int chunkSize, @NotNull CommandSessionHistory commandSessionHistory) throws IOException {
            RtmpMessage rtmpMessage;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)commandSessionHistory, (String)"commandSessionHistory");
            RtmpHeader header2 = RtmpHeader.Companion.readHeader$default(RtmpHeader.Companion, input, commandSessionHistory, 0, 4, null);
            MessageType messageType = header2.getMessageType();
            switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
                case 1: {
                    rtmpMessage = new SetChunkSize(0, 1, null);
                    break;
                }
                case 2: {
                    rtmpMessage = new Abort(0, 1, null);
                    break;
                }
                case 3: {
                    rtmpMessage = new Acknowledgement(0, 1, null);
                    break;
                }
                case 4: {
                    rtmpMessage = new UserControl(null, null, 3, null);
                    break;
                }
                case 5: {
                    rtmpMessage = new WindowAcknowledgementSize(0, 0, 3, null);
                    break;
                }
                case 6: {
                    rtmpMessage = new SetPeerBandwidth(0, null, 3, null);
                    break;
                }
                case 7: {
                    rtmpMessage = new Audio(null, 0, 3, null);
                    break;
                }
                case 8: {
                    rtmpMessage = new Video(null, 0, 3, null);
                    break;
                }
                case 9: {
                    rtmpMessage = new DataAmf3(null, 0, 0, null, 15, null);
                    break;
                }
                case 10: {
                    rtmpMessage = new SharedObjectAmf3();
                    break;
                }
                case 11: {
                    rtmpMessage = new CommandAmf3(null, 0, 0, 0, null, 31, null);
                    break;
                }
                case 12: {
                    rtmpMessage = new DataAmf0(null, 0, 0, null, 15, null);
                    break;
                }
                case 13: {
                    rtmpMessage = new SharedObjectAmf0();
                    break;
                }
                case 14: {
                    rtmpMessage = new CommandAmf0(null, 0, 0, 0, null, 31, null);
                    break;
                }
                case 15: {
                    rtmpMessage = new Aggregate();
                    break;
                }
                default: {
                    throw new IOException("Unimplemented message type: " + (Object)((Object)header2.getMessageType()));
                }
            }
            RtmpMessage rtmpMessage2 = rtmpMessage;
            rtmpMessage2.updateHeader(header2);
            InputStream bodyInput = header2.getMessageLength() > chunkSize ? this.getInputWithoutChunks(input, header2, chunkSize, commandSessionHistory) : input;
            rtmpMessage2.readBody(bodyInput);
            return rtmpMessage2;
        }

        @NotNull
        public final MessageType getMarkType(int type) {
            MessageType messageType;
            block2: {
                MessageType[] messageTypeArray = MessageType.values();
                int n = messageTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    MessageType messageType2;
                    MessageType it = messageType2 = messageTypeArray[i];
                    boolean bl = false;
                    if (!(it.getMark() == type)) continue;
                    messageType = messageType2;
                    break block2;
                }
                messageType = null;
            }
            if (messageType == null) {
                throw new IOException("Unknown rtmp message type: " + type);
            }
            return messageType;
        }

        private final InputStream getInputWithoutChunks(InputStream input, RtmpHeader header2, int chunkSize, CommandSessionHistory commandSessionHistory) {
            byte[] chunk;
            ByteArrayOutputStream packetStore = new ByteArrayOutputStream();
            for (int bytesRead = 0; bytesRead < header2.getMessageLength(); bytesRead += chunk.length) {
                chunk = null;
                if (header2.getMessageLength() - bytesRead < chunkSize) {
                    chunk = new byte[header2.getMessageLength() - bytesRead];
                    UtilsKt.readUntil(input, chunk);
                } else {
                    chunk = new byte[chunkSize];
                    UtilsKt.readUntil(input, chunk);
                    RtmpHeader.Companion.readHeader(input, commandSessionHistory, header2.getTimeStamp());
                }
                packetStore.write(chunk);
            }
            return new ByteArrayInputStream(packetStore.toByteArray());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MessageType.values().length];
                try {
                    nArray[MessageType.SET_CHUNK_SIZE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.ABORT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.ACKNOWLEDGEMENT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.USER_CONTROL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.WINDOW_ACKNOWLEDGEMENT_SIZE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.SET_PEER_BANDWIDTH.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.AUDIO.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.VIDEO.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.DATA_AMF3.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.SHARED_OBJECT_AMF3.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.COMMAND_AMF3.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.DATA_AMF0.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.SHARED_OBJECT_AMF0.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.COMMAND_AMF0.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageType.AGGREGATE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

