/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtmp.amf.AmfVersion;
import com.pedro.rtmp.flv.video.ProfileIop;
import com.pedro.rtmp.rtmp.CommandsManager;
import com.pedro.rtmp.rtmp.CommandsManagerAmf0;
import com.pedro.rtmp.rtmp.CommandsManagerAmf3;
import com.pedro.rtmp.rtmp.Handshake;
import com.pedro.rtmp.rtmp.RtmpSender;
import com.pedro.rtmp.rtmp.message.Abort;
import com.pedro.rtmp.rtmp.message.Acknowledgement;
import com.pedro.rtmp.rtmp.message.Aggregate;
import com.pedro.rtmp.rtmp.message.MessageType;
import com.pedro.rtmp.rtmp.message.RtmpMessage;
import com.pedro.rtmp.rtmp.message.SetChunkSize;
import com.pedro.rtmp.rtmp.message.SetPeerBandwidth;
import com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize;
import com.pedro.rtmp.rtmp.message.command.Command;
import com.pedro.rtmp.rtmp.message.control.Type;
import com.pedro.rtmp.rtmp.message.control.UserControl;
import com.pedro.rtmp.utils.AuthUtil;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtmp.utils.RtmpConfig;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import com.pedro.rtmp.utils.socket.TcpSocket;
import com.pedro.rtmp.utils.socket.TcpTunneledSocket;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00100\u001a\u000201H\u0002J\u001c\u00102\u001a\u0002012\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00103\u001a\u00020\fH\u0007J\u0006\u00104\u001a\u000201J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\fH\u0002J\b\u00106\u001a\u00020\fH\u0002J\u000e\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\fJ\u0018\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0002J\u0010\u0010<\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0002J\u0010\u0010=\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0002J\b\u0010>\u001a\u000201H\u0002J\b\u0010?\u001a\u000201H\u0002J\u0006\u0010@\u001a\u00020\fJ\b\u0010A\u001a\u00020\fH\u0002J\u001c\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020\u00112\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010E\u001a\u000201J\u0006\u0010F\u001a\u000201J\u0006\u0010G\u001a\u000201J\u0006\u0010H\u001a\u000201J\u000e\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020\bJ\u0016\u0010K\u001a\u0002012\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0016\u0010P\u001a\u0002012\u0006\u0010Q\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u000e\u0010R\u001a\u0002012\u0006\u0010S\u001a\u00020TJ\u0016\u0010U\u001a\u0002012\u0006\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020\fJ\u001a\u0010X\u001a\u0002012\b\u0010Y\u001a\u0004\u0018\u00010\u00062\b\u0010Z\u001a\u0004\u0018\u00010\u0006J\u000e\u0010[\u001a\u0002012\u0006\u00108\u001a\u00020\fJ\u000e\u0010\\\u001a\u0002012\u0006\u0010]\u001a\u00020\bJ\u000e\u0010^\u001a\u0002012\u0006\u0010_\u001a\u00020\fJ\u000e\u0010`\u001a\u0002012\u0006\u0010a\u001a\u00020\fJ\u000e\u0010b\u001a\u0002012\u0006\u0010c\u001a\u00020\fJ\u000e\u0010d\u001a\u0002012\u0006\u0010e\u001a\u00020fJ\u000e\u0010g\u001a\u0002012\u0006\u0010\u001d\u001a\u00020\bJ \u0010h\u001a\u0002012\u0006\u0010i\u001a\u00020M2\u0006\u0010j\u001a\u00020M2\b\u0010k\u001a\u0004\u0018\u00010MJ\u0016\u0010l\u001a\u0002012\u0006\u0010m\u001a\u00020\b2\u0006\u0010n\u001a\u00020\bJ\u000e\u0010o\u001a\u0002012\u0006\u0010p\u001a\u00020\bJ\u000e\u0010q\u001a\u00020\f2\u0006\u0010r\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013R\u0011\u0010'\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0013R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/pedro/rtmp/rtmp/RtmpClient;", "", "connectCheckerRtmp", "Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;", "(Lcom/pedro/rtmp/utils/ConnectCheckerRtmp;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "checkServerAlive", "", "commandsManager", "Lcom/pedro/rtmp/rtmp/CommandsManager;", "doingRetry", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "handler", "Ljava/util/concurrent/ScheduledExecutorService;", "<set-?>", "isStreaming", "()Z", "numRetry", "publishPermitted", "reTries", "rtmpSender", "Lcom/pedro/rtmp/rtmp/RtmpSender;", "rtmpUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "runnable", "Ljava/lang/Runnable;", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "socket", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "thread", "Ljava/util/concurrent/ExecutorService;", "tlsEnabled", "tunneled", "url", "closeConnection", "", "connect", "isRetry", "disconnect", "clear", "establishConnection", "forceAkamaiTs", "enabled", "getAppName", "app", "name", "getStreamName", "getTcUrl", "handleMessages", "handleServerPackets", "hasCongestion", "isAlive", "reConnect", "delay", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAmfVersion", "amfVersion", "Lcom/pedro/rtmp/amf/AmfVersion;", "setAudioInfo", "sampleRate", "isStereo", "setAuthorization", "user", "password", "setCheckServerAlive", "setFps", "fps", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setProfileIop", "profileIop", "Lcom/pedro/rtmp/flv/video/ProfileIop;", "setReTries", "setVideoInfo", "sps", "pps", "vps", "setVideoResolution", "width", "height", "setWriteChunkSize", "chunkSize", "shouldRetry", "reason", "rtmp_release"})
public final class RtmpClient {
    @NotNull
    private final ConnectCheckerRtmp connectCheckerRtmp;
    @NotNull
    private final String TAG;
    private final Pattern rtmpUrlPattern;
    @Nullable
    private RtmpSocket socket;
    @Nullable
    private ExecutorService thread;
    @NotNull
    private CommandsManager commandsManager;
    @NotNull
    private final RtmpSender rtmpSender;
    private volatile boolean isStreaming;
    @Nullable
    private String url;
    private boolean tlsEnabled;
    private boolean tunneled;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;
    @Nullable
    private ScheduledExecutorService handler;
    @Nullable
    private Runnable runnable;
    private boolean checkServerAlive;
    private boolean publishPermitted;

    public RtmpClient(@NotNull ConnectCheckerRtmp connectCheckerRtmp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtmp, (String)"connectCheckerRtmp");
        this.connectCheckerRtmp = connectCheckerRtmp;
        this.TAG = "RtmpClient";
        this.rtmpUrlPattern = Pattern.compile("^rtmpt?s?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
        this.commandsManager = new CommandsManagerAmf0();
        this.rtmpSender = new RtmpSender(this.connectCheckerRtmp, this.commandsManager);
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.rtmpSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.rtmpSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.rtmpSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.rtmpSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.rtmpSender.getSentVideoFrames();
    }

    public final void setAmfVersion(@NotNull AmfVersion amfVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)amfVersion), (String)"amfVersion");
        if (!this.isStreaming) {
            switch (WhenMappings.$EnumSwitchMapping$0[amfVersion.ordinal()]) {
                case 1: {
                    this.commandsManager = new CommandsManagerAmf0();
                    break;
                }
                case 2: {
                    this.commandsManager = new CommandsManagerAmf3();
                }
            }
        }
    }

    public final void setCheckServerAlive(boolean enabled) {
        this.checkServerAlive = enabled;
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        this.commandsManager.setAudioDisabled(false);
        this.commandsManager.setVideoDisabled(onlyAudio);
    }

    public final void setOnlyVideo(boolean onlyVideo) {
        this.commandsManager.setVideoDisabled(false);
        this.commandsManager.setAudioDisabled(onlyVideo);
    }

    public final void forceAkamaiTs(boolean enabled) {
        this.commandsManager.setAkamaiTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        RtmpConfig.INSTANCE.setWriteChunkSize(chunkSize);
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        this.commandsManager.setAuth(user, password);
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.commandsManager.setAudioInfo(sampleRate, isStereo);
        this.rtmpSender.setAudioInfo(sampleRate, isStereo);
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.rtmpSender.setVideoInfo(sps, pps, vps);
    }

    public final void setProfileIop(@NotNull ProfileIop profileIop) {
        Intrinsics.checkNotNullParameter((Object)((Object)profileIop), (String)"profileIop");
        this.rtmpSender.setProfileIop(profileIop);
    }

    public final void setVideoResolution(int width, int height) {
        this.commandsManager.setVideoResolution(width, height);
    }

    public final void setFps(int fps) {
        this.commandsManager.setFps(fps);
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        block11: {
            String string;
            String string2;
            if (!isRetry) {
                this.doingRetry = true;
            }
            if (url == null) {
                this.isStreaming = false;
                this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
                return;
            }
            if (this.isStreaming && !isRetry) break block11;
            this.url = url;
            this.connectCheckerRtmp.onConnectionStartedRtmp(url);
            Matcher rtmpMatcher = this.rtmpUrlPattern.matcher(url);
            if (rtmpMatcher.matches()) {
                string2 = rtmpMatcher.group(0);
                if (string2 == null) {
                    string2 = "";
                }
            } else {
                this.connectCheckerRtmp.onConnectionFailedRtmp("Endpoint malformed, should be: rtmp://ip:port/appname/streamname");
                return;
            }
            String schema = string2;
            this.tunneled = StringsKt.startsWith$default((String)schema, (String)"rtmpt", (boolean)false, (int)2, null);
            this.tlsEnabled = StringsKt.startsWith$default((String)schema, (String)"rtmps", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)schema, (String)"rtmpts", (boolean)false, (int)2, null);
            String string3 = rtmpMatcher.group(1);
            if (string3 == null) {
                string3 = "";
            }
            this.commandsManager.setHost(string3);
            String portStr = rtmpMatcher.group(2);
            int defaultPort = this.tlsEnabled ? 443 : (this.tunneled ? 80 : 1935);
            String string4 = portStr;
            this.commandsManager.setPort(string4 != null ? Integer.parseInt(string4) : defaultPort);
            String string5 = rtmpMatcher.group(3);
            if (string5 == null) {
                string5 = "";
            }
            if ((string = rtmpMatcher.group(4)) == null) {
                string = "";
            }
            this.commandsManager.setAppName(this.getAppName(string5, string));
            String string6 = rtmpMatcher.group(4);
            if (string6 == null) {
                string6 = "";
            }
            this.commandsManager.setStreamName(this.getStreamName(string6));
            String string7 = rtmpMatcher.group(0);
            string7 = string7 == null ? "" : string7;
            int n = 0;
            String string8 = rtmpMatcher.group(0);
            if (string8 == null) {
                string8 = "";
            }
            int n2 = string8.length() - this.commandsManager.getStreamName().length();
            String string9 = string7.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.commandsManager.setTcUrl(this.getTcUrl(string9));
            this.isStreaming = true;
            ExecutorService executorService = this.thread = Executors.newSingleThreadExecutor();
            if (executorService != null) {
                executorService.execute(() -> RtmpClient.connect$lambda$0(this));
            }
        }
    }

    public static /* synthetic */ void connect$default(RtmpClient rtmpClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rtmpClient.connect(string, bl);
    }

    private final void handleServerPackets() {
        while (!Thread.interrupted() && this.isStreaming) {
            try {
                if (this.isAlive()) {
                    if (this.tunneled) continue;
                    this.handleMessages();
                    continue;
                }
                Thread.currentThread().interrupt();
                this.connectCheckerRtmp.onConnectionFailedRtmp("No response from server");
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final boolean isAlive() {
        boolean connected;
        RtmpSocket rtmpSocket = this.socket;
        boolean bl = connected = rtmpSocket != null ? rtmpSocket.isConnected() : false;
        if (!this.checkServerAlive) {
            return connected;
        }
        RtmpSocket rtmpSocket2 = this.socket;
        boolean reachable = rtmpSocket2 != null ? rtmpSocket2.isReachable() : false;
        return connected && !reachable ? false : connected;
    }

    private final String getAppName(String app, String name) {
        String string;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string = app;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(app).append('/');
            String string2 = name.substring(0, StringsKt.indexOf$default((CharSequence)name, (String)"/", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = stringBuilder.append(string2).toString();
        }
        return string;
    }

    private final String getStreamName(String name) {
        String string;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null)) {
            string = name;
        } else {
            String string2 = name.substring(StringsKt.indexOf$default((CharSequence)name, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    private final String getTcUrl(String url) {
        String string;
        if (StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = url.substring(0, url.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = url;
        }
        return string;
    }

    private final boolean establishConnection() throws IOException {
        RtmpSocket socket;
        this.socket = socket = this.tunneled ? (RtmpSocket)new TcpTunneledSocket(this.commandsManager.getHost(), this.commandsManager.getPort(), this.tlsEnabled) : (RtmpSocket)new TcpSocket(this.commandsManager.getHost(), this.commandsManager.getPort(), this.tlsEnabled);
        socket.connect();
        if (!socket.isConnected()) {
            return false;
        }
        long timestamp = System.currentTimeMillis() / (long)1000;
        Handshake handshake = new Handshake();
        if (!handshake.sendHandshake(socket)) {
            return false;
        }
        this.commandsManager.setTimestamp((int)timestamp);
        this.commandsManager.setStartTs(System.nanoTime() / (long)1000);
        return true;
    }

    private final void handleMessages() throws IOException {
        RtmpSocket rtmpSocket = this.socket;
        if (rtmpSocket == null) {
            throw new IOException("Invalid socket, Connection failed");
        }
        RtmpSocket socket = rtmpSocket;
        RtmpMessage message = this.commandsManager.readMessageResponse(socket);
        block3 : switch (WhenMappings.$EnumSwitchMapping$2[message.getType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.SetChunkSize");
                SetChunkSize setChunkSize = (SetChunkSize)message;
                this.commandsManager.setReadChunkSize(setChunkSize.getChunkSize());
                Log.i((String)this.TAG, (String)("chunk size configured to " + setChunkSize.getChunkSize()));
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.Acknowledgement");
                Acknowledgement setChunkSize = (Acknowledgement)message;
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.WindowAcknowledgementSize");
                WindowAcknowledgementSize windowAcknowledgementSize = (WindowAcknowledgementSize)message;
                RtmpConfig.INSTANCE.setAcknowledgementWindowSize(windowAcknowledgementSize.getAcknowledgementWindowSize());
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.SetPeerBandwidth");
                SetPeerBandwidth setPeerBandwidth = (SetPeerBandwidth)message;
                this.commandsManager.sendWindowAcknowledgementSize(socket);
                break;
            }
            case 5: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.Abort");
                Abort setPeerBandwidth = (Abort)message;
                break;
            }
            case 6: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.Aggregate");
                Aggregate setPeerBandwidth = (Aggregate)message;
                break;
            }
            case 7: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.control.UserControl");
                UserControl userControl = (UserControl)message;
                Type type = userControl.getType();
                if (WhenMappings.$EnumSwitchMapping$1[type.ordinal()] == 1) {
                    this.commandsManager.sendPong(userControl.getEvent(), socket);
                    break;
                }
                Log.i((String)this.TAG, (String)("user control command " + (Object)((Object)type) + " ignored"));
                break;
            }
            case 8: 
            case 9: {
                Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type com.pedro.rtmp.rtmp.message.command.Command");
                Command command = (Command)message;
                String commandName = this.commandsManager.getSessionHistory().getName(command.getCommandId());
                switch (command.getName()) {
                    case "_result": {
                        String string = commandName;
                        if (Intrinsics.areEqual((Object)string, (Object)"connect")) {
                            if (this.commandsManager.getOnAuth()) {
                                this.connectCheckerRtmp.onAuthSuccessRtmp();
                                this.commandsManager.setOnAuth(false);
                            }
                            this.commandsManager.createStream(socket);
                        } else if (Intrinsics.areEqual((Object)string, (Object)"createStream")) {
                            try {
                                this.commandsManager.setStreamId(command.getStreamId());
                                this.commandsManager.sendPublish(socket);
                            }
                            catch (ClassCastException e) {
                                Log.e((String)this.TAG, (String)"error parsing _result createStream", (Throwable)e);
                            }
                        }
                        StringBuilder stringBuilder = new StringBuilder().append("success response received from ");
                        String string2 = commandName;
                        if (string2 == null) {
                            string2 = "unknown command";
                        }
                        Log.i((String)this.TAG, (String)stringBuilder.append(string2).toString());
                        break block3;
                    }
                    case "_error": {
                        try {
                            String description = command.getDescription();
                            if (Intrinsics.areEqual((Object)commandName, (Object)"connect")) {
                                if (StringsKt.contains$default((CharSequence)description, (CharSequence)"reason=authfail", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)description, (CharSequence)"reason=nosuchuser", (boolean)false, (int)2, null)) {
                                    this.connectCheckerRtmp.onAuthErrorRtmp();
                                    break block3;
                                }
                                if (this.commandsManager.getUser() != null && this.commandsManager.getPassword() != null && StringsKt.contains$default((CharSequence)description, (CharSequence)"challenge=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)description, (CharSequence)"salt=", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)description, (CharSequence)"nonce=", (boolean)false, (int)2, null)) {
                                    String string;
                                    this.closeConnection();
                                    this.establishConnection();
                                    RtmpSocket rtmpSocket2 = this.socket;
                                    if (rtmpSocket2 == null) {
                                        throw new IOException("Invalid socket, Connection failed");
                                    }
                                    socket = rtmpSocket2;
                                    this.commandsManager.setOnAuth(true);
                                    if (StringsKt.contains$default((CharSequence)description, (CharSequence)"challenge=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)description, (CharSequence)"salt=", (boolean)false, (int)2, null)) {
                                        String string3;
                                        String salt = AuthUtil.INSTANCE.getSalt(description);
                                        String challenge = AuthUtil.INSTANCE.getChallenge(description);
                                        String opaque = AuthUtil.INSTANCE.getOpaque(description);
                                        String string4 = this.commandsManager.getUser();
                                        if (string4 == null) {
                                            string4 = "";
                                        }
                                        if ((string3 = this.commandsManager.getPassword()) == null) {
                                            string3 = "";
                                        }
                                        this.commandsManager.sendConnect(AuthUtil.INSTANCE.getAdobeAuthUserResult(string4, string3, salt, challenge, opaque), socket);
                                        break block3;
                                    }
                                    if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"nonce=", (boolean)false, (int)2, null)) break block3;
                                    String nonce = AuthUtil.INSTANCE.getNonce(description);
                                    String string5 = this.commandsManager.getUser();
                                    if (string5 == null) {
                                        string5 = "";
                                    }
                                    if ((string = this.commandsManager.getPassword()) == null) {
                                        string = "";
                                    }
                                    this.commandsManager.sendConnect(AuthUtil.INSTANCE.getLlnwAuthUserResult(string5, string, nonce, this.commandsManager.getAppName()), socket);
                                    break block3;
                                }
                                if (StringsKt.contains$default((CharSequence)description, (CharSequence)"code=403", (boolean)false, (int)2, null)) {
                                    if (StringsKt.contains$default((CharSequence)description, (CharSequence)"authmod=adobe", (boolean)false, (int)2, null)) {
                                        this.closeConnection();
                                        this.establishConnection();
                                        RtmpSocket rtmpSocket3 = this.socket;
                                        if (rtmpSocket3 == null) {
                                            throw new IOException("Invalid socket, Connection failed");
                                        }
                                        socket = rtmpSocket3;
                                        Log.i((String)this.TAG, (String)"sending auth mode adobe");
                                        this.commandsManager.sendConnect("?authmod=adobe&user=" + this.commandsManager.getUser(), socket);
                                        break block3;
                                    }
                                    if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"authmod=llnw", (boolean)false, (int)2, null)) break block3;
                                    Log.i((String)this.TAG, (String)"sending auth mode llnw");
                                    this.commandsManager.sendConnect("?authmod=llnw&user=" + this.commandsManager.getUser(), socket);
                                    break block3;
                                }
                                this.connectCheckerRtmp.onAuthErrorRtmp();
                                break block3;
                            }
                            this.connectCheckerRtmp.onConnectionFailedRtmp(description);
                        }
                        catch (ClassCastException e) {
                            Log.e((String)this.TAG, (String)"error parsing _error command", (Throwable)e);
                        }
                        break block3;
                    }
                    case "onStatus": {
                        try {
                            String code;
                            switch (command.getCode()) {
                                case "NetStream.Publish.Start": {
                                    this.commandsManager.sendMetadata(socket);
                                    this.connectCheckerRtmp.onConnectionSuccessRtmp();
                                    this.rtmpSender.setSocket(socket);
                                    this.rtmpSender.start();
                                    this.publishPermitted = true;
                                    break block3;
                                }
                                case "NetStream.Publish.BadName": 
                                case "NetConnection.Connect.Rejected": {
                                    this.connectCheckerRtmp.onConnectionFailedRtmp("onStatus: " + code);
                                    break block3;
                                }
                            }
                            StringBuilder stringBuilder = new StringBuilder().append("onStatus ").append(code).append(" response received from ");
                            String string = commandName;
                            if (string == null) {
                                string = "unknown command";
                            }
                            Log.i((String)this.TAG, (String)stringBuilder.append(string).toString());
                        }
                        catch (ClassCastException e) {
                            Log.e((String)this.TAG, (String)"error parsing onStatus command", (Throwable)e);
                        }
                        break block3;
                    }
                }
                StringBuilder stringBuilder = new StringBuilder().append("unknown ").append(command.getName()).append(" response received from ");
                String string = commandName;
                if (string == null) {
                    string = "unknown command";
                }
                Log.i((String)this.TAG, (String)stringBuilder.append(string).toString());
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                Log.e((String)this.TAG, (String)("unimplemented response for " + (Object)((Object)message.getType()) + ". Ignored"));
            }
        }
    }

    private final void closeConnection() {
        RtmpSocket rtmpSocket = this.socket;
        if (rtmpSocket != null) {
            rtmpSocket.close();
        }
        this.commandsManager.reset();
    }

    @JvmOverloads
    public final void reConnect(long delay, @Nullable String backupUrl) {
        block1: {
            int n = this.reTries;
            this.reTries = n + -1;
            this.disconnect(false);
            Runnable runnable = this.runnable = () -> RtmpClient.reConnect$lambda$1(backupUrl, this);
            if (runnable == null) break block1;
            Runnable it = runnable;
            boolean bl = false;
            ScheduledExecutorService scheduledExecutorService = this.handler = Executors.newSingleThreadScheduledExecutor();
            if (scheduledExecutorService != null) {
                scheduledExecutorService.schedule(it, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static /* synthetic */ void reConnect$default(RtmpClient rtmpClient, long l, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        rtmpClient.reConnect(l, string);
    }

    public final void disconnect() {
        Runnable runnable = this.runnable;
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            ScheduledExecutorService scheduledExecutorService = this.handler;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disconnect(boolean clear) {
        if (this.isStreaming) {
            this.rtmpSender.stop(clear);
        }
        ExecutorService executorService = this.thread;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> RtmpClient.disconnect$lambda$5(this));
        try {
            executor.shutdownNow();
            executor.awaitTermination(200L, TimeUnit.MILLISECONDS);
            ExecutorService executorService2 = this.thread;
            if (executorService2 != null) {
                executorService2.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            this.thread = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeConnection();
        }
        if (clear) {
            this.reTries = this.numRetry;
            this.doingRetry = false;
            this.isStreaming = false;
            this.connectCheckerRtmp.onDisconnectRtmp();
        }
        this.publishPermitted = false;
        this.commandsManager.reset();
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getVideoDisabled()) {
            this.rtmpSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.getAudioDisabled()) {
            this.rtmpSender.sendAudioFrame(aacBuffer, info);
        }
    }

    public final boolean hasCongestion() {
        return this.rtmpSender.hasCongestion();
    }

    public final void resetSentAudioFrames() {
        this.rtmpSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.rtmpSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.rtmpSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.rtmpSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.rtmpSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.rtmpSender.setLogs(enable);
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        RtmpClient.connect$default(this, url, false, 2, null);
    }

    @JvmOverloads
    public final void reConnect(long delay) {
        RtmpClient.reConnect$default(this, delay, null, 2, null);
    }

    private static final void connect$lambda$0(RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if (!this$0.establishConnection()) {
                this$0.connectCheckerRtmp.onConnectionFailedRtmp("Handshake failed");
                return;
            }
            RtmpSocket rtmpSocket = this$0.socket;
            if (rtmpSocket == null) {
                throw new IOException("Invalid socket, Connection failed");
            }
            RtmpSocket socket = rtmpSocket;
            this$0.commandsManager.sendChunkSize(socket);
            this$0.commandsManager.sendConnect("", socket);
            while (!Thread.interrupted() && !this$0.publishPermitted) {
                this$0.handleMessages();
            }
            this$0.handleServerPackets();
        }
        catch (Exception e) {
            Log.e((String)this$0.TAG, (String)"connection error", (Throwable)e);
            this$0.connectCheckerRtmp.onConnectionFailedRtmp("Error configure stream, " + e.getMessage());
            return;
        }
    }

    private static final void reConnect$lambda$1(String $backupUrl, RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = $backupUrl;
        if (string == null) {
            string = this$0.url;
        }
        String reconnectUrl = string;
        this$0.connect(reconnectUrl, true);
    }

    private static final void disconnect$lambda$5(RtmpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            RtmpSocket rtmpSocket = this$0.socket;
            if (rtmpSocket != null) {
                RtmpSocket socket = rtmpSocket;
                boolean bl = false;
                this$0.commandsManager.sendClose(socket);
            }
        }
        catch (IOException e) {
            Log.e((String)this$0.TAG, (String)"disconnect error", (Throwable)e);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AmfVersion.values().length];
            try {
                nArray[AmfVersion.VERSION_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmfVersion.VERSION_3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Type.values().length];
            try {
                nArray[Type.PING_REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.SET_CHUNK_SIZE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ACKNOWLEDGEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.WINDOW_ACKNOWLEDGEMENT_SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SET_PEER_BANDWIDTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.ABORT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.AGGREGATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.USER_CONTROL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.COMMAND_AMF0.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.COMMAND_AMF3.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.VIDEO.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.AUDIO.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.DATA_AMF0.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.DATA_AMF3.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SHARED_OBJECT_AMF0.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.SHARED_OBJECT_AMF3.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

