/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.multiple;

import android.media.MediaCodec;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.library.base.OnlyAudioBase;
import com.pedro.library.multiple.MultiType;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import com.pedro.udp.UdpClient;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J \u0010&\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010(J\u0010\u0010)\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0014J\u0016\u0010*\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010+\u001a\u00020#H\u0014J\u0018\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020!H\u0014J\u0018\u00100\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000bj\b\u0012\u0004\u0012\u00020\u000f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u000bj\b\u0012\u0004\u0012\u00020\u0011`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u000bj\b\u0012\u0004\u0012\u00020\u0013`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u000bj\b\u0012\u0004\u0012\u00020\u0015`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u000bj\b\u0012\u0004\u0012\u00020\u0017`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u000bj\b\u0012\u0004\u0012\u00020\u0019`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u000bj\b\u0012\u0004\u0012\u00020\u001b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/pedro/library/multiple/MultiOnlyAudio;", "Lcom/pedro/library/base/OnlyAudioBase;", "connectCheckerRtmpList", "", "Lcom/pedro/common/ConnectChecker;", "connectCheckerRtspList", "connectCheckerSrtList", "connectCheckerUdpList", "<init>", "([Lcom/pedro/common/ConnectChecker;[Lcom/pedro/common/ConnectChecker;[Lcom/pedro/common/ConnectChecker;[Lcom/pedro/common/ConnectChecker;)V", "rtmpClients", "Ljava/util/ArrayList;", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "Lkotlin/collections/ArrayList;", "rtspClients", "Lcom/pedro/rtsp/rtsp/RtspClient;", "srtClients", "Lcom/pedro/srt/srt/SrtClient;", "udpClients", "Lcom/pedro/udp/UdpClient;", "rtmpStreamClients", "Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "rtspStreamClients", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "srtStreamClients", "Lcom/pedro/library/util/streamclient/SrtStreamClient;", "udpStreamClients", "Lcom/pedro/library/util/streamclient/UdpStreamClient;", "getStreamClient", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "type", "Lcom/pedro/library/multiple/MultiType;", "index", "", "setAudioCodecImp", "", "codec", "Lcom/pedro/common/AudioCodec;", "startStream", "url", "", "startStreamImp", "stopStream", "stopStreamImp", "onAudioInfoImp", "isStereo", "", "sampleRate", "getAudioDataImp", "audioBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "library_release"})
@SourceDebugExtension(value={"SMAP\nMultiOnlyAudio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiOnlyAudio.kt\ncom/pedro/library/multiple/MultiOnlyAudio\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n13472#2:218\n13473#2:220\n13472#2,2:221\n13472#2,2:223\n13472#2,2:225\n1#3:219\n*S KotlinDebug\n*F\n+ 1 MultiOnlyAudio.kt\ncom/pedro/library/multiple/MultiOnlyAudio\n*L\n85#1:218\n85#1:220\n90#1:221,2\n95#1:223,2\n100#1:225,2\n*E\n"})
public final class MultiOnlyAudio
extends OnlyAudioBase {
    @NotNull
    private final ArrayList<RtmpClient> rtmpClients;
    @NotNull
    private final ArrayList<RtspClient> rtspClients;
    @NotNull
    private final ArrayList<SrtClient> srtClients;
    @NotNull
    private final ArrayList<UdpClient> udpClients;
    @NotNull
    private final ArrayList<RtmpStreamClient> rtmpStreamClients;
    @NotNull
    private final ArrayList<RtspStreamClient> rtspStreamClients;
    @NotNull
    private final ArrayList<SrtStreamClient> srtStreamClients;
    @NotNull
    private final ArrayList<UdpStreamClient> udpStreamClients;

    public MultiOnlyAudio(@Nullable ConnectChecker[] connectCheckerRtmpList, @Nullable ConnectChecker[] connectCheckerRtspList, @Nullable ConnectChecker[] connectCheckerSrtList, @Nullable ConnectChecker[] connectCheckerUdpList) {
        block8: {
            RtmpClient client;
            RtmpClient rtmpClient;
            ConnectChecker it;
            ConnectChecker element$iv;
            int n;
            int n2;
            boolean $i$f$forEach;
            ConnectChecker[] $this$forEach$iv;
            this.rtmpClients = new ArrayList();
            this.rtspClients = new ArrayList();
            this.srtClients = new ArrayList();
            this.udpClients = new ArrayList();
            this.rtmpStreamClients = new ArrayList();
            this.rtspStreamClients = new ArrayList();
            this.srtStreamClients = new ArrayList();
            this.udpStreamClients = new ArrayList();
            ConnectChecker[] connectCheckerArray = connectCheckerRtmpList;
            if ((connectCheckerArray == null || connectCheckerArray.length == 0) && ((connectCheckerArray = connectCheckerRtspList) == null || connectCheckerArray.length == 0) && ((connectCheckerArray = connectCheckerSrtList) == null || connectCheckerArray.length == 0) && ((connectCheckerArray = connectCheckerUdpList) == null || connectCheckerArray.length == 0)) {
                throw new IllegalArgumentException("You need set at least one ConnectChecker interface");
            }
            if (connectCheckerRtmpList != null) {
                $this$forEach$iv = connectCheckerRtmpList;
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    RtmpClient $this$lambda_u241_u24lambda_u240 = rtmpClient = new RtmpClient(it);
                    boolean bl2 = false;
                    $this$lambda_u241_u24lambda_u240.setOnlyAudio(true);
                    client = rtmpClient;
                    this.rtmpClients.add(client);
                    this.rtmpStreamClients.add(new RtmpStreamClient(client, null));
                }
            }
            if (connectCheckerRtspList != null) {
                $this$forEach$iv = connectCheckerRtspList;
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    RtmpClient $this$lambda_u243_u24lambda_u242 = rtmpClient = new RtspClient(it);
                    boolean bl3 = false;
                    $this$lambda_u243_u24lambda_u242.setOnlyAudio(true);
                    client = rtmpClient;
                    this.rtspClients.add((RtspClient)client);
                    this.rtspStreamClients.add(new RtspStreamClient((RtspClient)client, null));
                }
            }
            if (connectCheckerSrtList != null) {
                $this$forEach$iv = connectCheckerSrtList;
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    RtmpClient $this$lambda_u245_u24lambda_u244 = rtmpClient = new SrtClient(it);
                    boolean bl4 = false;
                    $this$lambda_u245_u24lambda_u244.setOnlyAudio(true);
                    client = rtmpClient;
                    this.srtClients.add((SrtClient)client);
                    this.srtStreamClients.add(new SrtStreamClient((SrtClient)client, null));
                }
            }
            if (connectCheckerUdpList == null) break block8;
            $this$forEach$iv = connectCheckerUdpList;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                RtmpClient $this$lambda_u247_u24lambda_u246 = rtmpClient = new UdpClient(it);
                boolean bl5 = false;
                $this$lambda_u247_u24lambda_u246.setOnlyAudio(true);
                client = rtmpClient;
                this.udpClients.add((UdpClient)client);
                this.udpStreamClients.add(new UdpStreamClient((UdpClient)client, null));
            }
        }
    }

    @NotNull
    public final StreamBaseClient getStreamClient(@NotNull MultiType type, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                RtmpStreamClient v0 = this.rtmpStreamClients.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                yield v0;
            }
            case 2 -> {
                RtspStreamClient v2 = this.rtspStreamClients.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                yield v2;
            }
            case 3 -> {
                SrtStreamClient v3 = this.srtStreamClients.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
                yield v3;
            }
            case 4 -> {
                UdpStreamClient v4 = this.udpStreamClients.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
                yield v4;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public StreamBaseClient getStreamClient() {
        throw new IllegalStateException("getStreamClient not allowed in Multi stream, use getStreamClient(type, index) instead");
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Iterator<RtmpClient> iterator = this.rtmpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RtmpClient> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            rtmpClient.setAudioCodec(codec);
        }
        Iterator<RtspClient> iterator3 = this.rtspClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            RtspClient rtspClient = (RtspClient)rtmpClient;
            rtspClient.setAudioCodec(codec);
        }
        Iterator<SrtClient> iterator4 = this.srtClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            SrtClient srtClient = (SrtClient)rtmpClient;
            srtClient.setAudioCodec(codec);
        }
        Iterator<UdpClient> iterator5 = this.udpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            UdpClient udpClient = (UdpClient)rtmpClient;
            udpClient.setAudioCodec(codec);
        }
    }

    public final void startStream(@NotNull MultiType type, int index, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        boolean shouldStarEncoder = true;
        Iterator<RtmpClient> iterator = this.rtmpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RtmpClient> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!rtmpClient.isStreaming()) continue;
            shouldStarEncoder = false;
            break;
        }
        Iterator<RtspClient> iterator3 = this.rtspClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            RtspClient rtspClient = (RtspClient)rtmpClient;
            if (!rtspClient.isStreaming()) continue;
            shouldStarEncoder = false;
            break;
        }
        Iterator<SrtClient> iterator4 = this.srtClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            SrtClient srtClient = (SrtClient)rtmpClient;
            if (!srtClient.isStreaming()) continue;
            shouldStarEncoder = false;
            break;
        }
        Iterator<UdpClient> iterator5 = this.udpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            UdpClient udpClient = (UdpClient)rtmpClient;
            if (!udpClient.isStreaming()) continue;
            shouldStarEncoder = false;
            break;
        }
        if (shouldStarEncoder) {
            super.startStream("");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.rtmpClients.get(index).connect(url);
                break;
            }
            case 2: {
                this.rtspClients.get(index).connect(url);
                break;
            }
            case 3: {
                SrtClient.connect$default((SrtClient)this.srtClients.get(index), (String)url, (boolean)false, (int)2, null);
                break;
            }
            case 4: {
                UdpClient.connect$default((UdpClient)this.udpClients.get(index), (String)url, (boolean)false, (int)2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    protected void startStreamImp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
    }

    public final void stopStream(@NotNull MultiType type, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        boolean shouldStopEncoder = true;
        Iterator<RtmpClient> iterator = this.rtmpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RtmpClient> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!rtmpClient.isStreaming()) continue;
            shouldStopEncoder = false;
            break;
        }
        Iterator<RtspClient> iterator3 = this.rtspClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            RtspClient rtspClient = (RtspClient)rtmpClient;
            if (!rtspClient.isStreaming()) continue;
            shouldStopEncoder = false;
            break;
        }
        Iterator<SrtClient> iterator4 = this.srtClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            SrtClient srtClient = (SrtClient)rtmpClient;
            if (!srtClient.isStreaming()) continue;
            shouldStopEncoder = false;
            break;
        }
        Iterator<UdpClient> iterator5 = this.udpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            UdpClient udpClient = (UdpClient)rtmpClient;
            if (!udpClient.isStreaming()) continue;
            shouldStopEncoder = false;
            break;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.rtmpClients.get(index).disconnect();
                break;
            }
            case 2: {
                this.rtspClients.get(index).disconnect();
                break;
            }
            case 3: {
                this.srtClients.get(index).disconnect();
                break;
            }
            case 4: {
                this.udpClients.get(index).disconnect();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (shouldStopEncoder) {
            super.stopStream();
        }
    }

    @Override
    protected void stopStreamImp() {
    }

    @Override
    protected void onAudioInfoImp(boolean isStereo, int sampleRate) {
        Iterator<RtmpClient> iterator = this.rtmpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RtmpClient> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            rtmpClient.setAudioInfo(sampleRate, isStereo);
        }
        Iterator<RtspClient> iterator3 = this.rtspClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            RtspClient rtspClient = (RtspClient)rtmpClient;
            rtspClient.setAudioInfo(sampleRate, isStereo);
        }
        Iterator<SrtClient> iterator4 = this.srtClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            SrtClient srtClient = (SrtClient)rtmpClient;
            srtClient.setAudioInfo(sampleRate, isStereo);
        }
        Iterator<UdpClient> iterator5 = this.udpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            UdpClient udpClient = (UdpClient)rtmpClient;
            udpClient.setAudioInfo(sampleRate, isStereo);
        }
    }

    @Override
    protected void getAudioDataImp(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Iterator<RtmpClient> iterator = this.rtmpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RtmpClient> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            ByteBuffer byteBuffer = audioBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
            rtmpClient.sendAudio(byteBuffer, info);
        }
        Iterator<RtspClient> iterator3 = this.rtspClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            RtspClient rtspClient = (RtspClient)rtmpClient;
            ByteBuffer byteBuffer = audioBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
            rtspClient.sendAudio(byteBuffer, info);
        }
        Iterator<SrtClient> iterator4 = this.srtClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            SrtClient srtClient = (SrtClient)rtmpClient;
            ByteBuffer byteBuffer = audioBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
            srtClient.sendAudio(byteBuffer, info);
        }
        Iterator<UdpClient> iterator5 = this.udpClients.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            RtmpClient rtmpClient = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)rtmpClient, (String)"next(...)");
            UdpClient udpClient = (UdpClient)rtmpClient;
            ByteBuffer byteBuffer = audioBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
            udpClient.sendAudio(byteBuffer, info);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MultiType.values().length];
            try {
                nArray[MultiType.RTMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultiType.RTSP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultiType.SRT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultiType.UDP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

