/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.input.sources.audio.AudioSource;
import com.pedro.encoder.input.sources.audio.MicrophoneSource;
import com.pedro.encoder.input.sources.video.Camera2Source;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.library.base.StreamBase;
import com.pedro.library.rtsp.RtspStream;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0010\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0015H\u0014J$\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010%2\b\u0010'\u001a\u0004\u0018\u00010%H\u0014J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0014J\u0018\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006."}, d2={"Lcom/pedro/library/rtsp/RtspStream;", "Lcom/pedro/library/base/StreamBase;", "context", "Landroid/content/Context;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "videoSource", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "audioSource", "Lcom/pedro/encoder/input/sources/audio/AudioSource;", "<init>", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/sources/video/VideoSource;Lcom/pedro/encoder/input/sources/audio/AudioSource;)V", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;)V", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "streamClientListener", "com/pedro/library/rtsp/RtspStream$streamClientListener$1", "Lcom/pedro/library/rtsp/RtspStream$streamClientListener$1;", "getStreamClient", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "setVideoCodecImp", "", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodecImp", "Lcom/pedro/common/AudioCodec;", "onAudioInfoImp", "sampleRate", "", "isStereo", "", "startStreamImp", "endPoint", "", "stopStreamImp", "onVideoInfoImp", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "getVideoDataImp", "videoBuffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "getAudioDataImp", "audioBuffer", "library_release"})
@RequiresApi(value=21)
public final class RtspStream
extends StreamBase {
    @NotNull
    private final RtspClient rtspClient;
    @NotNull
    private final streamClientListener.1 streamClientListener;

    public RtspStream(@NotNull Context context, @NotNull ConnectChecker connectChecker, @NotNull VideoSource videoSource, @NotNull AudioSource audioSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"videoSource");
        Intrinsics.checkNotNullParameter((Object)audioSource, (String)"audioSource");
        super(context, videoSource, audioSource);
        this.rtspClient = new RtspClient(connectChecker);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtspStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyframe();
            }
        };
    }

    @Override
    @NotNull
    public RtspStreamClient getStreamClient() {
        return new RtspStreamClient(this.rtspClient, this.streamClientListener);
    }

    public RtspStream(@NotNull Context context, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        this(context, connectChecker, (VideoSource)new Camera2Source(context), (AudioSource)new MicrophoneSource(0, 1, null));
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.rtspClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.rtspClient.setAudioCodec(codec);
    }

    @Override
    protected void onAudioInfoImp(int sampleRate, boolean isStereo) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamImp(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        this.rtspClient.connect(endPoint);
    }

    @Override
    protected void stopStreamImp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void onVideoInfoImp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getVideoDataImp(@NotNull ByteBuffer videoBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)videoBuffer, (String)"videoBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspClient.sendVideo(videoBuffer, info);
    }

    @Override
    protected void getAudioDataImp(@NotNull ByteBuffer audioBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)audioBuffer, (String)"audioBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspClient.sendAudio(audioBuffer, info);
    }
}

