/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.view;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.common.ExtensionsKt;
import com.pedro.encoder.input.gl.FilterAction;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.MainRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.input.gl.render.filters.NoFilterRender;
import com.pedro.encoder.input.sources.OrientationForced;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.FpsLimiter;
import com.pedro.encoder.utils.ViewPort;
import com.pedro.encoder.utils.gl.AspectRatioMode;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.library.util.Filter;
import com.pedro.library.util.SensorRotationManager;
import com.pedro.library.view.ForceRenderer;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.RenderErrorCallback;
import com.pedro.library.view.TakePhotoCallback;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u0014H\u0016J\u0018\u0010D\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u0014H\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010&\u001a\u00020AH\u0016J\b\u0010G\u001a\u00020AH\u0016J\b\u0010H\u001a\u00020\u001cH\u0016J\u0018\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020\u0014H\u0016J\u0010\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020\u001cH\u0016J\b\u0010L\u001a\u00020\u001cH\u0016J\u0012\u0010M\u001a\u00020A2\b\u0010N\u001a\u0004\u0018\u00010:H\u0016J\b\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020A2\u0006\u0010T\u001a\u00020RH\u0016J\b\u0010U\u001a\u00020AH\u0016J\u0010\u0010V\u001a\u00020A2\u0006\u0010T\u001a\u00020RH\u0016J\b\u0010W\u001a\u00020AH\u0016J\u0012\u0010X\u001a\u00020A2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010Y\u001a\u00020AH\u0016J\b\u0010Z\u001a\u00020AH\u0016J\u0010\u0010[\u001a\u00020A2\u0006\u0010\\\u001a\u00020\u001cH\u0002J\u0012\u0010]\u001a\u00020A2\b\u0010^\u001a\u0004\u0018\u00010PH\u0016J\u000e\u0010_\u001a\u00020A2\u0006\u0010\\\u001a\u00020\u001fJ\u000e\u0010`\u001a\u00020A2\u0006\u0010T\u001a\u00020RJ\u0006\u0010a\u001a\u00020AJ\u0010\u0010b\u001a\u00020A2\u0006\u0010c\u001a\u00020\u0014H\u0016J\u0016\u0010d\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u0014J\u000e\u0010e\u001a\u00020A2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010f\u001a\u00020A2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010g\u001a\u00020A2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010h\u001a\u00020A2\u0006\u0010c\u001a\u00020\u0014J\u0018\u0010i\u001a\u00020A2\u0006\u0010j\u001a\u00020\u00142\u0006\u0010k\u001a\u00020lH\u0016J\u0010\u0010m\u001a\u00020A2\u0006\u0010k\u001a\u00020lH\u0016J\u0018\u0010m\u001a\u00020A2\u0006\u0010j\u001a\u00020\u00142\u0006\u0010k\u001a\u00020lH\u0016J\b\u0010n\u001a\u00020AH\u0016J\u0010\u0010o\u001a\u00020A2\u0006\u0010j\u001a\u00020\u0014H\u0016J\u0010\u0010o\u001a\u00020A2\u0006\u0010k\u001a\u00020lH\u0016J\b\u0010p\u001a\u00020\u0014H\u0016J\u0010\u0010q\u001a\u00020A2\u0006\u0010r\u001a\u00020\u0014H\u0016J\u0010\u0010s\u001a\u00020A2\u0006\u0010K\u001a\u00020\u0014H\u0016J\u0010\u0010t\u001a\u00020A2\u0006\u0010u\u001a\u00020\u001cH\u0016J\u0010\u0010v\u001a\u00020A2\u0006\u0010u\u001a\u00020\u001cH\u0016J\u0010\u0010w\u001a\u00020A2\u0006\u0010u\u001a\u00020\u001cH\u0016J\u0010\u0010x\u001a\u00020A2\u0006\u0010u\u001a\u00020\u001cH\u0016J\u0010\u0010i\u001a\u00020A2\u0006\u0010k\u001a\u00020lH\u0016J\u000e\u0010y\u001a\u00020A2\u0006\u0010+\u001a\u00020,J\u0010\u0010z\u001a\u00020A2\b\u0010{\u001a\u0004\u0018\u00010<J\u0010\u0010|\u001a\u00020A2\b\u0010{\u001a\u0004\u0018\u00010<R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/pedro/library/view/GlStreamInterface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Lcom/pedro/library/view/GlInterface;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "takePhotoCallback", "Lcom/pedro/library/view/TakePhotoCallback;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "surfaceManager", "Lcom/pedro/encoder/input/gl/SurfaceManager;", "surfaceManagerEncoder", "surfaceManagerEncoderRecord", "surfaceManagerPhoto", "surfaceManagerPreview", "mainRender", "Lcom/pedro/encoder/input/gl/render/MainRender;", "encoderWidth", "", "encoderHeight", "encoderRecordWidth", "encoderRecordHeight", "streamOrientation", "previewWidth", "previewHeight", "isPortrait", "", "isPortraitPreview", "orientationForced", "Lcom/pedro/encoder/input/sources/OrientationForced;", "filterQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/library/util/Filter;", "threadQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/lang/Runnable;", "muteVideo", "isPreviewHorizontalFlip", "isPreviewVerticalFlip", "isStreamHorizontalFlip", "isStreamVerticalFlip", "aspectRatioMode", "Lcom/pedro/encoder/utils/gl/AspectRatioMode;", "executor", "Ljava/util/concurrent/ExecutorService;", "fpsLimiter", "Lcom/pedro/encoder/input/video/FpsLimiter;", "forceRender", "Lcom/pedro/library/view/ForceRenderer;", "autoHandleOrientation", "getAutoHandleOrientation", "()Z", "setAutoHandleOrientation", "(Z)V", "shouldHandleOrientation", "renderErrorCallback", "Lcom/pedro/library/view/RenderErrorCallback;", "previewViewPort", "Lcom/pedro/encoder/utils/ViewPort;", "streamViewPort", "sensorRotationManager", "Lcom/pedro/library/util/SensorRotationManager;", "setEncoderSize", "", "width", "height", "setEncoderRecordSize", "getEncoderSize", "Landroid/graphics/Point;", "unMuteVideo", "isVideoMuted", "setForceRender", "enabled", "fps", "isRunning", "setRenderErrorCallback", "callback", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "getSurface", "Landroid/view/Surface;", "addMediaCodecSurface", "surface", "removeMediaCodecSurface", "addMediaCodecRecordSurface", "removeMediaCodecRecordSurface", "takePhoto", "start", "stop", "draw", "forced", "onFrameAvailable", "surfaceTexture", "forceOrientation", "attachPreview", "deAttachPreview", "setStreamRotation", "orientation", "setPreviewResolution", "setIsPortrait", "setPreviewIsPortrait", "setStreamIsPortrait", "setCameraOrientation", "setFilter", "filterPosition", "baseFilterRender", "Lcom/pedro/encoder/input/gl/render/filters/BaseFilterRender;", "addFilter", "clearFilters", "removeFilter", "filtersCount", "setRotation", "rotation", "forceFpsLimit", "setIsStreamHorizontalFlip", "flip", "setIsStreamVerticalFlip", "setIsPreviewHorizontalFlip", "setIsPreviewVerticalFlip", "setAspectRatioMode", "setPreviewViewPort", "viewPort", "setStreamViewPort", "library_release"})
@RequiresApi(api=18)
public final class GlStreamInterface
implements SurfaceTexture.OnFrameAvailableListener,
GlInterface {
    @NotNull
    private final Context context;
    @Nullable
    private TakePhotoCallback takePhotoCallback;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final SurfaceManager surfaceManager;
    @NotNull
    private final SurfaceManager surfaceManagerEncoder;
    @NotNull
    private final SurfaceManager surfaceManagerEncoderRecord;
    @NotNull
    private final SurfaceManager surfaceManagerPhoto;
    @NotNull
    private final SurfaceManager surfaceManagerPreview;
    @NotNull
    private final MainRender mainRender;
    private int encoderWidth;
    private int encoderHeight;
    private int encoderRecordWidth;
    private int encoderRecordHeight;
    private int streamOrientation;
    private int previewWidth;
    private int previewHeight;
    private boolean isPortrait;
    private boolean isPortraitPreview;
    @NotNull
    private OrientationForced orientationForced;
    @NotNull
    private final BlockingQueue<Filter> filterQueue;
    @NotNull
    private final LinkedBlockingQueue<Runnable> threadQueue;
    private boolean muteVideo;
    private boolean isPreviewHorizontalFlip;
    private boolean isPreviewVerticalFlip;
    private boolean isStreamHorizontalFlip;
    private boolean isStreamVerticalFlip;
    @NotNull
    private AspectRatioMode aspectRatioMode;
    @Nullable
    private ExecutorService executor;
    @NotNull
    private final FpsLimiter fpsLimiter;
    @NotNull
    private final ForceRenderer forceRender;
    private boolean autoHandleOrientation;
    private boolean shouldHandleOrientation;
    @Nullable
    private RenderErrorCallback renderErrorCallback;
    @Nullable
    private ViewPort previewViewPort;
    @Nullable
    private ViewPort streamViewPort;
    @NotNull
    private final SensorRotationManager sensorRotationManager;

    public GlStreamInterface(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.running = new AtomicBoolean(false);
        this.surfaceManager = new SurfaceManager();
        this.surfaceManagerEncoder = new SurfaceManager();
        this.surfaceManagerEncoderRecord = new SurfaceManager();
        this.surfaceManagerPhoto = new SurfaceManager();
        this.surfaceManagerPreview = new SurfaceManager();
        this.mainRender = new MainRender();
        this.orientationForced = OrientationForced.NONE;
        this.filterQueue = new LinkedBlockingQueue();
        this.threadQueue = new LinkedBlockingQueue();
        this.aspectRatioMode = AspectRatioMode.Adjust;
        this.fpsLimiter = new FpsLimiter();
        this.forceRender = new ForceRenderer();
        this.shouldHandleOrientation = true;
        this.sensorRotationManager = new SensorRotationManager(this.context, true, true, (arg_0, arg_1) -> GlStreamInterface.sensorRotationManager$lambda$0(this, arg_0, arg_1));
    }

    public final boolean getAutoHandleOrientation() {
        return this.autoHandleOrientation;
    }

    public final void setAutoHandleOrientation(boolean bl) {
        this.autoHandleOrientation = bl;
    }

    @Override
    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    @Override
    public void setEncoderRecordSize(int width, int height) {
        this.encoderRecordWidth = width;
        this.encoderRecordHeight = height;
    }

    @Override
    @NotNull
    public Point getEncoderSize() {
        return new Point(this.encoderWidth, this.encoderHeight);
    }

    @Override
    public void muteVideo() {
        this.muteVideo = true;
    }

    @Override
    public void unMuteVideo() {
        this.muteVideo = false;
    }

    @Override
    public boolean isVideoMuted() {
        return this.muteVideo;
    }

    @Override
    public void setForceRender(boolean enabled, int fps) {
        this.forceRender.setEnabled(enabled, fps);
    }

    @Override
    public void setForceRender(boolean enabled) {
        this.setForceRender(enabled, 5);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void setRenderErrorCallback(@Nullable RenderErrorCallback callback) {
        this.renderErrorCallback = callback;
    }

    @Override
    @NotNull
    public SurfaceTexture getSurfaceTexture() {
        return this.mainRender.getSurfaceTexture();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        return this.mainRender.getSurface();
    }

    @Override
    public void addMediaCodecSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerEncoder.release();
            this.surfaceManagerEncoder.eglSetup(surface, this.surfaceManager);
        }
    }

    @Override
    public void removeMediaCodecSurface() {
        this.threadQueue.clear();
        this.surfaceManagerEncoder.release();
    }

    @Override
    public void addMediaCodecRecordSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerEncoderRecord.release();
            this.surfaceManagerEncoderRecord.eglSetup(surface, this.surfaceManager);
        }
    }

    @Override
    public void removeMediaCodecRecordSurface() {
        this.threadQueue.clear();
        this.surfaceManagerEncoderRecord.release();
    }

    @Override
    public void takePhoto(@Nullable TakePhotoCallback takePhotoCallback) {
        this.takePhotoCallback = takePhotoCallback;
    }

    @Override
    public void start() {
        block1: {
            this.threadQueue.clear();
            ExecutorService executorService = this.executor;
            if (executorService != null) {
                executorService.shutdownNow();
            }
            this.executor = null;
            this.executor = ExtensionsKt.newSingleThreadExecutor(this.threadQueue);
            this.surfaceManager.release();
            this.surfaceManager.eglSetup();
            this.surfaceManagerPhoto.release();
            this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
            this.sensorRotationManager.start();
            ExecutorService executorService2 = this.executor;
            if (executorService2 == null) break block1;
            ExtensionsKt.secureSubmit$default((ExecutorService)executorService2, (long)0L, () -> GlStreamInterface.start$lambda$3(this), (int)1, null);
        }
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.threadQueue.clear();
        ExecutorService executorService = this.executor;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        this.executor = null;
        this.forceRender.stop();
        this.sensorRotationManager.stop();
        this.surfaceManagerPhoto.release();
        this.surfaceManagerEncoder.release();
        this.surfaceManagerEncoderRecord.release();
        this.surfaceManager.release();
        this.mainRender.release();
    }

    private final void draw(boolean forced) {
        int h;
        int w;
        if (!this.isRunning()) {
            return;
        }
        boolean limitFps = this.fpsLimiter.limitFPS();
        if (!forced) {
            this.forceRender.frameAvailable();
        }
        if (this.surfaceManager.isReady() && this.mainRender.isReady() && this.surfaceManager.makeCurrent()) {
            this.mainRender.updateFrame();
            this.mainRender.drawSource();
            this.surfaceManager.swapBuffer();
        }
        if (!this.filterQueue.isEmpty() && this.mainRender.isReady()) {
            try {
                Filter filter = this.filterQueue.take();
                this.mainRender.setFilterAction(filter.filterAction, filter.position, filter.baseFilterRender);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        boolean orientation = switch (WhenMappings.$EnumSwitchMapping$0[this.orientationForced.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> this.isPortrait;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean orientationPreview = switch (WhenMappings.$EnumSwitchMapping$0[this.orientationForced.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> this.isPortraitPreview;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (this.surfaceManagerEncoder.isReady() || this.surfaceManagerEncoderRecord.isReady() || this.surfaceManagerPhoto.isReady()) {
            this.mainRender.drawFilters(false);
        }
        if (this.surfaceManagerEncoder.isReady() && this.mainRender.isReady() && !limitFps) {
            w = this.muteVideo ? 0 : this.encoderWidth;
            int n = h = this.muteVideo ? 0 : this.encoderHeight;
            if (this.surfaceManagerEncoder.makeCurrent()) {
                this.mainRender.drawScreenEncoder(w, h, orientation, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, this.streamViewPort);
                this.surfaceManagerEncoder.swapBuffer();
            }
        }
        if (this.surfaceManagerEncoderRecord.isReady() && this.mainRender.isReady() && !limitFps) {
            w = this.muteVideo ? 0 : this.encoderRecordWidth;
            int n = h = this.muteVideo ? 0 : this.encoderRecordHeight;
            if (this.surfaceManagerEncoderRecord.makeCurrent()) {
                this.mainRender.drawScreenEncoder(w, h, orientation, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, this.streamViewPort);
                this.surfaceManagerEncoderRecord.swapBuffer();
            }
        }
        if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady() && this.mainRender.isReady() && this.surfaceManagerPhoto.makeCurrent()) {
            this.mainRender.drawScreen(this.encoderWidth, this.encoderHeight, AspectRatioMode.NONE, this.streamOrientation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip, this.streamViewPort);
            TakePhotoCallback takePhotoCallback = this.takePhotoCallback;
            if (takePhotoCallback != null) {
                takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
            }
            this.takePhotoCallback = null;
            this.surfaceManagerPhoto.swapBuffer();
        }
        if (this.surfaceManagerPreview.isReady() && this.mainRender.isReady() && !limitFps) {
            w = this.previewWidth == 0 ? this.encoderWidth : this.previewWidth;
            int n = h = this.previewHeight == 0 ? this.encoderHeight : this.previewHeight;
            if (this.surfaceManager.makeCurrent()) {
                this.mainRender.drawFilters(true);
                this.surfaceManager.swapBuffer();
            }
            if (this.surfaceManagerPreview.makeCurrent()) {
                this.mainRender.drawScreenPreview(w, h, orientationPreview, this.aspectRatioMode, 0, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip, this.previewViewPort);
                this.surfaceManagerPreview.swapBuffer();
            }
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        block1: {
            if (!this.isRunning()) {
                return;
            }
            ExecutorService executorService = this.executor;
            if (executorService == null) break block1;
            executorService.execute(() -> GlStreamInterface.onFrameAvailable$lambda$4(this));
        }
    }

    public final void forceOrientation(@NotNull OrientationForced forced) {
        Intrinsics.checkNotNullParameter((Object)forced, (String)"forced");
        switch (WhenMappings.$EnumSwitchMapping$0[forced.ordinal()]) {
            case 1: {
                this.setCameraOrientation(90);
                this.shouldHandleOrientation = false;
                break;
            }
            case 2: {
                this.setCameraOrientation(0);
                this.shouldHandleOrientation = false;
                break;
            }
            case 3: {
                int orientation = CameraHelper.getCameraOrientation((Context)this.context);
                this.setCameraOrientation(orientation == 0 ? 270 : orientation - 90);
                this.shouldHandleOrientation = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.orientationForced = forced;
    }

    public final void attachPreview(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (this.surfaceManager.isReady()) {
            this.surfaceManagerPreview.release();
            this.surfaceManagerPreview.eglSetup(surface, this.surfaceManager);
        }
    }

    public final void deAttachPreview() {
        this.surfaceManagerPreview.release();
    }

    @Override
    public void setStreamRotation(int orientation) {
        this.streamOrientation = orientation;
    }

    public final void setPreviewResolution(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public final void setIsPortrait(boolean isPortrait) {
        this.setPreviewIsPortrait(isPortrait);
        this.setStreamIsPortrait(isPortrait);
    }

    public final void setPreviewIsPortrait(boolean isPortrait) {
        this.isPortraitPreview = isPortrait;
    }

    public final void setStreamIsPortrait(boolean isPortrait) {
        this.isPortrait = isPortrait;
    }

    public final void setCameraOrientation(int orientation) {
        this.mainRender.setCameraRotation(orientation);
    }

    @Override
    public void setFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void addFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD, 0, baseFilterRender));
    }

    @Override
    public void addFilter(int filterPosition, @NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.ADD_INDEX, filterPosition, baseFilterRender));
    }

    @Override
    public void clearFilters() {
        this.filterQueue.add(new Filter(FilterAction.CLEAR, 0, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(int filterPosition) {
        this.filterQueue.add(new Filter(FilterAction.REMOVE_INDEX, filterPosition, (BaseFilterRender)new NoFilterRender()));
    }

    @Override
    public void removeFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.REMOVE, 0, baseFilterRender));
    }

    @Override
    public int filtersCount() {
        return this.mainRender.filtersCount();
    }

    @Override
    public void setRotation(int rotation) {
        this.setCameraOrientation(rotation);
    }

    @Override
    public void forceFpsLimit(int fps) {
        this.fpsLimiter.setFPS(fps);
    }

    @Override
    public void setIsStreamHorizontalFlip(boolean flip) {
        this.isStreamHorizontalFlip = flip;
    }

    @Override
    public void setIsStreamVerticalFlip(boolean flip) {
        this.isStreamVerticalFlip = flip;
    }

    @Override
    public void setIsPreviewHorizontalFlip(boolean flip) {
        this.isPreviewHorizontalFlip = flip;
    }

    @Override
    public void setIsPreviewVerticalFlip(boolean flip) {
        this.isPreviewVerticalFlip = flip;
    }

    @Override
    public void setFilter(@NotNull BaseFilterRender baseFilterRender) {
        Intrinsics.checkNotNullParameter((Object)baseFilterRender, (String)"baseFilterRender");
        this.filterQueue.add(new Filter(FilterAction.SET, 0, baseFilterRender));
    }

    public final void setAspectRatioMode(@NotNull AspectRatioMode aspectRatioMode) {
        Intrinsics.checkNotNullParameter((Object)aspectRatioMode, (String)"aspectRatioMode");
        this.aspectRatioMode = aspectRatioMode;
    }

    public final void setPreviewViewPort(@Nullable ViewPort viewPort) {
        this.previewViewPort = viewPort;
    }

    public final void setStreamViewPort(@Nullable ViewPort viewPort) {
        this.streamViewPort = viewPort;
    }

    private static final void sensorRotationManager$lambda$0(GlStreamInterface this$0, int orientation, boolean isPortrait) {
        if (this$0.autoHandleOrientation && this$0.shouldHandleOrientation) {
            this$0.setCameraOrientation(orientation);
            this$0.setIsPortrait(isPortrait);
        }
    }

    private static final void start$lambda$3$lambda$2$lambda$1(GlStreamInterface this$0) {
        try {
            this$0.draw(true);
        }
        catch (RuntimeException e) {
            RenderErrorCallback renderErrorCallback = this$0.renderErrorCallback;
            if (renderErrorCallback != null) {
                renderErrorCallback.onRenderError(e);
            }
            throw e;
        }
    }

    private static final Unit start$lambda$3$lambda$2(GlStreamInterface this$0) {
        block0: {
            ExecutorService executorService = this$0.executor;
            if (executorService == null) break block0;
            executorService.execute(() -> GlStreamInterface.start$lambda$3$lambda$2$lambda$1(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$3(GlStreamInterface this$0) {
        this$0.surfaceManager.makeCurrent();
        this$0.mainRender.initGl(this$0.context, this$0.encoderWidth, this$0.encoderHeight, this$0.encoderWidth, this$0.encoderHeight);
        this$0.running.set(true);
        this$0.mainRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this$0);
        this$0.forceRender.start((Function0<Unit>)((Function0)() -> GlStreamInterface.start$lambda$3$lambda$2(this$0)));
        return Unit.INSTANCE;
    }

    private static final void onFrameAvailable$lambda$4(GlStreamInterface this$0) {
        try {
            this$0.draw(false);
        }
        catch (RuntimeException e) {
            RenderErrorCallback renderErrorCallback = this$0.renderErrorCallback;
            if (renderErrorCallback != null) {
                renderErrorCallback.onRenderError(e);
            }
            throw e;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrientationForced.values().length];
            try {
                nArray[OrientationForced.PORTRAIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrientationForced.LANDSCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrientationForced.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

