/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.TimeUtils;
import com.pedro.encoder.CodecErrorCallback;
import com.pedro.encoder.TimestampMode;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AacMuxerRecordController;
import com.pedro.library.util.streamclient.StreamBaseClient;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class OnlyAudioBase {
    protected BaseRecordController recordController;
    private final MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private final GetMicrophoneData getMicrophoneData = frame -> this.audioEncoder.inputPCMData(frame);
    private final GetAudioData getAudioData = new GetAudioData(){

        public void getAudioData(@NonNull ByteBuffer audioBuffer, @NonNull MediaCodec.BufferInfo info) {
            if (Build.VERSION.SDK_INT >= 18) {
                OnlyAudioBase.this.recordController.recordAudio(audioBuffer, info);
            }
            if (OnlyAudioBase.this.streaming) {
                OnlyAudioBase.this.getAudioDataImp(audioBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            OnlyAudioBase.this.recordController.setAudioFormat(mediaFormat, true);
        }
    };

    public OnlyAudioBase() {
        this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
        this.audioEncoder = new AudioEncoder(this.getAudioData);
        this.recordController = new AacMuxerRecordController();
    }

    public void setTimestampMode(TimestampMode timestampModeAudio) {
        this.audioEncoder.setTimestampMode(timestampModeAudio);
    }

    public void setEncoderErrorCallback(CodecErrorCallback encoderErrorCallback) {
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void forceCodecType(CodecUtil.CodecType codecTypeAudio) {
        this.audioEncoder.forceCodecType(codecTypeAudio);
    }

    protected abstract void onAudioInfoImp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.onAudioInfoImp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    @RequiresApi(api=18)
    public void startRecord(String path, RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        }
    }

    @RequiresApi(api=18)
    public void startRecord(String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamImp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        }
        this.startStreamImp(url);
    }

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamImp();
        }
        if (!this.recordController.isRecording()) {
            this.microphoneManager.stop();
            this.audioEncoder.stop();
            this.recordController.resetFormats();
        }
    }

    private void startEncoders() {
        long startTs = TimeUtils.getCurrentTimeMicro();
        this.audioEncoder.start(startTs);
        this.microphoneManager.start();
    }

    protected abstract void stopStreamImp();

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean resetAudioEncoder() {
        return this.audioEncoder.reset();
    }

    protected abstract void getAudioDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract StreamBaseClient getStreamClient();

    public void setAudioCodec(AudioCodec codec) {
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case AudioCodec.G711 -> "audio/g711-alaw";
            case AudioCodec.AAC -> "audio/mp4a-latm";
            case AudioCodec.OPUS -> "audio/opus";
        };
        this.audioEncoder.setType(type);
    }

    protected abstract void setAudioCodecImp(AudioCodec var1);
}

