/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.BitrateChecker;
import com.pedro.common.BitrateManager;
import com.pedro.common.ExtensionsKt;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class AndroidMuxerWebmRecordController
extends BaseRecordController {
    private MediaMuxer mediaMuxer;
    private MediaFormat audioFormat;
    private final int outputFormat = 1;

    @Override
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        if (this.audioCodec != AudioCodec.OPUS) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.mediaMuxer = new MediaMuxer(path, 1);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        if (this.audioFormat != null) {
            this.init();
        }
    }

    @Override
    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        if (this.audioCodec != AudioCodec.OPUS) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.mediaMuxer = new MediaMuxer(fd, 1);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            this.bitrateManager = new BitrateManager((BitrateChecker)listener);
            listener.onStatusChange(this.status);
        } else {
            this.bitrateManager = null;
        }
        if (this.audioFormat != null) {
            this.init();
        }
    }

    @Override
    public void stopRecord() {
        this.videoTrack = -1;
        this.audioTrack = -1;
        this.status = RecordController.Status.STOPPED;
        if (this.mediaMuxer != null) {
            try {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mediaMuxer = null;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        this.startTs = 0L;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @Override
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
    }

    @Override
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == RecordController.Status.RECORDING) {
            this.updateFormat(this.audioInfo, audioInfo);
            this.write(this.audioTrack, audioBuffer, this.audioInfo);
        }
    }

    @Override
    public void setVideoFormat(MediaFormat videoFormat, boolean isOnlyVideo) {
    }

    @Override
    public void setAudioFormat(MediaFormat audioFormat, boolean isOnlyAudio) {
        this.audioFormat = audioFormat;
        if (this.status == RecordController.Status.STARTED && Build.VERSION.SDK_INT >= 18) {
            this.init();
        }
    }

    @Override
    public void resetFormats() {
        this.audioFormat = null;
    }

    private void init() {
        this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        this.mediaMuxer.start();
        this.status = RecordController.Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    private void write(int track, ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        block3: {
            try {
                this.mediaMuxer.writeSampleData(track, byteBuffer, info);
                if (this.bitrateManager != null) {
                    this.bitrateManager.calculateBitrate((long)info.size * 8L, ExtensionsKt.getSuspendContext());
                }
            }
            catch (Exception e) {
                if (this.listener == null) break block3;
                this.listener.onError(e);
            }
        }
    }
}

