/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.rtsp.RtspCamera2;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0011\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J$\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u00162\b\u0010 \u001a\u0004\u0018\u00010\u0016H\u0014J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010&\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020\u0014H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006."}, d2={"Lcom/pedro/library/rtsp/RtspCamera2;", "Lcom/pedro/library/base/Camera2Base;", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;)V", "context", "Landroid/content/Context;", "useOpengl", "", "(Landroid/content/Context;ZLcom/pedro/common/ConnectChecker;)V", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "streamClient", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "streamClientListener", "com/pedro/library/rtsp/RtspCamera2$streamClientListener$1", "Lcom/pedro/library/rtsp/RtspCamera2$streamClientListener$1;", "getAacDataRtp", "", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "getStreamClient", "init", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudioRtp", "isStereo", "sampleRate", "", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "Lcom/pedro/common/VideoCodec;", "startStreamRtp", "url", "", "stopStreamRtp", "library_release"})
@RequiresApi(api=21)
public final class RtspCamera2
extends Camera2Base {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private RtspClient rtspClient;
    private RtspStreamClient streamClient;

    public RtspCamera2(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(openGlView);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtspCamera2 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.init(connectChecker);
    }

    public RtspCamera2(@NotNull Context context, boolean useOpengl, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(context, useOpengl);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.rtspClient = new RtspClient(connectChecker);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        this.streamClient = new RtspStreamClient(rtspClient, this.streamClientListener);
    }

    @Override
    @NotNull
    public RtspStreamClient getStreamClient() {
        RtspStreamClient rtspStreamClient = this.streamClient;
        if (rtspStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            rtspStreamClient = null;
        }
        return rtspStreamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.sendVideo(h264Buffer, info);
    }
}

