/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AndroidMuxerRecordController
extends BaseRecordController {
    private static final String TAG = "AndroidRecordController";
    private MediaMuxer mediaMuxer;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;

    @Override
    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        if (this.audioCodec == AudioCodec.G711 || this.audioCodec == AudioCodec.OPUS) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.isOnlyAudio && this.audioFormat != null) {
            this.init();
        }
    }

    @Override
    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        if (this.audioCodec == AudioCodec.G711 || this.audioCodec == AudioCodec.OPUS) {
            throw new IOException("Unsupported AudioCodec: " + this.audioCodec.name());
        }
        this.mediaMuxer = new MediaMuxer(fd, 0);
        this.listener = listener;
        this.status = RecordController.Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.isOnlyAudio && this.audioFormat != null) {
            this.init();
        }
    }

    @Override
    @RequiresApi(api=18)
    public void stopRecord() {
        this.videoTrack = -1;
        this.audioTrack = -1;
        this.status = RecordController.Status.STOPPED;
        if (this.mediaMuxer != null) {
            try {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mediaMuxer = null;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @Override
    @RequiresApi(api=18)
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
        if (this.status == RecordController.Status.STARTED && this.videoFormat != null && (this.audioFormat != null || this.isOnlyVideo)) {
            if (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer)) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
                this.init();
            }
        } else if (this.status == RecordController.Status.RESUMED && (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer))) {
            this.status = RecordController.Status.RECORDING;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
        if (this.status == RecordController.Status.RECORDING) {
            this.updateFormat(this.videoInfo, videoInfo);
            this.write(this.videoTrack, videoBuffer, this.videoInfo);
        }
    }

    @Override
    @RequiresApi(api=18)
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == RecordController.Status.RECORDING) {
            this.updateFormat(this.audioInfo, audioInfo);
            this.write(this.audioTrack, audioBuffer, this.audioInfo);
        }
    }

    @Override
    public void setVideoFormat(MediaFormat videoFormat, boolean isOnlyVideo) {
        this.videoFormat = videoFormat;
        this.isOnlyVideo = isOnlyVideo;
    }

    @Override
    public void setAudioFormat(MediaFormat audioFormat, boolean isOnlyAudio) {
        this.audioFormat = audioFormat;
        this.isOnlyAudio = isOnlyAudio;
        if (isOnlyAudio && this.status == RecordController.Status.STARTED && Build.VERSION.SDK_INT >= 18) {
            this.init();
        }
    }

    @Override
    public void resetFormats() {
        this.videoFormat = null;
        this.audioFormat = null;
    }

    @RequiresApi(api=18)
    private void init() {
        if (!this.isOnlyVideo) {
            this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        }
        this.mediaMuxer.start();
        this.status = RecordController.Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @RequiresApi(api=18)
    private void write(int track, ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        try {
            this.mediaMuxer.writeSampleData(track, byteBuffer, info);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            Log.i((String)TAG, (String)"Write error", (Throwable)e);
        }
    }
}

