/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.udp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.udp.UdpFromFile;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.library.view.OpenGlView;
import com.pedro.udp.UdpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0012\b\u0007\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rB\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J$\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u00192\b\u0010#\u001a\u0004\u0018\u00010\u0019H\u0014J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010*\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u00020\u0017H\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/pedro/library/udp/UdpFromFile;", "Lcom/pedro/library/base/FromFileBase;", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "videoDecoderInterface", "Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;", "audioDecoderInterface", "Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "streamClient", "Lcom/pedro/library/util/streamclient/UdpStreamClient;", "streamClientListener", "com/pedro/library/udp/UdpFromFile$streamClientListener$1", "Lcom/pedro/library/udp/UdpFromFile$streamClientListener$1;", "udpClient", "Lcom/pedro/udp/UdpClient;", "getAacDataRtp", "", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "getStreamClient", "init", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudioRtp", "isStereo", "", "sampleRate", "", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "Lcom/pedro/common/VideoCodec;", "startStreamRtp", "url", "", "stopStreamRtp", "library_release"})
@RequiresApi(api=18)
public final class UdpFromFile
extends FromFileBase {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private UdpClient udpClient;
    private UdpStreamClient streamClient;

    public UdpFromFile(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ UdpFromFile this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.init(connectChecker);
    }

    public UdpFromFile(@NotNull Context context, @NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    public UdpFromFile(@NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.udpClient = new UdpClient(connectChecker);
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        this.streamClient = new UdpStreamClient(udpClient, this.streamClientListener);
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setAudioCodec(codec);
    }

    @Override
    @NotNull
    public UdpStreamClient getStreamClient() {
        UdpStreamClient udpStreamClient = this.streamClient;
        if (udpStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            udpStreamClient = null;
        }
        return udpStreamClient;
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        UdpClient.connect$default((UdpClient)udpClient, (String)url, (boolean)false, (int)2, null);
    }

    @Override
    protected void stopStreamRtp() {
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        UdpClient udpClient = this.udpClient;
        if (udpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"udpClient");
            udpClient = null;
        }
        udpClient.sendAudio(aacBuffer, info);
    }
}

