/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.generic;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.DisplayBase;
import com.pedro.library.generic.ClientType;
import com.pedro.library.generic.GenericDisplay;
import com.pedro.library.util.streamclient.GenericStreamClient;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import com.pedro.udp.UdpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0014\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010 \u001a\u00020\u0012H\u0016J$\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001bH\u0014J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u00020\u0019H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/pedro/library/generic/GenericDisplay;", "Lcom/pedro/library/base/DisplayBase;", "context", "Landroid/content/Context;", "useOpengl", "", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "(Landroid/content/Context;ZLcom/pedro/common/ConnectChecker;)V", "connectedType", "Lcom/pedro/library/generic/ClientType;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "streamClient", "Lcom/pedro/library/util/streamclient/GenericStreamClient;", "streamClientListener", "com/pedro/library/generic/GenericDisplay$streamClientListener$1", "Lcom/pedro/library/generic/GenericDisplay$streamClientListener$1;", "udpClient", "Lcom/pedro/udp/UdpClient;", "getAacDataRtp", "", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "getStreamClient", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudioRtp", "isStereo", "sampleRate", "", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "Lcom/pedro/common/VideoCodec;", "startStreamRtp", "url", "", "stopStreamRtp", "library_release"})
@RequiresApi(api=21)
public final class GenericDisplay
extends DisplayBase {
    @NotNull
    private final ConnectChecker connectChecker;
    @NotNull
    private final streamClientListener.1 streamClientListener;
    @NotNull
    private final RtmpClient rtmpClient;
    @NotNull
    private final RtspClient rtspClient;
    @NotNull
    private final SrtClient srtClient;
    @NotNull
    private final UdpClient udpClient;
    @NotNull
    private final GenericStreamClient streamClient;
    @NotNull
    private ClientType connectedType;

    public GenericDisplay(@NotNull Context context, boolean useOpengl, @NotNull ConnectChecker connectChecker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        super(context, useOpengl);
        this.connectChecker = connectChecker;
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ GenericDisplay this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.rtmpClient = new RtmpClient(this.connectChecker);
        this.rtspClient = new RtspClient(this.connectChecker);
        this.srtClient = new SrtClient(this.connectChecker);
        this.udpClient = new UdpClient(this.connectChecker);
        this.streamClient = new GenericStreamClient(new RtmpStreamClient(this.rtmpClient, this.streamClientListener), new RtspStreamClient(this.rtspClient, this.streamClientListener), new SrtStreamClient(this.srtClient, this.streamClientListener), new UdpStreamClient(this.udpClient, this.streamClientListener));
        this.connectedType = ClientType.NONE;
    }

    @Override
    @NotNull
    public GenericStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != VideoCodec.H264 && codec != VideoCodec.H265) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support video H264 and H265");
        }
        this.rtmpClient.setVideoCodec(codec);
        this.rtspClient.setVideoCodec(codec);
        this.srtClient.setVideoCodec(codec);
        this.udpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != AudioCodec.AAC) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support audio AAC");
        }
        this.rtmpClient.setAudioCodec(codec);
        this.rtspClient.setAudioCodec(codec);
        this.srtClient.setAudioCodec(codec);
        this.udpClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
        this.srtClient.setAudioInfo(sampleRate, isStereo);
        this.udpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.streamClient.connecting(url);
        if (StringsKt.startsWith((String)url, (String)"rtmp", (boolean)true)) {
            this.connectedType = ClientType.RTMP;
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.rtmpClient.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.rtmpClient.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.rtmpClient.setFps(this.videoEncoder.getFps());
            this.rtmpClient.connect(url);
        } else if (StringsKt.startsWith((String)url, (String)"rtsp", (boolean)true)) {
            this.connectedType = ClientType.RTSP;
            this.rtspClient.connect(url);
        } else if (StringsKt.startsWith((String)url, (String)"srt", (boolean)true)) {
            this.connectedType = ClientType.SRT;
            SrtClient.connect$default((SrtClient)this.srtClient, (String)url, (boolean)false, (int)2, null);
        } else if (StringsKt.startsWith((String)url, (String)"udp", (boolean)true)) {
            this.connectedType = ClientType.UDP;
            UdpClient.connect$default((UdpClient)this.udpClient, (String)url, (boolean)false, (int)2, null);
        } else {
            ExtensionsKt.onMainThreadHandler((Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GenericDisplay this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GenericDisplay.access$getConnectChecker$p(this.this$0).onConnectionFailed("Unsupported protocol. Only support rtmp, rtsp and srt");
                }
            }));
        }
    }

    @Override
    protected void stopStreamRtp() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.disconnect();
                break;
            }
            case 2: {
                this.rtspClient.disconnect();
                break;
            }
            case 3: {
                this.srtClient.disconnect();
                break;
            }
            case 4: {
                this.udpClient.disconnect();
            }
        }
        this.connectedType = ClientType.NONE;
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.sendAudio(aacBuffer, info);
                break;
            }
            case 2: {
                this.rtspClient.sendAudio(aacBuffer, info);
                break;
            }
            case 3: {
                this.srtClient.sendAudio(aacBuffer, info);
                break;
            }
            case 4: {
                this.udpClient.sendAudio(aacBuffer, info);
            }
        }
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.rtmpClient.setVideoInfo(sps, pps, vps);
        this.rtspClient.setVideoInfo(sps, pps, vps);
        this.srtClient.setVideoInfo(sps, pps, vps);
        this.udpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                this.rtmpClient.sendVideo(h264Buffer, info);
                break;
            }
            case 2: {
                this.rtspClient.sendVideo(h264Buffer, info);
                break;
            }
            case 3: {
                this.srtClient.sendVideo(h264Buffer, info);
                break;
            }
            case 4: {
                this.udpClient.sendVideo(h264Buffer, info);
            }
        }
    }

    public static final /* synthetic */ ConnectChecker access$getConnectChecker$p(GenericDisplay $this) {
        return $this.connectChecker;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientType.values().length];
            try {
                nArray[ClientType.RTMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.RTSP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.SRT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.UDP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

